/*
 * Decompiled with CFR 0.152.
 */
package dev.tianmi.sussypatches.common.helper;

import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import dev.tianmi.sussypatches.api.core.mixin.extension.QChestCDExtension;
import dev.tianmi.sussypatches.core.mixin.feature.interactivestorage.CreativeChestAccessor;
import gregtech.api.items.itemhandlers.GTItemStackHandler;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.util.GTTransferUtils;
import gregtech.api.util.GTUtility;
import gregtech.common.metatileentities.storage.MetaTileEntityCreativeChest;
import gregtech.common.metatileentities.storage.MetaTileEntityQuantumChest;
import java.util.EnumMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import org.jetbrains.annotations.NotNull;

public class QChestInteractions {
    public static final int COOL_DOWN = 10;
    public static final int NORMAL_CLICK_THRESHOLD = 8;
    public static final int TRANSFER_ALL_THRESHOLD = 5;
    private static final EnumMap<EnumFacing, IndexedCuboid6> HITBOXES = new EnumMap(EnumFacing.class);

    @SubscribeEvent
    public static void onBlockLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        MetaTileEntityQuantumChest qChest;
        if (event.isCanceled()) {
            return;
        }
        EnumFacing hitFace = event.getFace();
        if (hitFace == null) {
            return;
        }
        BlockPos pos = event.getPos();
        MetaTileEntity mte = GTUtility.getMetaTileEntity((IBlockAccess)event.getWorld(), (BlockPos)pos);
        if (mte instanceof MetaTileEntityQuantumChest && hitFace == (qChest = (MetaTileEntityQuantumChest)mte).getFrontFacing() && qChest.getCoverAtSide(hitFace) == null) {
            EntityPlayer player = event.getEntityPlayer();
            RayTraceResult rayTraceResult = QChestInteractions.traceCuboidAt(pos, player, hitFace);
            if (rayTraceResult == null) {
                return;
            }
            event.setCanceled(true);
            if (qChest instanceof MetaTileEntityCreativeChest) {
                MetaTileEntityCreativeChest cChest = (MetaTileEntityCreativeChest)qChest;
                QChestInteractions.cChestLeftClick(cChest, player);
            } else {
                QChestInteractions.qChestLeftClick(qChest, player);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
        MetaTileEntityQuantumChest qChest;
        if (event.isCanceled() || event.getSide() != Side.SERVER) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        if (player.isSneaking()) {
            return;
        }
        EnumFacing hitFace = event.getFace();
        if (hitFace == null) {
            return;
        }
        BlockPos pos = event.getPos();
        MetaTileEntity mte = GTUtility.getMetaTileEntity((IBlockAccess)event.getWorld(), (BlockPos)pos);
        if (mte instanceof MetaTileEntityQuantumChest && hitFace == (qChest = (MetaTileEntityQuantumChest)mte).getFrontFacing() && qChest.getCoverAtSide(hitFace) == null) {
            RayTraceResult rayTraceResult = QChestInteractions.traceCuboidAt(pos, player, hitFace);
            if (rayTraceResult == null) {
                return;
            }
            if (QChestInteractions.qChestRightClick(qChest, player, event.getHand())) {
                event.setCanceled(true);
            } else {
                event.setUseBlock(Event.Result.DENY);
                event.setUseItem(Event.Result.DENY);
            }
        }
    }

    private static RayTraceResult traceCuboidAt(BlockPos pos, EntityPlayer player, EnumFacing facing) {
        return RayTracer.rayTrace((BlockPos)pos, (Vector3)new Vector3(RayTracer.getStartVec((EntityPlayer)player)), (Vector3)new Vector3(RayTracer.getEndVec((EntityPlayer)player)), (IndexedCuboid6)HITBOXES.get(facing));
    }

    public static void qChestLeftClick(MetaTileEntityQuantumChest qChest, EntityPlayer player) {
        IItemHandler qChestInv = qChest.getOutputItemInventory();
        QChestCDExtension qExtension = QChestCDExtension.cast(qChest);
        int coolDown = qExtension.sus$getCoolDown();
        qExtension.sus$refreshCoolDown();
        if (coolDown > 8) {
            return;
        }
        ItemStack candidate = qChestInv.extractItem(0, 1, true);
        if (candidate.isEmpty()) {
            return;
        }
        ItemStack stack = qChestInv.extractItem(0, player.isSneaking() ? candidate.getMaxStackSize() : 1, false);
        QChestInteractions.giveItemToPlayer(player, stack, player.inventory.currentItem, qChest.getPos().offset(qChest.getFrontFacing()));
    }

    public static void cChestLeftClick(MetaTileEntityCreativeChest cChest, EntityPlayer player) {
        GTItemStackHandler cChestInv = ((CreativeChestAccessor)cChest).getHandler();
        QChestCDExtension cExtension = QChestCDExtension.cast((MetaTileEntityQuantumChest)cChest);
        int coolDown = cExtension.sus$getCoolDown();
        cExtension.sus$refreshCoolDown();
        if (coolDown > 8) {
            return;
        }
        ItemStack stack = cChestInv.getStackInSlot(0).copy();
        stack.setCount(player.isSneaking() ? stack.getMaxStackSize() : 1);
        QChestInteractions.giveItemToPlayer(player, stack, player.inventory.currentItem, cChest.getPos().offset(cChest.getFrontFacing()));
    }

    public static boolean qChestRightClick(MetaTileEntityQuantumChest qChest, EntityPlayer player, EnumHand hand) {
        IItemHandler qChestInv = qChest.getCombinedInventory();
        QChestCDExtension qExtension = QChestCDExtension.cast(qChest);
        int coolDown = qExtension.sus$getCoolDown();
        qExtension.sus$refreshCoolDown();
        if (coolDown > 8) {
            return false;
        }
        if (coolDown > 5) {
            ItemStack candidate = qChestInv.extractItem(0, 1, true);
            if (candidate.isEmpty()) {
                return false;
            }
            PlayerMainInvWrapper playerInv = new PlayerMainInvWrapper(player.inventory);
            GTTransferUtils.moveInventoryItems((IItemHandler)playerInv, (IItemHandler)qChestInv);
            return true;
        }
        ItemStack sourceStack = player.getHeldItem(hand);
        if (sourceStack.isEmpty()) {
            return false;
        }
        ItemStack candidate = qChestInv.insertItem(1, sourceStack, true);
        if (sourceStack.getCount() == candidate.getCount()) {
            return false;
        }
        ItemStack remining = qChestInv.insertItem(1, sourceStack, false);
        sourceStack.setCount(remining.getCount());
        return true;
    }

    private static void giveItemToPlayer(EntityPlayer player, @NotNull ItemStack stack, int preferredSlot, BlockPos dropPos) {
        if (stack.isEmpty()) {
            return;
        }
        stack.setAnimationsToGo(5);
        PlayerMainInvWrapper inventory = new PlayerMainInvWrapper(player.inventory);
        World world = player.world;
        ItemStack remainder = stack;
        if (preferredSlot >= 0 && preferredSlot < inventory.getSlots()) {
            remainder = inventory.insertItem(preferredSlot, stack, false);
        }
        if (!remainder.isEmpty()) {
            remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)remainder, (boolean)false);
        }
        double x = (double)dropPos.getX() + 0.5;
        double y = (double)dropPos.getY() + 0.5;
        double z = (double)dropPos.getZ() + 0.5;
        if (remainder.isEmpty() || remainder.getCount() != stack.getCount()) {
            world.playSound(null, x, y, z, SoundEvents.ENTITY_ITEM_PICKUP, SoundCategory.PLAYERS, 0.2f, ((world.rand.nextFloat() - world.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
        if (!remainder.isEmpty()) {
            EntityItem entityItem = new EntityItem(world, x, y, z, remainder);
            entityItem.setPickupDelay(40);
            entityItem.motionX = 0.0;
            entityItem.motionY = 0.0;
            entityItem.motionZ = 0.0;
            world.spawnEntity((Entity)entityItem);
        }
    }

    static {
        HITBOXES.put(EnumFacing.UP, new IndexedCuboid6(null, new Cuboid6(0.125, 0.9375, 0.125, 0.875, 0.9375, 0.875)));
        HITBOXES.put(EnumFacing.DOWN, new IndexedCuboid6(null, new Cuboid6(0.125, 0.0625, 0.125, 0.875, 0.0625, 0.875)));
        HITBOXES.put(EnumFacing.WEST, new IndexedCuboid6(null, new Cuboid6(0.0625, 0.125, 0.125, 0.0625, 0.875, 0.875)));
        HITBOXES.put(EnumFacing.EAST, new IndexedCuboid6(null, new Cuboid6(0.9375, 0.125, 0.125, 0.9375, 0.875, 0.875)));
        HITBOXES.put(EnumFacing.SOUTH, new IndexedCuboid6(null, new Cuboid6(0.125, 0.125, 0.9375, 0.875, 0.875, 0.9375)));
        HITBOXES.put(EnumFacing.NORTH, new IndexedCuboid6(null, new Cuboid6(0.125, 0.125, 0.0625, 0.875, 0.875, 0.0625)));
    }
}

