/*
 * Decompiled with CFR 0.152.
 */
package dev.tianmi.sussypatches.common.helper;

import dev.tianmi.sussypatches.api.core.mixin.extension.ChunkAwareExtension;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ChunkAwareHook {
    @SubscribeEvent
    public static void onChunkLoadUnload(ChunkEvent event) {
        boolean isLoad = event instanceof ChunkEvent.Load;
        boolean isUnLoad = event instanceof ChunkEvent.Unload;
        if (!isLoad && !isUnLoad) {
            return;
        }
        World world = event.getWorld();
        Chunk chunk = event.getChunk();
        int x = chunk.field_76635_g;
        int z = chunk.field_76647_h;
        IChunkProvider chunkProvider = world.func_72863_F();
        for (EnumFacing side : EnumFacing.field_176754_o) {
            Chunk nearbyChunk = chunkProvider.func_186026_b(x + side.func_82601_c(), z + side.func_82599_e());
            if (nearbyChunk == null || !nearbyChunk.func_177410_o()) continue;
            nearbyChunk.func_177434_r().forEach((pos, tile) -> {
                if (tile instanceof ChunkAwareExtension) {
                    ChunkAwareExtension chunkAware = (ChunkAwareExtension)tile;
                    if (ChunkAwareHook.isNextToChunkAtSide(pos, x, z, side)) {
                        if (isLoad) {
                            chunkAware.onNeighborChunkLoad(side.func_176734_d());
                        }
                        if (isUnLoad) {
                            chunkAware.onNeighborChunkUnload(side.func_176734_d());
                        }
                    }
                }
            });
        }
    }

    private static boolean isNextToChunkAtSide(BlockPos pos, int chunkX, int chunkZ, EnumFacing side) {
        boolean bl;
        int minX = chunkX * 16;
        int minZ = chunkZ * 16;
        switch (side) {
            case EAST: {
                if (pos.func_177958_n() - minX == -1) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case WEST: {
                if (pos.func_177958_n() - minX == 16) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case NORTH: {
                if (pos.func_177952_p() - minZ == -1) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case SOUTH: {
                if (pos.func_177952_p() - minZ == 16) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }
}

