/*
 * Decompiled with CFR 0.152.
 */
package io.github.markassk.fishonmcextras;

import io.github.markassk.fishonmcextras.commands.CommandRegistration;
import io.github.markassk.fishonmcextras.config.FishOnMCExtrasConfig;
import io.github.markassk.fishonmcextras.handler.LookTickHandler;
import io.github.markassk.fishonmcextras.hud.HudRenderer;
import io.github.markassk.fishonmcextras.screen.PetMergeCalculatorScreen;
import io.github.markassk.fishonmcextras.tooltip.TooltipPetRating;
import io.github.markassk.fishonmcextras.trackers.EquippedPetTracker;
import io.github.markassk.fishonmcextras.trackers.FishTracker;
import java.util.Objects;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_634;
import net.minecraft.class_7919;

public class FishOnMCExtrasClient
implements ClientModInitializer {
    public static FishOnMCExtrasConfig CONFIG;
    public static class_304 openConfigKeybind;
    public static final HudRenderer HUD_RENDERER;
    public static final FishTracker fishTracker;
    private static boolean menuOpened;
    private static long lastMenuCloseTime;

    public void onInitializeClient() {
        AutoConfig.register(FishOnMCExtrasConfig.class, GsonConfigSerializer::new);
        CONFIG = (FishOnMCExtrasConfig)AutoConfig.getConfigHolder(FishOnMCExtrasConfig.class).getConfig();
        openConfigKeybind = new class_304("key.fishonmcextras.openconfig", class_3675.class_307.field_1668, 79, "category.fishonmcextras.general");
        KeyBindingHelper.registerKeyBinding((class_304)openConfigKeybind);
        ClientTickEvents.END_CLIENT_TICK.register(minecraftClient -> {
            if (minecraftClient.field_1724 != null && minecraftClient.field_1755 == null) {
                while (openConfigKeybind.method_1436()) {
                    minecraftClient.method_1507((class_437)AutoConfig.getConfigScreen(FishOnMCExtrasConfig.class, (class_437)minecraftClient.field_1755).get());
                }
            }
        });
        EquippedPetTracker.initialize();
        CommandRegistration.initialize();
        HudRenderCallback.EVENT.register((Object)HUD_RENDERER);
        HUD_RENDERER.loadStats();
        ClientPlayConnectionEvents.JOIN.register(this::onServerJoin);
        ClientTickEvents.END_CLIENT_TICK.register(this::onClientTick);
        ScreenEvents.BEFORE_INIT.register(this::beforeScreenOpen);
        ScreenEvents.AFTER_INIT.register(this::afterScreenOpen);
        ItemTooltipCallback.EVENT.register((stack, context, type, lines) -> {
            lines = TooltipPetRating.appendTooltipRating(lines, stack);
        });
        ClientReceiveMessageEvents.MODIFY_GAME.register((message, overlay) -> TooltipPetRating.appendTooltipRating(message));
    }

    private void onClientTick(class_310 client) {
        fishTracker.tick(client, menuOpened, lastMenuCloseTime);
        LookTickHandler.instance().tickClient();
    }

    private void onServerJoin(class_634 handler, PacketSender sender, class_310 client) {
        client.execute(() -> fishTracker.updateWorldContext(client));
    }

    private void afterScreenOpen(class_310 client, class_437 screen, int scaledWidth, int scaledHeight) {
        if (Objects.equals(screen.method_25440().getString(), "Pet Menu\ueee6\ueee5\ueee3\ud551")) {
            Screens.getButtons((class_437)screen).add(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Pet Merge Calculator"), button -> {
                assert (client.field_1724 != null);
                client.method_1507((class_437)new PetMergeCalculatorScreen((class_1657)client.field_1724, client.field_1755));
            }).method_46434(scaledWidth / 2 - 65, scaledHeight / 2 + 120, 130, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Open up the screen to calculate pet merging."))).method_46431());
        }
    }

    private void beforeScreenOpen(class_310 client, class_437 screen, int scaledWidth, int scaledHeight) {
        menuOpened = true;
        ScreenEvents.remove((class_437)screen).register(removedScreen -> {
            menuOpened = false;
            lastMenuCloseTime = System.currentTimeMillis();
        });
    }

    static {
        HUD_RENDERER = new HudRenderer();
        fishTracker = new FishTracker(HUD_RENDERER);
        menuOpened = false;
        lastMenuCloseTime = 0L;
    }
}

