/*
 * Decompiled with CFR 0.152.
 */
package io.github.markassk.fishonmcextras.handler;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.markassk.fishonmcextras.model_types.PetStats;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class PetMergeCalculatorHandler {
    private static PetMergeCalculatorHandler INSTANCE = new PetMergeCalculatorHandler();
    public class_1799[] selectedPets = new class_1799[]{null, null};
    public PetStats petOne;
    public PetStats petTwo;
    public PetStats calculatedPet = null;
    public int[] index = new int[]{-1, -1};

    public static PetMergeCalculatorHandler instance() {
        if (INSTANCE == null) {
            INSTANCE = new PetMergeCalculatorHandler();
        }
        return INSTANCE;
    }

    public void setPet(class_1799 pet, int list) {
        this.selectedPets[list] = pet;
        this.update();
    }

    public void setIndex(int list, int index) {
        this.index[list] = index;
    }

    public void reset() {
        this.selectedPets = new class_1799[]{null, null};
        this.petOne = null;
        this.petTwo = null;
        this.index = new int[]{-1, -1};
    }

    private void update() {
        if (this.selectedPets[0] != null) {
            class_2487 componentOne = this.getNbt(this.selectedPets[0]);
            assert (componentOne != null);
            this.petOne = PetStats.getStats(componentOne, PetMergeCalculatorHandler.getRatingFromJson(PetMergeCalculatorHandler.petToJson(this.selectedPets[0])));
        }
        if (this.selectedPets[1] != null) {
            class_2487 componentTwo = this.getNbt(this.selectedPets[1]);
            assert (componentTwo != null);
            this.petTwo = PetStats.getStats(componentTwo, PetMergeCalculatorHandler.getRatingFromJson(PetMergeCalculatorHandler.petToJson(this.selectedPets[1])));
        }
        if (this.selectedPets[0] != null && this.selectedPets[1] != null) {
            this.calculatedPet = this.calculatePet(this.petOne, this.petTwo);
        }
    }

    private PetStats calculatePet(PetStats petOne, PetStats petTwo) {
        if (Objects.equals(petOne.getRarity(), petTwo.getRarity())) {
            String petResultRarity = PetMergeCalculatorHandler.rarityUpgrade(petOne.getRarity());
            float petMultiplier = PetMergeCalculatorHandler.rarityMultiplier(petOne.getRarity());
            float petResultMultiplier = PetMergeCalculatorHandler.rarityMultiplier(PetMergeCalculatorHandler.rarityUpgrade(petOne.getRarity()));
            float petResultlLuck = (petOne.getlLuck() / petMultiplier + petTwo.getlLuck() / petMultiplier) / 2.0f * petResultMultiplier;
            float petResultlScale = (petOne.getlScale() / petMultiplier + petTwo.getlScale() / petMultiplier) / 2.0f * petResultMultiplier;
            float petResultcLuck = (petOne.getcLuck() / petMultiplier + petTwo.getcLuck() / petMultiplier) / 2.0f * petResultMultiplier;
            float petResultcScale = (petOne.getcScale() / petMultiplier + petTwo.getcScale() / petMultiplier) / 2.0f * petResultMultiplier;
            float petResultlLuckPercent = (petOne.getlLuckPercent() + petTwo.getlLuckPercent()) / 2.0f;
            float petResultlScalePercent = (petOne.getlScalePercent() + petTwo.getlScalePercent()) / 2.0f;
            float petResultcLuckPercent = (petOne.getcLuckPercent() + petTwo.getcLuckPercent()) / 2.0f;
            float petResultcScalePercent = (petOne.getcScalePercent() + petTwo.getcScalePercent()) / 2.0f;
            return new PetStats((String)(Objects.equals(petOne.getName(), petTwo.getName()) ? petOne.getName() : petOne.getName() + " + " + petTwo.getName()), petResultRarity, petResultlLuck, petResultlScale, petResultcLuck, petResultcScale, petResultlLuckPercent, petResultlScalePercent, petResultcLuckPercent, petResultcScalePercent);
        }
        return null;
    }

    public static String ratingValue(float value) {
        BigDecimal decimal = new BigDecimal(Float.toString(value));
        if ((decimal = decimal.setScale(2, RoundingMode.HALF_EVEN)).floatValue() <= 20.0f) {
            return "Sickly";
        }
        if (decimal.floatValue() < 30.0f) {
            return "Bad";
        }
        if (decimal.floatValue() < 40.0f) {
            return "Below Average";
        }
        if (decimal.floatValue() < 50.0f) {
            return "Average";
        }
        if (decimal.floatValue() < 60.0f) {
            return "Good";
        }
        if (decimal.floatValue() < 80.0f) {
            return "Great";
        }
        if (decimal.floatValue() < 90.0f) {
            return "Excellent";
        }
        if (decimal.floatValue() < 100.0f) {
            return "Amazing";
        }
        if (decimal.floatValue() < 101.0f) {
            return "Perfect";
        }
        return "Wrong Rarity Selected";
    }

    public static String getRatingFromJson(String json) {
        if (json.contains("\u0455\u026a\u1d04\u1d0b\u029f\u028f")) {
            return "Sickly";
        }
        if (json.contains("\u0299\u1d00\u1d05")) {
            return "Bad";
        }
        if (json.contains("\u0299\u1d07\u029f\u1d0f\u1d21 \u1d00\u1d20\u1d07\u0280\u1d00\u0262\u1d07")) {
            return "Below Average";
        }
        if (json.contains("\u1d00\u1d20\u1d07\u0280\u1d00\u0262\u1d07")) {
            return "Average";
        }
        if (json.contains("\u0262\u1d0f\u1d0f\u1d05")) {
            return "Good";
        }
        if (json.contains("\u0262\u0280\u1d07\u1d00\u1d1b")) {
            return "Great";
        }
        if (json.contains("\u1d07x\u1d04\u1d07\u029f\u029f\u1d07\u0274\u1d1b")) {
            return "Excellent";
        }
        if (json.contains("\u1d00\u1d0d\u1d00\u1d22\u026a\u0274\u0262")) {
            return "Amazing";
        }
        if (json.contains("\u1d18\u1d07\u0280\ua730\u1d07\u1d04\u1d1b")) {
            return "Perfect";
        }
        return "";
    }

    public static Object[] ratingString(String value) {
        Object[] objectArray;
        switch (value) {
            case "Sickly": {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "\u0455\u026a\u1d04\u1d0b\u029f\u028f";
                objectArray = objectArray2;
                objectArray2[1] = -9158597;
                break;
            }
            case "Bad": {
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = "\u0299\u1d00\u1d05";
                objectArray = objectArray3;
                objectArray3[1] = -43691;
                break;
            }
            case "Below Average": {
                Object[] objectArray4 = new Object[2];
                objectArray4[0] = "\u0299\u1d07\u029f\u1d0f\u1d21 \u1d00\u1d20\u1d07\u0280\u1d00\u0262\u1d07";
                objectArray = objectArray4;
                objectArray4[1] = -197548;
                break;
            }
            case "Average": {
                Object[] objectArray5 = new Object[2];
                objectArray5[0] = "\u1d00\u1d20\u1d07\u0280\u1d00\u0262\u1d07";
                objectArray = objectArray5;
                objectArray5[1] = -219136;
                break;
            }
            case "Good": {
                Object[] objectArray6 = new Object[2];
                objectArray6[0] = "\u0262\u1d0f\u1d0f\u1d05";
                objectArray = objectArray6;
                objectArray6[1] = -11207596;
                break;
            }
            case "Great": {
                Object[] objectArray7 = new Object[2];
                objectArray7[0] = "\u0262\u0280\u1d07\u1d00\u1d1b";
                objectArray = objectArray7;
                objectArray7[1] = -16734208;
                break;
            }
            case "Excellent": {
                Object[] objectArray8 = new Object[2];
                objectArray8[0] = "\u1d07x\u1d04\u1d07\u029f\u029f\u1d07\u0274\u1d1b";
                objectArray = objectArray8;
                objectArray8[1] = -11207428;
                break;
            }
            case "Amazing": {
                Object[] objectArray9 = new Object[2];
                objectArray9[0] = "\u1d00\u1d0d\u1d00\u1d22\u026a\u0274\u0262";
                objectArray = objectArray9;
                objectArray9[1] = -240388;
                break;
            }
            case "Perfect \ud83d\udcaf": {
                Object[] objectArray10 = new Object[2];
                objectArray10[0] = "\u1d18\u1d07\u0280\ua730\u1d07\u1d04\u1d1b";
                objectArray = objectArray10;
                objectArray10[1] = -5767000;
                break;
            }
            default: {
                Object[] objectArray11 = new Object[2];
                objectArray11[0] = "";
                objectArray = objectArray11;
                objectArray11[1] = -1;
            }
        }
        return objectArray;
    }

    public static String rarityString(String rarity) {
        return switch (rarity) {
            case "common" -> "\uf033";
            case "rare" -> "\uf034";
            case "epic" -> "\uf035";
            case "legendary" -> "\uf036";
            case "mythical" -> "\uf037";
            default -> "";
        };
    }

    public static String rarityUpgrade(String rarity) {
        return switch (rarity) {
            case "common" -> "rare";
            case "rare" -> "epic";
            case "epic" -> "legendary";
            case "legendary" -> "mythical";
            default -> "";
        };
    }

    public static float rarityMultiplier(String value) {
        return switch (value) {
            case "common" -> 1.0f;
            case "rare" -> 2.0f;
            case "epic" -> 3.0f;
            case "legendary" -> 5.0f;
            case "mythical" -> 7.5f;
            default -> 1.0f;
        };
    }

    private class_2487 getNbt(class_1799 itemStack) {
        class_9279 component = (class_9279)itemStack.method_57824(class_9334.field_49628);
        return component != null ? component.method_57463() : null;
    }

    public static String petToJson(class_1799 itemStack) {
        Gson gson = new Gson();
        return gson.toJson((JsonElement)class_1799.field_24671.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)itemStack).getOrThrow());
    }
}

