/*
 * Decompiled with CFR 0.152.
 */
package io.github.markassk.fishonmcextras.hud;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.markassk.fishonmcextras.FishOnMCExtrasClient;
import io.github.markassk.fishonmcextras.config.FishOnMCExtrasConfig;
import io.github.markassk.fishonmcextras.handler.LookTickHandler;
import io.github.markassk.fishonmcextras.hud.FishStatsData;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_9779;

public class HudRenderer
implements HudRenderCallback {
    private final class_310 client = class_310.method_1551();
    private long hasFishRendered;
    private String addOnFishSize;
    private float addOnFishLength;
    private float addOnFishWeight;
    private float alpha = 1.0f;
    private int fishCaughtCount = 0;
    private float totalXP = 0.0f;
    private float totalValue = 0.0f;
    private Map<String, Integer> variantCounts = new HashMap<String, Integer>();
    private Map<String, Integer> rarityCounts = new HashMap<String, Integer>();
    private Map<String, Integer> sizeCounts = new HashMap<String, Integer>();
    private long activeTime = 0L;
    private long lastFishCaughtTime = 0L;
    private long lastUpdateTime = System.currentTimeMillis();
    private boolean timerPaused = true;
    private int allFishCaughtCount = 0;
    private float allTotalXP = 0.0f;
    private float allTotalValue = 0.0f;
    private Map<String, Integer> allRarityCounts = new HashMap<String, Integer>();
    private Map<String, Integer> allVariantCounts = new HashMap<String, Integer>();
    private Map<String, Integer> allSizeCounts = new HashMap<String, Integer>();
    private static String currentPet = null;
    private long lastSoundPlayTime = 0L;

    private FishStatsData exportStats() {
        FishStatsData data = new FishStatsData();
        data.fishCaughtCount = this.fishCaughtCount;
        data.totalXP = this.totalXP;
        data.totalValue = this.totalValue;
        data.variantCounts = new HashMap<String, Integer>(this.variantCounts);
        data.rarityCounts = new HashMap<String, Integer>(this.rarityCounts);
        data.sizeCounts = new HashMap<String, Integer>(this.sizeCounts);
        data.activeTime = this.activeTime;
        data.lastFishCaughtTime = this.lastFishCaughtTime;
        data.timerPaused = this.timerPaused;
        data.allFishCaughtCount = this.allFishCaughtCount;
        data.allTotalXP = this.allTotalXP;
        data.allTotalValue = this.allTotalValue;
        data.allVariantCounts = new HashMap<String, Integer>(this.allVariantCounts);
        data.allRarityCounts = new HashMap<String, Integer>(this.allRarityCounts);
        data.allSizeCounts = new HashMap<String, Integer>(this.allSizeCounts);
        data.equippedPet = currentPet;
        return data;
    }

    public void saveStats() {
        try {
            FishStatsData data = this.exportStats();
            Path configDir = FabricLoader.getInstance().getConfigDir();
            Path filePath = configDir.resolve("FishOnMCExtrasStats.json");
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson((Object)data);
            Files.write(filePath, json.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadStats() {
        try {
            Path configDir = FabricLoader.getInstance().getConfigDir();
            Path filePath = configDir.resolve("FishOnMCExtrasStats.json");
            if (!Files.exists(filePath, new LinkOption[0])) {
                return;
            }
            String json = Files.readString(filePath, StandardCharsets.UTF_8);
            Gson gson = new Gson();
            FishStatsData data = (FishStatsData)gson.fromJson(json, FishStatsData.class);
            this.fishCaughtCount = data.fishCaughtCount;
            this.totalXP = data.totalXP;
            this.totalValue = data.totalValue;
            this.variantCounts = data.variantCounts;
            this.rarityCounts = data.rarityCounts;
            this.sizeCounts = data.sizeCounts;
            this.allFishCaughtCount = data.allFishCaughtCount;
            this.allTotalXP = data.allTotalXP;
            this.allTotalValue = data.allTotalValue;
            this.allVariantCounts = data.allVariantCounts;
            this.allRarityCounts = data.allRarityCounts;
            this.allSizeCounts = data.allSizeCounts;
            if (data.equippedPet != null && !data.equippedPet.isEmpty()) {
                currentPet = data.equippedPet;
                System.out.println("[EXTRAS] Loaded saved pet: " + currentPet);
            }
            this.activeTime = data.activeTime;
            this.lastFishCaughtTime = data.lastFishCaughtTime;
            this.timerPaused = data.timerPaused;
            this.lastUpdateTime = System.currentTimeMillis();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void resetStats() {
        this.fishCaughtCount = 0;
        this.totalXP = 0.0f;
        this.totalValue = 0.0f;
        this.variantCounts.clear();
        this.rarityCounts.clear();
        this.sizeCounts.clear();
        this.activeTime = 0L;
        this.lastFishCaughtTime = 0L;
        this.timerPaused = false;
        this.lastUpdateTime = System.currentTimeMillis();
        FishOnMCExtrasClient.fishTracker.reset();
        System.out.println("RESET FOE TRACKER");
        this.saveStats();
        this.forceHudUpdate();
    }

    private void forceHudUpdate() {
        this.client.execute(() -> this.client.field_1705.method_1758(class_2561.method_30163((String)"HUD Updated"), false));
    }

    public void updateFishHUD(float xp, float value, String variant, String rarity, String size) {
        ++this.allFishCaughtCount;
        this.allTotalXP += xp;
        this.allTotalValue += value;
        this.allSizeCounts.put(size, this.allSizeCounts.getOrDefault(size, 0) + 1);
        this.allVariantCounts.put(variant, this.allVariantCounts.getOrDefault(variant, 0) + 1);
        this.allRarityCounts.put(rarity, this.allRarityCounts.getOrDefault(rarity, 0) + 1);
        this.lastFishCaughtTime = System.currentTimeMillis();
        this.timerPaused = false;
        ++this.fishCaughtCount;
        this.totalXP += xp;
        this.totalValue += value;
        this.sizeCounts.put(size, this.sizeCounts.getOrDefault(size, 0) + 1);
        this.variantCounts.put(variant, this.variantCounts.getOrDefault(variant, 0) + 1);
        this.rarityCounts.put(rarity, this.rarityCounts.getOrDefault(rarity, 0) + 1);
        this.saveStats();
    }

    private void drawHudLine(class_332 context, class_327 textRenderer, String prefix, int count, int totalFish, boolean isPercentageEnabled, int color, int scaledX, int[] scaledYHolder, boolean shadows, int lineHeight) {
        String text = prefix + " " + count;
        if (isPercentageEnabled && totalFish > 0) {
            float percentage = (float)count * 100.0f / (float)totalFish;
            text = text + String.format(" (%.1f%%)", Float.valueOf(percentage));
        }
        context.method_51433(textRenderer, text, scaledX, scaledYHolder[0], color, shadows);
        scaledYHolder[0] = scaledYHolder[0] + lineHeight;
    }

    public static void setCurrentPet(String petName) {
        currentPet = petName;
    }

    public static void clearCurrentPet() {
        currentPet = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderNoPetWarning(class_332 context) {
        FishOnMCExtrasConfig config = FishOnMCExtrasClient.CONFIG;
        if (!config.petWarningHUDConfig.enableWarning || currentPet != null) {
            return;
        }
        class_327 textRenderer = this.client.field_1772;
        String warningText = "NO PET EQUIPPED!";
        context.method_51448().method_22903();
        try {
            float scale = (float)config.petWarningHUDConfig.warningFontSize / 10.0f;
            context.method_51448().method_22905(scale, scale, 1.0f);
            int screenWidth = this.client.method_22683().method_4486();
            int screenHeight = this.client.method_22683().method_4502();
            int textWidth = textRenderer.method_1727(warningText);
            int x = (int)(((float)screenWidth / 2.0f - (float)textWidth * scale / 2.0f) / scale);
            int y = (int)((float)(screenHeight - 100) / scale);
            int color = config.petWarningHUDConfig.warningColor;
            if (config.petWarningHUDConfig.flashWarning) {
                float alpha = (float)(Math.sin((double)System.currentTimeMillis() / 200.0) * 0.5 + 0.5);
                color = color & 0xFFFFFF | (int)(alpha * 255.0f) << 24;
            }
            context.method_51433(textRenderer, warningText, x, y, color, config.petWarningHUDConfig.petWarningHUDShadows);
        }
        finally {
            context.method_51448().method_22909();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderCurrentPet(class_332 context) {
        if (currentPet == null) {
            return;
        }
        class_327 textRenderer = this.client.field_1772;
        FishOnMCExtrasConfig config = FishOnMCExtrasClient.CONFIG;
        String text = "Active Pet: " + currentPet;
        context.method_51448().method_22903();
        try {
            float scale = (float)config.petActiveHUDConfig.petActiveFontSize / 10.0f;
            context.method_51448().method_22905(scale, scale, 1.0f);
            int screenWidth = this.client.method_22683().method_4486();
            int screenHeight = this.client.method_22683().method_4502();
            int baseX = (int)((float)screenWidth * ((float)config.petActiveHUDConfig.petHUDX / 100.0f));
            int baseY = (int)((float)screenHeight * ((float)config.petActiveHUDConfig.petHUDY / 100.0f));
            int scaledX = (int)((float)baseX / scale);
            int scaledY = (int)((float)baseY / scale);
            context.method_51433(textRenderer, text, scaledX, scaledY, config.petActiveHUDConfig.petActiveColor, config.petActiveHUDConfig.petActiveHUDShadows);
        }
        finally {
            context.method_51448().method_22909();
        }
    }

    public void fishOnHookRenderStats(Float weight, Float length, String size) {
        FishOnMCExtrasConfig config = FishOnMCExtrasClient.CONFIG;
        this.addOnFishSize = size;
        this.hasFishRendered = (long)config.otherHUDConfig.statTime * 1000L - 500L + System.currentTimeMillis();
        this.addOnFishWeight = weight.floatValue();
        this.addOnFishLength = length.floatValue();
        this.alpha = 1.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void justFishCaughtAddon(class_332 drawContext) {
        float scale;
        int fontSize;
        boolean shadows;
        FishOnMCExtrasConfig config = FishOnMCExtrasClient.CONFIG;
        class_327 textRenderer = this.client.field_1772;
        if (this.hasFishRendered <= System.currentTimeMillis()) return;
        if (this.hasFishRendered - System.currentTimeMillis() <= 1000L && this.hasFishRendered != 0L && this.hasFishRendered - System.currentTimeMillis() > 20L) {
            this.alpha = (float)(this.hasFishRendered - System.currentTimeMillis()) / 1000.0f;
        }
        int alphaInt = (int)(this.alpha * 255.0f) << 24;
        int colorBaby = alphaInt | 0x468CE7;
        int colorJuvenile = alphaInt | 0x22EA08;
        int colorAdult = alphaInt | 0x1C7DA0;
        int colorLarge = alphaInt | 0xFF9000;
        int colorGigantic = alphaInt | 0xAF3333;
        int colorSubStats = alphaInt | config.otherHUDConfig.statColor;
        int screenWidth = this.client.method_22683().method_4486();
        int screenHeight = this.client.method_22683().method_4502();
        float yPercent = (float)config.otherHUDConfig.statHeight / 100.0f;
        int baseY = (int)((float)screenHeight * yPercent);
        drawContext.method_51448().method_22903();
        try {
            shadows = config.fishHUDConfig.fishHUDShadows;
            fontSize = config.fishHUDConfig.fishHUDFontSize;
            scale = (float)fontSize / 8.8f;
            drawContext.method_51448().method_22905(scale, scale, 1.0f);
            int padding = 2;
            int scaledYHolder = (int)((float)baseY / scale);
            Objects.requireNonNull(textRenderer);
            int lineHeight = (int)(9.0f + (float)padding / scale);
            float weightKg = this.addOnFishWeight * 0.453592f;
            float lengthCm = this.addOnFishLength * 2.54f;
            String weightText = String.format("%.2f lb (%.2f kg)", Float.valueOf(this.addOnFishWeight), Float.valueOf(weightKg));
            String lengthText = String.format("%.2f in (%.2f cm)", Float.valueOf(this.addOnFishLength), Float.valueOf(lengthCm));
            int textWidthWeight = textRenderer.method_1727(weightText);
            int textWidthLength = textRenderer.method_1727(lengthText);
            int scaledXWeight = Math.round(((float)screenWidth - (float)textWidthWeight * scale) / 2.0f / scale);
            int scaledXLength = Math.round(((float)screenWidth - (float)textWidthLength * scale) / 2.0f / scale);
            if (config.otherHUDConfig.showWeight) {
                drawContext.method_51433(textRenderer, weightText, scaledXWeight, scaledYHolder, colorSubStats, shadows);
                scaledYHolder += lineHeight;
            }
            if (config.otherHUDConfig.showLength) {
                drawContext.method_51433(textRenderer, lengthText, scaledXLength, scaledYHolder, colorSubStats, shadows);
            }
        }
        finally {
            drawContext.method_51448().method_22909();
        }
        if (!config.otherHUDConfig.showSizeRating) return;
        drawContext.method_51448().method_22903();
        try {
            shadows = config.fishHUDConfig.fishHUDShadows;
            fontSize = config.fishHUDConfig.fishHUDFontSize;
            scale = (float)fontSize / 5.0f;
            drawContext.method_51448().method_22905(scale, scale, 1.0f);
            int scaledYHolder = (int)((float)baseY / scale) - 12;
            String size = this.addOnFishSize;
            int textWidth2 = textRenderer.method_1727(size);
            int scaledX = Math.round(((float)screenWidth - (float)textWidth2 * scale) / 2.0f / scale);
            switch (this.addOnFishSize) {
                case "baby": {
                    drawContext.method_51433(textRenderer, "\u0299\u1d00\u0299\u028f", scaledX, scaledYHolder, colorBaby, shadows);
                    return;
                }
                case "juvenile": {
                    drawContext.method_51433(textRenderer, "\u1d0a\u1d1c\u1d20\u1d07\u0274\u026a\u029f\u1d07", scaledX, scaledYHolder, colorJuvenile, shadows);
                    return;
                }
                case "adult": {
                    drawContext.method_51433(textRenderer, "\u1d00\u1d05\u1d1c\u029f\u1d1b", scaledX, scaledYHolder, colorAdult, shadows);
                    return;
                }
                case "large": {
                    drawContext.method_51433(textRenderer, "\u029f\u1d00\u0280\u0262\u1d07", scaledX, scaledYHolder, colorLarge, shadows);
                    return;
                }
                case "gigantic": {
                    drawContext.method_51433(textRenderer, "\u0262\u026a\u0262\u1d00\u0274\u1d1b\u026a\u1d04", scaledX, scaledYHolder, colorGigantic, shadows);
                    return;
                }
            }
            return;
        }
        finally {
            drawContext.method_51448().method_22909();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInventorySpace(class_1661 inventory, class_332 context) {
        FishOnMCExtrasConfig config = FishOnMCExtrasClient.CONFIG;
        class_327 textRenderer = this.client.field_1772;
        int emptySlots = 0;
        for (int i = 0; i < 36; ++i) {
            if (!inventory.method_5438(i).method_7960()) continue;
            ++emptySlots;
        }
        if (emptySlots <= config.fullInvHUDConfig.FullInvHUDWarningSlot) {
            String warningText = "Warning! Only " + emptySlots + " empty slots left!";
            context.method_51448().method_22903();
            try {
                float scale = (float)config.fullInvHUDConfig.FullInvFontSize / 10.0f;
                context.method_51448().method_22905(scale, scale, 1.0f);
                int screenWidth = this.client.method_22683().method_4486();
                int screenHeight = this.client.method_22683().method_4502();
                int textWidth = textRenderer.method_1727(warningText);
                int x = (int)(((float)screenWidth / 2.0f - (float)textWidth * scale / 2.0f) / scale);
                int y = (int)((float)(screenHeight - config.fullInvHUDConfig.FullInvHUDHeight) / scale);
                int color = config.fullInvHUDConfig.FullInvFontColor;
                context.method_51433(textRenderer, warningText, x, y, color, config.fullInvHUDConfig.FullInvHUDShadows);
                if (config.fullInvHUDConfig.FullInvPlayWarningSound && System.currentTimeMillis() - this.lastSoundPlayTime > (long)config.fullInvHUDConfig.FullInvPlayWarningSoundTime * 1000L) {
                    assert (this.client.field_1724 != null);
                    switch (config.fullInvHUDConfig.FullInvWarningSoundSample.ordinal()) {
                        case 0: {
                            this.client.field_1724.method_5783((class_3414)class_3417.field_14622.comp_349(), this.client.field_1690.method_1630(class_3419.field_15247), 1.0f);
                            break;
                        }
                        case 1: {
                            this.client.field_1724.method_5783((class_3414)class_3417.field_14624.comp_349(), this.client.field_1690.method_1630(class_3419.field_15247), 1.0f);
                            break;
                        }
                        case 2: {
                            this.client.field_1724.method_5783((class_3414)class_3417.field_18311.comp_349(), this.client.field_1690.method_1630(class_3419.field_15247), 1.0f);
                            break;
                        }
                        case 3: {
                            this.client.field_1724.method_5783((class_3414)class_3417.field_14793.comp_349(), this.client.field_1690.method_1630(class_3419.field_15247), 1.0f);
                            break;
                        }
                        case 4: {
                            this.client.field_1724.method_5783((class_3414)class_3417.field_18310.comp_349(), this.client.field_1690.method_1630(class_3419.field_15247), 1.0f);
                        }
                    }
                    this.lastSoundPlayTime = System.currentTimeMillis();
                }
            }
            finally {
                context.method_51448().method_22909();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trackerHud(class_332 drawContext) {
        FishOnMCExtrasConfig config = FishOnMCExtrasConfig.getConfig();
        class_327 textRenderer = this.client.field_1772;
        int displayFishCaughtCount = config.trackTimed ? this.fishCaughtCount : this.allFishCaughtCount;
        float displayTotalXP = config.trackTimed ? this.totalXP : this.allTotalXP;
        float displayTotalValue = config.trackTimed ? this.totalValue : this.allTotalValue;
        Map<String, Integer> displayVariantCounts = config.trackTimed ? this.variantCounts : this.allVariantCounts;
        Map<String, Integer> displayRarityCounts = config.trackTimed ? this.rarityCounts : this.allRarityCounts;
        Map<String, Integer> displaySizeCounts = config.trackTimed ? this.sizeCounts : this.allSizeCounts;
        drawContext.method_51448().method_22903();
        try {
            int screenWidth = this.client.method_22683().method_4486();
            int screenHeight = this.client.method_22683().method_4502();
            float xPercent = (float)config.fishHUDConfig.fishHUDX / 100.0f;
            float yPercent = (float)config.fishHUDConfig.fishHUDY / 100.0f;
            int baseX = (int)((float)screenWidth * xPercent);
            int baseY = (int)((float)screenHeight * yPercent);
            boolean shadows = config.fishHUDConfig.fishHUDShadows;
            int fontSize = config.fishHUDConfig.fishHUDFontSize;
            float scale = (float)fontSize / 10.0f;
            drawContext.method_51448().method_22905(scale, scale, 1.0f);
            int padding = 2;
            int scaledX = (int)((float)baseX / scale);
            int[] scaledYHolder = new int[]{(int)((float)baseY / scale)};
            Objects.requireNonNull(textRenderer);
            int lineHeight = (int)(9.0f + (float)padding / scale);
            if (config.fishHUDToggles.showFishCaught) {
                drawContext.method_51433(textRenderer, "Fish Caught: " + displayFishCaughtCount, scaledX, scaledYHolder[0], config.fishHUDConfig.fishHUDColorConfig.fishHUDCaughtColor, shadows);
                scaledYHolder[0] = scaledYHolder[0] + lineHeight;
            }
            if (config.trackTimed) {
                long timeSinceResetMillis = this.activeTime;
                if (config.fishHUDToggles.showTimeSinceReset) {
                    long hours = TimeUnit.MILLISECONDS.toHours(timeSinceResetMillis);
                    long minutes = TimeUnit.MILLISECONDS.toMinutes(timeSinceResetMillis) % 60L;
                    long seconds = TimeUnit.MILLISECONDS.toSeconds(timeSinceResetMillis) % 60L;
                    String timeSinceReset = String.format("Time Counted: %02d:%02d:%02d", hours, minutes, seconds);
                    drawContext.method_51433(textRenderer, timeSinceReset, scaledX, scaledYHolder[0], config.fishHUDConfig.fishHUDColorConfig.fishHUDTimerColor, shadows);
                    scaledYHolder[0] = scaledYHolder[0] + lineHeight;
                }
                if (config.fishHUDToggles.showFishPerHour) {
                    double fishPerHour = (double)this.fishCaughtCount / ((double)timeSinceResetMillis / 3600000.0);
                    drawContext.method_51433(textRenderer, "Fish/Hour: " + String.format("%.1f", fishPerHour), scaledX, scaledYHolder[0], config.fishHUDConfig.fishHUDColorConfig.fishHUDTimerColor, shadows);
                    scaledYHolder[0] = scaledYHolder[0] + lineHeight;
                }
            }
            if (config.fishHUDToggles.showFishTotalXP) {
                drawContext.method_51433(textRenderer, "Total XP: " + displayTotalXP, scaledX, scaledYHolder[0], config.fishHUDConfig.fishHUDColorConfig.fishHUDXPColor, shadows);
                scaledYHolder[0] = scaledYHolder[0] + lineHeight;
            }
            if (config.fishHUDToggles.showFishTotalValue) {
                drawContext.method_51433(textRenderer, "Total Value: " + displayTotalValue + "$", scaledX, scaledYHolder[0], config.fishHUDConfig.fishHUDColorConfig.fishHUDValueColor, shadows);
                scaledYHolder[0] = scaledYHolder[0] + lineHeight;
            }
            if (config.fishHUDToggles.showRarities) {
                scaledYHolder[0] = scaledYHolder[0] + lineHeight;
                this.drawHudLine(drawContext, textRenderer, "\uf033", displayRarityCounts.getOrDefault("common", 0), displayFishCaughtCount, config.fishHUDConfig.showRarityPercentages, 0xFFFFFF, scaledX, scaledYHolder, shadows, lineHeight);
                this.drawHudLine(drawContext, textRenderer, "\uf034", displayRarityCounts.getOrDefault("rare", 0), displayFishCaughtCount, config.fishHUDConfig.showRarityPercentages, 0xFFFFFF, scaledX, scaledYHolder, shadows, lineHeight);
                this.drawHudLine(drawContext, textRenderer, "\uf035", displayRarityCounts.getOrDefault("epic", 0), displayFishCaughtCount, config.fishHUDConfig.showRarityPercentages, 0xFFFFFF, scaledX, scaledYHolder, shadows, lineHeight);
                this.drawHudLine(drawContext, textRenderer, "\uf036", displayRarityCounts.getOrDefault("legendary", 0), displayFishCaughtCount, config.fishHUDConfig.showRarityPercentages, 0xFFFFFF, scaledX, scaledYHolder, shadows, lineHeight);
                this.drawHudLine(drawContext, textRenderer, "\uf037", displayRarityCounts.getOrDefault("mythical", 0), displayFishCaughtCount, config.fishHUDConfig.showRarityPercentages, 0xFFFFFF, scaledX, scaledYHolder, shadows, lineHeight);
                scaledYHolder[0] = scaledYHolder[0] + lineHeight;
            }
            if (config.fishHUDToggles.showSpecial) {
                this.drawHudLine(drawContext, textRenderer, "\uf092", displayRarityCounts.getOrDefault("special", 0), displayFishCaughtCount, config.fishHUDConfig.showRarityPercentages, 0xFFFFFF, scaledX, scaledYHolder, shadows, lineHeight);
                scaledYHolder[0] = scaledYHolder[0] + lineHeight;
            }
            if ((config.fishHUDToggles.showBaby || config.fishHUDToggles.showJuvenile || config.fishHUDToggles.showAdult || config.fishHUDToggles.showLarge || config.fishHUDToggles.showGigantic) && !config.fishHUDToggles.showRarities) {
                scaledYHolder[0] = scaledYHolder[0] + lineHeight;
            }
            if (config.fishHUDToggles.showBaby) {
                this.drawHudLine(drawContext, textRenderer, "\u0299\u1d00\u0299\u028f", displaySizeCounts.getOrDefault("baby", 0), displayFishCaughtCount, config.fishHUDConfig.showSizePercentages, 0xFFFFFF, scaledX, scaledYHolder, shadows, lineHeight);
                drawContext.method_51433(textRenderer, "\u0299\u1d00\u0299\u028f ", scaledX, scaledYHolder[0] - lineHeight, 4623591, shadows);
            }
            if (config.fishHUDToggles.showJuvenile) {
                this.drawHudLine(drawContext, textRenderer, "\u1d0a\u1d1c\u1d20\u1d07\u0274\u026a\u029f\u1d07", displaySizeCounts.getOrDefault("juvenile", 0), displayFishCaughtCount, config.fishHUDConfig.showSizePercentages, 0xFFFFFF, scaledX, scaledYHolder, shadows, lineHeight);
                drawContext.method_51433(textRenderer, "\u1d0a\u1d1c\u1d20\u1d07\u0274\u026a\u029f\u1d07 ", scaledX, scaledYHolder[0] - lineHeight, 2288136, shadows);
            }
            if (config.fishHUDToggles.showAdult) {
                this.drawHudLine(drawContext, textRenderer, "\u1d00\u1d05\u1d1c\u029f\u1d1b", displaySizeCounts.getOrDefault("adult", 0), displayFishCaughtCount, config.fishHUDConfig.showSizePercentages, 0xFFFFFF, scaledX, scaledYHolder, shadows, lineHeight);
                drawContext.method_51433(textRenderer, "\u1d00\u1d05\u1d1c\u029f\u1d1b ", scaledX, scaledYHolder[0] - lineHeight, 1867168, shadows);
            }
            if (config.fishHUDToggles.showLarge) {
                this.drawHudLine(drawContext, textRenderer, "\u029f\u1d00\u0280\u0262\u1d07", displaySizeCounts.getOrDefault("large", 0), displayFishCaughtCount, config.fishHUDConfig.showSizePercentages, 0xFFFFFF, scaledX, scaledYHolder, shadows, lineHeight);
                drawContext.method_51433(textRenderer, "\u029f\u1d00\u0280\u0262\u1d07 ", scaledX, scaledYHolder[0] - lineHeight, 0xFF9000, shadows);
            }
            if (config.fishHUDToggles.showGigantic) {
                this.drawHudLine(drawContext, textRenderer, "\u0262\u026a\u0262\u1d00\u0274\u1d1b\u026a\u1d04", displaySizeCounts.getOrDefault("gigantic", 0), displayFishCaughtCount, config.fishHUDConfig.showSizePercentages, 0xFFFFFF, scaledX, scaledYHolder, shadows, lineHeight);
                drawContext.method_51433(textRenderer, "\u0262\u026a\u0262\u1d00\u0274\u1d1b\u026a\u1d04 ", scaledX, scaledYHolder[0] - lineHeight, 0xAF3333, shadows);
            }
            if (config.fishHUDToggles.showVariants) {
                scaledYHolder[0] = scaledYHolder[0] + lineHeight;
                if (displayVariantCounts != null) {
                    HashSet<String> displayedVariants = new HashSet<String>(Arrays.asList("normal", "albino", "melanistic", "trophy", "fabled", "zombie"));
                    if (config.fishHUDToggles.showAlbino) {
                        this.drawHudLine(drawContext, textRenderer, "\uf041", displayVariantCounts.getOrDefault("albino", 0), displayFishCaughtCount, config.fishHUDConfig.showVariantPercentages, 0xFFFFFF, scaledX, scaledYHolder, shadows, lineHeight);
                    }
                    if (config.fishHUDToggles.showMelanistic) {
                        this.drawHudLine(drawContext, textRenderer, "\uf042", displayVariantCounts.getOrDefault("melanistic", 0), displayFishCaughtCount, config.fishHUDConfig.showVariantPercentages, 0xFFFFFF, scaledX, scaledYHolder, shadows, lineHeight);
                    }
                    if (config.fishHUDToggles.showTrophy) {
                        this.drawHudLine(drawContext, textRenderer, "\uf043", displayVariantCounts.getOrDefault("trophy", 0), displayFishCaughtCount, config.fishHUDConfig.showVariantPercentages, 0xFFFFFF, scaledX, scaledYHolder, shadows, lineHeight);
                    }
                    if (config.fishHUDToggles.showFabled) {
                        this.drawHudLine(drawContext, textRenderer, "\uf044", displayVariantCounts.getOrDefault("fabled", 0), displayFishCaughtCount, config.fishHUDConfig.showVariantPercentages, 0xFFFFFF, scaledX, scaledYHolder, shadows, lineHeight);
                    }
                    if (config.fishHUDToggles.showZombie) {
                        this.drawHudLine(drawContext, textRenderer, "\uf089", displayVariantCounts.getOrDefault("zombie", 0), displayFishCaughtCount, config.fishHUDConfig.showVariantPercentages, 0xFFFFFF, scaledX, scaledYHolder, shadows, lineHeight);
                    }
                    if (config.fishHUDToggles.showUnique) {
                        int othersSum = displayVariantCounts.entrySet().stream().filter(entry -> !displayedVariants.contains(entry.getKey())).mapToInt(Map.Entry::getValue).sum();
                        drawContext.method_51433(textRenderer, "\u1d1c\u0274\u026a\ua7af\u1d1c\u1d07 " + othersSum, scaledX, scaledYHolder[0], 0xFFFFFF, shadows);
                        drawContext.method_51433(textRenderer, "\u1d1c\u0274\u026a\ua7af\u1d1c\u1d07 ", scaledX, scaledYHolder[0], config.fishHUDConfig.fishHUDColorConfig.fishHUDUniqueColor, shadows);
                        scaledYHolder[0] = scaledYHolder[0] + lineHeight;
                    }
                }
            }
        }
        finally {
            drawContext.method_51448().method_22909();
        }
    }

    public void onHudRender(class_332 drawContext, class_9779 tickCounter) {
        long timeSinceLastFish;
        class_310 client = class_310.method_1551();
        FishOnMCExtrasConfig config = FishOnMCExtrasConfig.getConfig();
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - this.lastUpdateTime;
        this.lastUpdateTime = currentTime;
        if (!this.timerPaused) {
            this.activeTime += delta;
        }
        if ((timeSinceLastFish = currentTime - this.lastFishCaughtTime) > TimeUnit.SECONDS.toMillis(config.fishHUDConfig.fishHUDAutoPause)) {
            this.timerPaused = true;
        }
        if (!client.field_1690.field_1842) {
            if (config.petHUD) {
                if (config.petWarningHUDConfig.enableWarning && currentPet == null) {
                    this.renderNoPetWarning(drawContext);
                } else if (currentPet != null) {
                    this.renderCurrentPet(drawContext);
                }
            }
            if (config.otherHUDConfig.showExtraFishingStats) {
                this.justFishCaughtAddon(drawContext);
            }
            if (config.fullInvHUDConfig.FullInvWarningEnable) {
                assert (client.field_1724 != null);
                this.checkInventorySpace(client.field_1724.method_31548(), drawContext);
            }
            if (config.otherHUDConfig.showItemFrameTooltip && LookTickHandler.instance().targetedItem != null) {
                drawContext.method_51446(client.field_1772, LookTickHandler.instance().targetedItem, client.method_22683().method_4486() / 2, client.method_22683().method_4502() / 2);
            }
            if (config.fishHUD) {
                this.trackerHud(drawContext);
            }
        }
    }

    public static enum InventorySound {
        PLING,
        BASS,
        BIT,
        BELL,
        DIDGERIDOO;

    }
}

