/*
 * Decompiled with CFR 0.152.
 */
package io.github.markassk.fishonmcextras.model_types;

import io.github.markassk.fishonmcextras.handler.PetMergeCalculatorHandler;
import io.github.markassk.fishonmcextras.util.TextHelper;
import net.minecraft.class_2487;

public class PetStats {
    private final String name;
    private final String rarity;
    private final float lLuck;
    private final float lScale;
    private final float cLuck;
    private final float cScale;
    private final float lLuckPercent;
    private final float lScalePercent;
    private final float cLuckPercent;
    private final float cScalePercent;
    public String hiddenRating;

    public PetStats(String name, String rarity, float lLuck, float lScale, float cLuck, float cScale, float lLuckPercent, float lScalePercent, float cLuckPercent, float cScalePercent) {
        this.name = name;
        this.rarity = rarity;
        this.lLuck = lLuck;
        this.lScale = lScale;
        this.cLuck = cLuck;
        this.cScale = cScale;
        this.lLuckPercent = lLuckPercent;
        this.lScalePercent = lScalePercent;
        this.cLuckPercent = cLuckPercent;
        this.cScalePercent = cScalePercent;
    }

    public PetStats(String name, String rarity, float lLuck, float lScale, float cLuck, float cScale, float lLuckPercent, float lScalePercent, float cLuckPercent, float cScalePercent, String hiddenRating) {
        this.name = name;
        this.rarity = rarity;
        this.lLuck = lLuck;
        this.lScale = lScale;
        this.cLuck = cLuck;
        this.cScale = cScale;
        this.lLuckPercent = lLuckPercent;
        this.lScalePercent = lScalePercent;
        this.cLuckPercent = cLuckPercent;
        this.cScalePercent = cScalePercent;
        this.hiddenRating = hiddenRating;
    }

    public String getName() {
        return this.name;
    }

    public String getRarity() {
        return this.rarity;
    }

    public float getlLuck() {
        return this.lLuck;
    }

    public float getlScale() {
        return this.lScale;
    }

    public float getcLuck() {
        return this.cLuck;
    }

    public float getcScale() {
        return this.cScale;
    }

    public float getlLuckPercent() {
        return this.lLuckPercent;
    }

    public float getlScalePercent() {
        return this.lScalePercent;
    }

    public float getcLuckPercent() {
        return this.cLuckPercent;
    }

    public float getcScalePercent() {
        return this.cScalePercent;
    }

    public float getTotalPercent() {
        return (this.lLuckPercent + this.lScalePercent + this.cLuckPercent + this.cScalePercent) / 4.0f;
    }

    public String getRatingValue() {
        return PetMergeCalculatorHandler.ratingValue(this.getTotalPercent() * 100.0f);
    }

    public Object[] getRatingString() {
        return PetMergeCalculatorHandler.ratingString(this.getRatingValue());
    }

    public static PetStats getStats(class_2487 compound, String rating) {
        return new PetStats(TextHelper.capitalize(compound.method_10558("pet")), compound.method_10558("rarity"), compound.method_10554("lbase", 10).method_10602(0).method_10550("cur_max"), compound.method_10554("lbase", 10).method_10602(1).method_10550("cur_max"), compound.method_10554("cbase", 10).method_10602(0).method_10550("cur_max"), compound.method_10554("cbase", 10).method_10602(1).method_10550("cur_max"), (float)compound.method_10554("lbase", 10).method_10602(0).method_10574("percent_max"), (float)compound.method_10554("lbase", 10).method_10602(1).method_10574("percent_max"), (float)compound.method_10554("cbase", 10).method_10602(0).method_10574("percent_max"), (float)compound.method_10554("cbase", 10).method_10602(1).method_10574("percent_max"), rating);
    }

    public boolean hasRoundingError() {
        boolean one = !TextHelper.fmt((this.getcLuck() + this.getcScale() + this.getlLuck() + this.getlScale()) / PetMergeCalculatorHandler.rarityMultiplier(this.getRarity()), 2).equals(TextHelper.fmt(this.getTotalPercent() * 100.0f, 2));
        boolean two = this.hiddenRating != null && !PetMergeCalculatorHandler.ratingValue(this.getTotalPercent() * 100.0f).equals(this.hiddenRating);
        return one && two;
    }
}

