/*
 * Decompiled with CFR 0.152.
 */
package io.github.markassk.fishonmcextras.screen;

import io.github.markassk.fishonmcextras.FishOnMCExtrasClient;
import io.github.markassk.fishonmcextras.config.FishOnMCExtrasConfig;
import io.github.markassk.fishonmcextras.handler.PetMergeCalculatorHandler;
import io.github.markassk.fishonmcextras.model_types.PetStats;
import io.github.markassk.fishonmcextras.screen.widget.ClickablePetItemWidget;
import io.github.markassk.fishonmcextras.util.TextHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_9334;

@Environment(value=EnvType.CLIENT)
public class PetMergeCalculatorScreen
extends class_437 {
    List<class_1799> petList;
    class_1657 player;
    class_437 parent;
    int x = 50;
    int y = 0;
    int padding = 10;
    FishOnMCExtrasConfig config = FishOnMCExtrasClient.CONFIG;

    public PetMergeCalculatorScreen(class_1657 player, class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Pet Merge Calculator"));
        this.player = player;
        this.parent = parent;
    }

    protected void method_25426() {
        super.method_25426();
        this.petList = new ArrayList<class_1799>();
        this.player.method_31548().field_7547.forEach(stack -> {
            if (stack.method_7909() == class_1802.field_8575 && stack.method_7964().getString().contains(" Pet") && stack.method_57824(class_9334.field_49628) != null) {
                this.petList.add((class_1799)stack);
            }
        });
        this.renderWidgets();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        int columns = (int)Math.ceil((double)this.petList.size() / 9.0) - 1;
        AtomicInteger count = new AtomicInteger();
        context.method_25294(this.field_22789 / 2 - this.x + this.padding - this.x - columns * 18 - 48 - 2, this.field_22790 / 2 - 81, this.field_22789 / 2 + this.x - this.padding - this.x - columns * 18 - 48 - 2, this.field_22790 / 2 + 81, 0x48AAAAAA);
        class_5250 petOneText = class_2561.method_43470((String)"Pet one").method_27695(new class_124[]{class_124.field_1067, class_124.field_1065});
        context.method_51439(this.field_22793, (class_2561)petOneText, this.field_22789 / 2 - this.x - this.field_22793.method_27525((class_5348)petOneText) / 2 - 50 - columns * 18, this.field_22790 / 2 - 81 + 6, -1, true);
        if (PetMergeCalculatorHandler.instance().petOne != null) {
            PetStats petOne = PetMergeCalculatorHandler.instance().petOne;
            this.renderPetText(context, petOne, columns, 0);
        }
        count.set(0);
        context.method_25294(this.field_22789 / 2 - this.x + this.padding + this.x + columns * 18 + 48 + 2, this.field_22790 / 2 - 81, this.field_22789 / 2 + this.x - this.padding + this.x + columns * 18 + 48 + 2, this.field_22790 / 2 + 81, 0x48AAAAAA);
        class_5250 petTwoText = class_2561.method_43470((String)"Pet two").method_27695(new class_124[]{class_124.field_1067, class_124.field_1065});
        context.method_51439(this.field_22793, (class_2561)petTwoText, this.field_22789 / 2 + this.x - this.field_22793.method_27525((class_5348)petTwoText) / 2 + 50 + columns * 18, this.field_22790 / 2 - 81 + 6, -1, true);
        if (PetMergeCalculatorHandler.instance().petTwo != null) {
            PetStats petTwo = PetMergeCalculatorHandler.instance().petTwo;
            this.renderPetText(context, petTwo, columns, 2);
        }
        count.set(0);
        context.method_25294(this.field_22789 / 2 - this.x + this.padding, this.field_22790 / 2 - 81, this.field_22789 / 2 + this.x - this.padding, this.field_22790 / 2 + 81, 0x48AAAAAA);
        class_5250 petResultText = class_2561.method_43470((String)"Result").method_27695(new class_124[]{class_124.field_1067, class_124.field_1065});
        context.method_51439(this.field_22793, (class_2561)petResultText, this.field_22789 / 2 - this.field_22793.method_27525((class_5348)petResultText) / 2, this.field_22790 / 2 - 81 + 6, -1, true);
        if (PetMergeCalculatorHandler.instance().petOne != null && PetMergeCalculatorHandler.instance().petTwo != null) {
            if (PetMergeCalculatorHandler.instance().petTwo != null && PetMergeCalculatorHandler.instance().petOne != null && !Objects.equals(PetMergeCalculatorHandler.instance().petOne.getRarity(), PetMergeCalculatorHandler.instance().petTwo.getRarity())) {
                warning = class_2561.method_43470((String)"Cannot merge pets of different rarity!").method_27692(class_124.field_1079);
                context.method_51439(this.field_22793, (class_2561)warning, this.field_22789 / 2 - this.field_22793.method_27525((class_5348)warning) / 2, this.field_22790 / 2 + 81 + this.padding, -1, true);
            } else if (!Objects.equals(PetMergeCalculatorHandler.instance().petOne.getName(), PetMergeCalculatorHandler.instance().petTwo.getName())) {
                warning = class_2561.method_43470((String)"Cannot merge pets of different pet types!").method_27692(class_124.field_1079);
                context.method_51439(this.field_22793, (class_2561)warning, this.field_22789 / 2 - this.field_22793.method_27525((class_5348)warning) / 2, this.field_22790 / 2 + 81 + this.padding, -1, true);
            } else if (PetMergeCalculatorHandler.instance().calculatedPet != null) {
                PetStats calculatedPet = PetMergeCalculatorHandler.instance().calculatedPet;
                this.renderPetText(context, calculatedPet, columns, 1);
            }
        }
        if (!this.config.petTooltipToggles.showAccuratePercentage) {
            class_5250 accurateWarning = class_2561.method_43470((String)"Accurate Percentages setting is forced to be enabled when merging").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056});
            context.method_51439(this.field_22793, (class_2561)accurateWarning, this.field_22789 / 2 - this.field_22793.method_27525((class_5348)accurateWarning) / 2, this.field_22790 / 2 - 81 - 26, -1, true);
        }
        class_5250 titleText = class_2561.method_43470((String)"Pet Merge Calculator").method_27695(new class_124[]{class_124.field_1068, class_124.field_1067});
        context.method_51439(this.field_22793, (class_2561)titleText, this.field_22789 / 2 - this.field_22793.method_27525((class_5348)titleText) / 2, this.field_22790 / 2 - 81 - 14, -1, true);
    }

    private void renderPetText(class_332 context, PetStats petStat, int petColumns, int column) {
        ArrayList<Object> petTextList = new ArrayList<Object>();
        AtomicInteger count = new AtomicInteger();
        class_5250 luckText = class_2561.method_43470((String)"\u029f\u1d1c\u1d04\u1d0b: ").method_54663(-8464447);
        class_5250 scaleText = class_2561.method_43470((String)"\u0455\u1d04\u1d00\u029f\u1d07: ").method_54663(-11827474);
        petTextList.add(class_2561.method_43470((String)petStat.getName()));
        petTextList.add(class_2561.method_43470((String)PetMergeCalculatorHandler.rarityString(petStat.getRarity())));
        petTextList.add(class_2561.method_43473());
        petTextList.add(class_2561.method_43470((String)"Climate").method_27692(class_124.field_1067));
        petTextList.add(TextHelper.concat(new class_2561[]{luckText, class_2561.method_43470((String)TextHelper.fmt(petStat.getcLuck())), class_2561.method_43470((String)(" " + TextHelper.fmt(petStat.getcLuckPercent() * 100.0f, this.config.petTooltipToggles.percentageDecimalPlaces) + "%")).method_27692(class_124.field_1080)}));
        petTextList.add(TextHelper.concat(new class_2561[]{scaleText, class_2561.method_43470((String)TextHelper.fmt(petStat.getcScale())), class_2561.method_43470((String)(" " + TextHelper.fmt(petStat.getcScalePercent() * 100.0f, this.config.petTooltipToggles.percentageDecimalPlaces) + "%")).method_27692(class_124.field_1080)}));
        petTextList.add(class_2561.method_43473());
        petTextList.add(class_2561.method_43470((String)"Location").method_27692(class_124.field_1067));
        petTextList.add(TextHelper.concat(new class_2561[]{luckText, class_2561.method_43470((String)TextHelper.fmt(petStat.getlLuck())), class_2561.method_43470((String)(" " + TextHelper.fmt(petStat.getlLuckPercent() * 100.0f, this.config.petTooltipToggles.percentageDecimalPlaces) + "%")).method_27692(class_124.field_1080)}));
        petTextList.add(TextHelper.concat(new class_2561[]{scaleText, class_2561.method_43470((String)TextHelper.fmt(petStat.getlScale())), class_2561.method_43470((String)(" " + TextHelper.fmt(petStat.getlScalePercent() * 100.0f, this.config.petTooltipToggles.percentageDecimalPlaces) + "%")).method_27692(class_124.field_1080)}));
        petTextList.add(class_2561.method_43473());
        petTextList.add(class_2561.method_43470((String)"Rating").method_27692(class_124.field_1067));
        Object[] ratingString = petStat.hasRoundingError() ? PetMergeCalculatorHandler.ratingString(petStat.hiddenRating) : petStat.getRatingString();
        petTextList.add(class_2561.method_43470((String)String.valueOf(ratingString[0])).method_54663(((Integer)ratingString[1]).intValue()));
        petTextList.add(class_2561.method_43470((String)(TextHelper.fmt(petStat.getTotalPercent() * 100.0f, this.config.petTooltipToggles.percentageDecimalPlaces) + "%")).method_27692(class_124.field_1080));
        switch (column) {
            case 0: {
                petTextList.forEach(text -> context.method_51439(this.field_22793, text, this.field_22789 / 2 - this.x - this.field_22793.method_27525((class_5348)text) / 2 - 50 - petColumns * 18, this.field_22790 / 2 - 81 + 18 + count.getAndIncrement() * 10, -1, true));
                break;
            }
            case 1: {
                petTextList.forEach(text -> context.method_51439(this.field_22793, text, this.field_22789 / 2 - this.field_22793.method_27525((class_5348)text) / 2, this.field_22790 / 2 - 81 + 18 + count.getAndIncrement() * 10, -1, true));
                break;
            }
            case 2: {
                petTextList.forEach(text -> context.method_51439(this.field_22793, text, this.field_22789 / 2 + this.x - this.field_22793.method_27525((class_5348)text) / 2 + 50 + petColumns * 18, this.field_22790 / 2 - 81 + 18 + count.getAndIncrement() * 10, -1, true));
                break;
            }
        }
    }

    private void renderWidgets() {
        ArrayList clickablePetItemWidgets = new ArrayList();
        AtomicInteger row = new AtomicInteger(0);
        AtomicInteger column = new AtomicInteger(0);
        int middleHeight = this.petList.size() > 9 ? 81 : this.petList.size() * 18 / 2;
        this.petList.forEach(itemStack -> {
            if (row.get() == 9) {
                row.set(0);
                column.getAndIncrement();
            }
            clickablePetItemWidgets.add(new ClickablePetItemWidget(this.field_22789 / 2 - this.x - 8 - column.get() * 18, this.field_22790 / 2 + this.y - middleHeight + row.get() * 18, this.field_22793, (class_1799)itemStack, 0, row.get() + column.get() * 9));
            row.getAndIncrement();
        });
        row.set(0);
        column.set(0);
        this.petList.forEach(itemStack -> {
            if (row.get() == 9) {
                row.set(0);
                column.getAndIncrement();
            }
            clickablePetItemWidgets.add(new ClickablePetItemWidget(this.field_22789 / 2 + this.x - 8 + column.get() * 18, this.field_22790 / 2 + this.y - middleHeight + row.get() * 18, this.field_22793, (class_1799)itemStack, 1, row.get() + column.get() * 9));
            row.getAndIncrement();
        });
        clickablePetItemWidgets.forEach(x$0 -> {
            ClickablePetItemWidget cfr_ignored_0 = (ClickablePetItemWidget)this.method_37063((class_364)x$0);
        });
    }

    public void method_25419() {
        assert (this.field_22787 != null);
        this.field_22787.method_1507(this.parent);
        PetMergeCalculatorHandler.instance().reset();
    }
}

