/*
 * Decompiled with CFR 0.152.
 */
package io.github.markassk.fishonmcextras.tooltip;

import io.github.markassk.fishonmcextras.config.FishOnMCExtrasConfig;
import io.github.markassk.fishonmcextras.handler.PetMergeCalculatorHandler;
import io.github.markassk.fishonmcextras.model_types.PetStats;
import io.github.markassk.fishonmcextras.util.TextHelper;
import java.util.List;
import java.util.Objects;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class TooltipPetRating {
    private static float findMultiplier(String petStr) {
        if (petStr.indexOf(61491) != -1) {
            return 1.0f;
        }
        if (petStr.indexOf(61492) != -1) {
            return 2.0f;
        }
        if (petStr.indexOf(61493) != -1) {
            return 3.0f;
        }
        if (petStr.indexOf(61494) != -1) {
            return 5.0f;
        }
        if (petStr.indexOf(61495) != -1) {
            return 7.5f;
        }
        return 1.0f;
    }

    public static List<class_2561> appendTooltipRating(List<class_2561> textList, class_1799 itemStack) {
        FishOnMCExtrasConfig config = FishOnMCExtrasConfig.getConfig();
        if (textList.size() >= 3 && textList.get(1).getString().contains(" Pet") && textList.get(3).getString().contains(" \u1d18\u1d07\u1d1b") && itemStack.method_7909() == class_1802.field_8575 && itemStack.method_57826(class_9334.field_49628)) {
            class_2487 compound = ((class_9279)itemStack.method_57824(class_9334.field_49628)).method_57463();
            PetStats petStats = PetStats.getStats(compound, PetMergeCalculatorHandler.getRatingFromJson(PetMergeCalculatorHandler.petToJson(itemStack)));
            if (Objects.equals(compound.method_10558("type"), "pet")) {
                if (!config.petTooltipToggles.showAccuratePercentage) {
                    if (config.petTooltipToggles.showIndividualRating) {
                        float petClimateLuck = petStats.getcLuck() * 4.0f / PetMergeCalculatorHandler.rarityMultiplier(petStats.getRarity());
                        float petClimateScale = petStats.getcScale() * 4.0f / PetMergeCalculatorHandler.rarityMultiplier(petStats.getRarity());
                        float petLocationLuck = petStats.getlLuck() * 4.0f / PetMergeCalculatorHandler.rarityMultiplier(petStats.getRarity());
                        float petLocationScale = petStats.getlScale() * 4.0f / PetMergeCalculatorHandler.rarityMultiplier(petStats.getRarity());
                        class_2561 petClimateLuckLine = TextHelper.concat(new class_2561[]{textList.get(9), class_2561.method_43470((String)(" (" + TextHelper.fmt(petClimateLuck, config.petTooltipToggles.percentageDecimalPlaces) + "%)")).method_27692(class_124.field_1063)});
                        class_2561 petClimateScaleLine = TextHelper.concat(new class_2561[]{textList.get(10), class_2561.method_43470((String)(" (" + TextHelper.fmt(petClimateScale, config.petTooltipToggles.percentageDecimalPlaces) + "%)")).method_27692(class_124.field_1063)});
                        class_2561 petLocationLuckLine = TextHelper.concat(new class_2561[]{textList.get(13), class_2561.method_43470((String)(" (" + TextHelper.fmt(petLocationLuck, config.petTooltipToggles.percentageDecimalPlaces) + "%)")).method_27692(class_124.field_1063)});
                        class_2561 petLocationScaleLine = TextHelper.concat(new class_2561[]{textList.get(14), class_2561.method_43470((String)(" (" + TextHelper.fmt(petLocationScale, config.petTooltipToggles.percentageDecimalPlaces) + "%)")).method_27692(class_124.field_1063)});
                        textList.set(9, petClimateLuckLine);
                        textList.set(10, petClimateScaleLine);
                        textList.set(13, petLocationLuckLine);
                        textList.set(14, petLocationScaleLine);
                    }
                    if (config.petTooltipToggles.showFullRating) {
                        float total = (petStats.getcLuck() + petStats.getcScale() + petStats.getlLuck() + petStats.getlScale()) / PetMergeCalculatorHandler.rarityMultiplier(petStats.getRarity());
                        class_2561 petRatingLine = TextHelper.concat(new class_2561[]{textList.get(16), class_2561.method_43470((String)(" (" + TextHelper.fmt(total, config.petTooltipToggles.percentageDecimalPlaces) + "%)")).method_27692(class_124.field_1063)});
                        textList.set(16, petRatingLine);
                    }
                } else {
                    if (config.petTooltipToggles.showIndividualRating) {
                        class_2561 petClimateLuckLine = TextHelper.concat(new class_2561[]{textList.get(9), class_2561.method_43470((String)(" (" + TextHelper.fmt(petStats.getcLuckPercent() * 100.0f, config.petTooltipToggles.percentageDecimalPlaces) + "%)")).method_27692(class_124.field_1063)});
                        class_2561 petClimateScaleLine = TextHelper.concat(new class_2561[]{textList.get(10), class_2561.method_43470((String)(" (" + TextHelper.fmt(petStats.getcScalePercent() * 100.0f, config.petTooltipToggles.percentageDecimalPlaces) + "%)")).method_27692(class_124.field_1063)});
                        class_2561 petLocationLuckLine = TextHelper.concat(new class_2561[]{textList.get(13), class_2561.method_43470((String)(" (" + TextHelper.fmt(petStats.getlLuckPercent() * 100.0f, config.petTooltipToggles.percentageDecimalPlaces) + "%)")).method_27692(class_124.field_1063)});
                        class_2561 petLocationScaleLine = TextHelper.concat(new class_2561[]{textList.get(14), class_2561.method_43470((String)(" (" + TextHelper.fmt(petStats.getlScalePercent() * 100.0f, config.petTooltipToggles.percentageDecimalPlaces) + "%)")).method_27692(class_124.field_1063)});
                        textList.set(9, petClimateLuckLine);
                        textList.set(10, petClimateScaleLine);
                        textList.set(13, petLocationLuckLine);
                        textList.set(14, petLocationScaleLine);
                    }
                    if (config.petTooltipToggles.showFullRating) {
                        class_2561 petRatingLine = TextHelper.concat(new class_2561[]{textList.get(16), class_2561.method_43470((String)(" (" + TextHelper.fmt(petStats.getTotalPercent() * 100.0f, config.petTooltipToggles.percentageDecimalPlaces) + "%)")).method_27692(class_124.field_1063)});
                        textList.set(16, petRatingLine);
                    }
                }
            }
        }
        return textList;
    }

    public static class_2561 appendTooltipRating(class_2561 textLine) {
        FishOnMCExtrasConfig config = FishOnMCExtrasConfig.getConfig();
        String json = TextHelper.textToJson((class_2561)textLine.method_27661());
        if (json.contains("\u1d18\u1d07\u1d1b \u0280\u1d00\u1d1b\u026a\u0274\u0262")) {
            String petStr = json.substring(json.indexOf(" Pet\\n"), json.indexOf("\u0280\u026a\u0262\u029c\u1d1b \u1d04\u029f\u026a\u1d04\u1d0b \u1d1b\u1d0f \u1d0f\u1d18\u1d07\u0274 \u1d18\u1d07\u1d1b \u1d0d\u1d07\u0274\u1d1c"));
            Pattern statNumber = Pattern.compile("(?<=\\+)(.*?)(?=\")");
            Matcher statNumberMatcher = statNumber.matcher(petStr);
            if (statNumberMatcher.find()) {
                List<String> matches = statNumberMatcher.results().map(MatchResult::group).toList();
                String petClimateLuck = matches.get(matches.size() - 7);
                String petClimateScale = matches.get(matches.size() - 5);
                String petLocationLuck = matches.get(matches.size() - 3);
                String petLocationScale = matches.getLast();
                float multiplier = TooltipPetRating.findMultiplier(petStr);
                float total = Stream.of(petClimateLuck, petClimateScale, petLocationLuck, petLocationScale).mapToInt(Integer::parseInt).sum();
                StringBuilder builder = new StringBuilder(petStr);
                String petStrNew = builder.toString();
                if (config.petTooltipToggles.showIndividualRating) {
                    petStrNew = builder.insert(TooltipPetRating.ordinalIndexOf(petStrNew, "\\n", 9), " (" + String.format("%.0f", Float.valueOf(Float.parseFloat(petClimateLuck) * 4.0f / multiplier)) + "%)").toString();
                    petStrNew = builder.insert(TooltipPetRating.ordinalIndexOf(petStrNew, "\\n", 10), " (" + String.format("%.0f", Float.valueOf(Float.parseFloat(petClimateScale) * 4.0f / multiplier)) + "%)").toString();
                    petStrNew = builder.insert(TooltipPetRating.ordinalIndexOf(petStrNew, "\\n", 13), " (" + String.format("%.0f", Float.valueOf(Float.parseFloat(petLocationLuck) * 4.0f / multiplier)) + "%)").toString();
                    petStrNew = builder.insert(TooltipPetRating.ordinalIndexOf(petStrNew, "\\n", 14), " (" + String.format("%.0f", Float.valueOf(Float.parseFloat(petLocationScale) * 4.0f / multiplier)) + "%)").toString();
                }
                if (config.petTooltipToggles.showFullRating) {
                    petStrNew = builder.insert(TooltipPetRating.ordinalIndexOf(petStrNew, "\\n", 16), " (" + String.format("%.0f", Float.valueOf(total / multiplier)) + "%)").toString();
                }
                return TextHelper.jsonToText(json.replace(petStr, petStrNew));
            }
        }
        return TextHelper.jsonToText(json);
    }

    private static int ordinalIndexOf(String str, String substr, int n) {
        int pos = str.indexOf(substr);
        while (--n > 0 && pos != -1) {
            pos = str.indexOf(substr, pos + 1);
        }
        return pos;
    }
}

