/*
 * Decompiled with CFR 0.152.
 */
package io.github.markassk.fishonmcextras.trackers;

import io.github.markassk.fishonmcextras.FishOnMCExtrasClient;
import io.github.markassk.fishonmcextras.hud.HudRenderer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_2561;

public class EquippedPetTracker
implements ClientReceiveMessageEvents.Game {
    private static String currentPet = null;
    private static long lastPetChangeTime = 0L;
    private static final Pattern PET_EQUIP_PATTERN = Pattern.compile("PETS\\s*[\u00bb:]\\s*Equipped your (.+?)\\.?$", 2);
    private static final Pattern PET_UNEQUIP_PATTERN = Pattern.compile("PETS\\s*[\u00bb:]\\s*Pet unequipped!$", 2);

    public static void initialize() {
        ClientReceiveMessageEvents.GAME.register((Object)new EquippedPetTracker());
    }

    public void onReceiveGameMessage(class_2561 message, boolean overlay) {
        String rawMessage = message.getString();
        Matcher equipMatcher = PET_EQUIP_PATTERN.matcher(rawMessage);
        Matcher unequipMatcher = PET_UNEQUIP_PATTERN.matcher(rawMessage);
        if (equipMatcher.find()) {
            this.handlePetEquip(equipMatcher.group(1));
        } else if (unequipMatcher.find()) {
            this.handlePetUnequip();
        }
    }

    private void handlePetEquip(String petName) {
        HudRenderer.setCurrentPet(petName.trim());
        lastPetChangeTime = System.currentTimeMillis();
        FishOnMCExtrasClient.HUD_RENDERER.saveStats();
    }

    private void handlePetUnequip() {
        HudRenderer.clearCurrentPet();
        lastPetChangeTime = System.currentTimeMillis();
        FishOnMCExtrasClient.HUD_RENDERER.saveStats();
    }

    public static String getCurrentPet() {
        return currentPet;
    }

    public static long getLastPetChangeTime() {
        return lastPetChangeTime;
    }
}

