/*
 * Decompiled with CFR 0.152.
 */
package io.github.markassk.fishonmcextras.trackers;

import io.github.markassk.fishonmcextras.hud.HudRenderer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1132;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_642;
import net.minecraft.class_746;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class FishTracker {
    private final Map<Integer, class_1799> previousInventory = new HashMap<Integer, class_1799>();
    private final Set<String> trackedFishUids = new HashSet<String>();
    private final HudRenderer hudRenderer;
    private UUID playerUUID;
    private String currentWorldId = "";
    private int retryScansRemaining = 8;

    public FishTracker(HudRenderer hudRenderer) {
        this.hudRenderer = hudRenderer;
    }

    public void updateWorldContext(class_310 client) {
        String newWorldId = this.getWorldIdentifier(client);
        if (!newWorldId.equals(this.currentWorldId)) {
            this.currentWorldId = newWorldId;
            this.trackedFishUids.clear();
            this.previousInventory.clear();
            this.retryScansRemaining = 8;
            this.playerUUID = client.field_1724 != null ? client.field_1724.method_5667() : null;
        }
    }

    private String getWorldIdentifier(class_310 client) {
        if (client.method_1542()) {
            class_1132 server = client.method_1576();
            return server != null ? "local:" + server.method_27728().method_150() : "local:unknown";
        }
        class_642 serverInfo = client.method_1558();
        return serverInfo != null ? "remote:" + serverInfo.field_3761.replace(":", "_") : "remote:unknown";
    }

    private void scanInventory(class_1657 player) {
        System.out.println("[DEBUG] Scanning inventory");
        for (int slot = 0; slot < player.method_31548().method_5439(); ++slot) {
            String uid;
            class_2487 nbt;
            class_1799 stack = player.method_31548().method_5438(slot);
            if (!this.isFishItem(stack) || (nbt = this.getFishNbt(stack)) == null || !this.isPlayerCaught(nbt) || this.trackedFishUids.contains(uid = this.createFishUid(nbt))) continue;
            this.trackedFishUids.add(uid);
            System.out.println("[DEBUG] Tracked UID: " + uid);
        }
    }

    public void tick(class_310 client, boolean menuOpened, long lastMenuCloseTime) {
        class_746 player = client.field_1724;
        if (player == null) {
            return;
        }
        if (this.retryScansRemaining > 0) {
            --this.retryScansRemaining;
            if (this.retryScansRemaining == 7) {
                this.scanInventory((class_1657)player);
                System.out.println("[DEBUG] Initial inventory scan completed");
            } else if (this.retryScansRemaining % 5 == 0) {
                System.out.println("[DEBUG] Retrying inventory scan (" + this.retryScansRemaining + " left)");
                this.scanInventory((class_1657)player);
            }
        }
        for (int slot = 0; slot < player.method_31548().method_5439(); ++slot) {
            class_1799 stack = player.method_31548().method_5438(slot);
            if (!this.isFishItem(stack) || !this.isNewFish(stack)) continue;
            this.trackFish(stack);
            System.out.println("[DEBUG] Processing new fish. Total tracked: " + this.trackedFishUids.size());
            if (menuOpened || System.currentTimeMillis() - lastMenuCloseTime < 200L) continue;
            this.processFish(stack);
        }
    }

    private boolean isFishItem(class_1799 stack) {
        return !stack.method_7960() && (stack.method_7909() == class_1802.field_8429 || stack.method_7909() == class_1802.field_8446 || stack.method_7909() == class_1802.field_8226 || stack.method_7909() == class_1802.field_8695 || stack.method_7909() == class_1802.field_8511) && stack.method_57826(class_9334.field_49628);
    }

    private class_2487 getFishNbt(class_1799 stack) {
        class_9279 component = (class_9279)stack.method_57824(class_9334.field_49628);
        return component != null ? component.method_57463() : null;
    }

    private boolean isPlayerCaught(class_2487 nbt) {
        if (!nbt.method_10545("catcher") || this.playerUUID == null) {
            return false;
        }
        int[] catcher = nbt.method_10561("catcher");
        if (catcher.length != 4) {
            return false;
        }
        try {
            long mostSigBits = (long)catcher[0] << 32 | (long)catcher[1] & 0xFFFFFFFFL;
            long leastSigBits = (long)catcher[2] << 32 | (long)catcher[3] & 0xFFFFFFFFL;
            return new UUID(mostSigBits, leastSigBits).equals(this.playerUUID);
        }
        catch (Exception e) {
            return false;
        }
    }

    private String createFishUid(class_2487 nbt) {
        return Arrays.toString(nbt.method_10561("id")) + "|" + this.currentWorldId;
    }

    private void trackFish(class_1799 stack) {
        class_2487 nbt = this.getFishNbt(stack);
        if (nbt != null && this.isPlayerCaught(nbt)) {
            this.trackedFishUids.add(this.createFishUid(nbt));
        }
    }

    private boolean isNewFish(class_1799 stack) {
        class_2487 nbt = this.getFishNbt(stack);
        return nbt != null && this.isPlayerCaught(nbt) && !this.trackedFishUids.contains(this.createFishUid(nbt));
    }

    private void processFish(class_1799 stack) {
        class_2487 nbt = this.getFishNbt(stack);
        if (nbt == null) {
            return;
        }
        this.hudRenderer.updateFishHUD(nbt.method_10583("xp"), nbt.method_10583("value"), nbt.method_10558("variant"), nbt.method_10558("rarity"), nbt.method_10558("size"));
        this.hudRenderer.fishOnHookRenderStats(Float.valueOf(nbt.method_10583("weight")), Float.valueOf(nbt.method_10583("length")), nbt.method_10558("size"));
    }

    public void reset() {
        this.trackedFishUids.clear();
        this.previousInventory.clear();
    }
}

