/*
 * Decompiled with CFR 0.152.
 */
package de.arvitus.servermessages;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.arvitus.servermessages.ServerMessages;
import de.arvitus.servermessages.WrappedLangText;
import eu.pb4.placeholders.api.ParserContext;
import eu.pb4.placeholders.api.node.DynamicTextNode;
import eu.pb4.placeholders.api.parsers.NodeParser;
import eu.pb4.placeholders.api.parsers.TagLikeParser;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class Config {
    public static final Path PATH = ServerMessages.CONFIG_DIR.resolve("config.json");
    public static final Codec<Map<String, String>> CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING);
    public static final ParserContext.Key<Function<String, class_2561>> DYN_KEY = DynamicTextNode.key((String)"servermessages");
    public static final NodeParser PARSER = NodeParser.builder().quickText().simplifiedTextFormat().legacyAll().globalPlaceholders(TagLikeParser.PLACEHOLDER_USER).placeholders(TagLikeParser.Format.of((char)'%', (char)'s'), DYN_KEY).staticPreParsing().build();
    private static Map<String, WrappedLangText> cache;
    private static Map<String, String> data;

    private Config() {
    }

    public static void load() {
        if (data == null) {
            data = Map.of("multiplayer.disconnect.not_whitelisted", "<lang multiplayer.disconnect.not_whitelisted>", "multiplayer.disconnect.server_shutdown", "<lang multiplayer.disconnect.server_shutdown>");
        }
        Map<String, String> oldData = data;
        try (FileReader reader = new FileReader(PATH.toFile());){
            DataResult result = CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)reader));
            data = (Map)result.getOrThrow();
        }
        catch (FileNotFoundException e) {
            Config.save();
        }
        catch (Exception e) {
            ServerMessages.LOGGER.warn("Error during config load, using previous value instead", (Throwable)e);
        }
        if (data.equals(oldData)) {
            return;
        }
        for (String key : Config.getCache().keySet()) {
            if (Objects.equals(data.get(key), oldData.get(key))) continue;
            cache.remove(key);
        }
    }

    public static void save() {
        PATH.getParent().toFile().mkdirs();
        try (FileWriter writer = new FileWriter(PATH.toFile());){
            DataResult result = CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, Config.getData());
            new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create().toJson((JsonElement)result.getOrThrow(), (Appendable)writer);
        }
        catch (Exception e) {
            ServerMessages.LOGGER.warn("Error during config save", (Throwable)e);
        }
    }

    private static Map<String, String> getData() {
        if (data == null) {
            Config.load();
        }
        return data;
    }

    private static Map<String, WrappedLangText> getCache() {
        if (cache == null) {
            cache = new HashMap<String, WrappedLangText>();
        }
        return cache;
    }

    @Nullable
    public static WrappedLangText get(String key) {
        if (!Config.getCache().containsKey(key) && Config.getData().containsKey(key)) {
            String value = data.get(key);
            cache.put(key, WrappedLangText.from(PARSER, value));
        }
        return cache.get(key);
    }

    public static boolean contains(String key) {
        return Config.getData().containsKey(key);
    }
}

