/*
 * Decompiled with CFR 0.152.
 */
package de.arvitus.servermessages;

import de.arvitus.servermessages.Config;
import de.arvitus.servermessages.ContextStore;
import java.nio.file.Path;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerMessages
implements ModInitializer {
    public static final String MOD_ID = "servermessages";
    public static final Path CONFIG_DIR = FabricLoader.getInstance().getConfigDir().resolve("servermessages");
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"servermessages");
    public static final ContextStore CONTEXT_STORE = new ContextStore();
    @Nullable
    public static MinecraftServer SERVER;

    public void onInitialize() {
        FabricLoader.getInstance().getModContainer(MOD_ID).ifPresent(modContainer -> {
            ModMetadata meta = modContainer.getMetadata();
            LOGGER.info("Loaded {} v{} by {}", new Object[]{meta.getName(), meta.getVersion(), meta.getAuthors().stream().findFirst().map(Person::getName).orElse("unknown")});
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            SERVER = server;
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            SERVER = null;
        });
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, resourceManager, success) -> Config.load());
    }
}

