/*
 * Decompiled with CFR 0.152.
 */
package com.abfann.schematicmarket;

import com.abfann.schematicmarket.construction.Construction;
import com.abfann.schematicmarket.construction.ConstructionLoader;
import com.abfann.schematicmarket.construction.PriceCalculator;
import com.abfann.schematicmarket.construction.schematic.SchematicData;
import com.abfann.schematicmarket.construction.schematic.SchematicReader;
import com.abfann.schematicmarket.economy.EconomyManager;
import com.abfann.schematicmarket.economy.command.BalanceCommand;
import com.abfann.schematicmarket.economy.command.DepositCommand;
import com.abfann.schematicmarket.economy.command.PayCommand;
import com.abfann.schematicmarket.economy.command.WithdrawCommand;
import com.abfann.schematicmarket.economy.command.admin.BalanceSetCommand;
import com.abfann.schematicmarket.economy.command.admin.GiftCommand;
import com.abfann.schematicmarket.economy.command.admin.TakeCommand;
import com.abfann.schematicmarket.item.ConstructionItemHandler;
import com.abfann.schematicmarket.network.PurchaseConstructionC2SPacket;
import com.abfann.schematicmarket.network.SyncBalanceS2CPacket;
import com.abfann.schematicmarket.util.TranslationManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.nio.file.Path;
import java.util.Map;
import java.util.TreeMap;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchematicMarket
implements ModInitializer {
    public static final String MOD_ID = "schematicmarket";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"schematicmarket");

    public void onInitialize() {
        LOGGER.info("Initializing Schematic Market...");
        TranslationManager.initialize();
        ConstructionLoader.loadAll();
        PurchaseConstructionC2SPacket.register();
        ConstructionItemHandler.register();
        ServerLifecycleEvents.SERVER_STARTING.register(server -> EconomyManager.getInstance().initialize(server));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            BalanceCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment);
            DepositCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment);
            WithdrawCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment);
            PayCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment);
            GiftCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment);
            TakeCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment);
            BalanceSetCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment);
        });
        LOGGER.info("Schematic Market initialized successfully!");
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"sm_inspect").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"construction_id", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String id = StringArgumentType.getString((CommandContext)context, (String)"construction_id");
            Construction construction = ConstructionLoader.getConstruction(id);
            if (construction == null) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Construction not found: " + id)));
                return 0;
            }
            SchematicMarket.inspectConstructionPrice(construction, (class_2168)context.getSource());
            return 1;
        }))));
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.field_14140;
            server.execute(() -> {
                long balance = EconomyManager.getInstance().getBalance(player.method_5667());
                SyncBalanceS2CPacket.send(player, balance);
            });
        });
    }

    public static void inspectSchematic(String filePath) {
        try {
            Path path = Path.of(filePath, new String[0]);
            SchematicData data = SchematicReader.read(path);
            LOGGER.info("=== SCHEMATIC INSPECTION ===");
            LOGGER.info("Dimensions: {}x{}x{}", new Object[]{data.getWidth(), data.getHeight(), data.getLength()});
            LOGGER.info("Total blocks: {}", (Object)(data.getWidth() * data.getHeight() * data.getLength()));
            LOGGER.info("Block types found: {}", (Object)data.getBlockCounts().size());
            LOGGER.info("Block breakdown:");
            data.getBlockCounts().entrySet().stream().sorted((a, b) -> Integer.compare((Integer)b.getValue(), (Integer)a.getValue())).forEach(entry -> {
                class_2248 block = ((class_2680)entry.getKey()).method_26204();
                int count = (Integer)entry.getValue();
                double price = PriceCalculator.getBlockPrice(block);
                double total = price * (double)count;
                LOGGER.info("  {} x{} @ {} each = {} total", new Object[]{block.method_9539(), count, price, total});
            });
            long totalPrice = PriceCalculator.calculatePrice(data.getBlockCounts(), 1.0);
            LOGGER.info("Calculated price: {}", (Object)totalPrice);
            LOGGER.info("===========================");
        }
        catch (Exception e) {
            LOGGER.error("Failed to inspect", (Throwable)e);
        }
    }

    private static void inspectConstructionPrice(Construction construction, class_2168 source) {
        try {
            source.method_9226(() -> class_2561.method_43470((String)("=== PRICE INSPECTION: " + construction.getName() + " ===")), false);
            Map<class_2680, Integer> blocks = construction.getBlockCounts();
            int totalBlocks = blocks.values().stream().mapToInt(Integer::intValue).sum();
            source.method_9226(() -> class_2561.method_43470((String)("Total blocks: " + totalBlocks)), false);
            source.method_9226(() -> class_2561.method_43470((String)("Dimensions: " + construction.getWidth() + "x" + construction.getHeight() + "x" + construction.getLength())), false);
            TreeMap<String, Integer> priceCategories = new TreeMap<String, Integer>();
            double totalValue = 0.0;
            for (Map.Entry<class_2680, Integer> entry2 : blocks.entrySet()) {
                class_2248 block = entry2.getKey().method_26204();
                int count = entry2.getValue();
                double price = PriceCalculator.getBlockPrice(block);
                double value = price * (double)count * 5.0;
                totalValue += value;
                String category = price == 0.01 ? "Very Cheap (0.01)" : (price <= 0.05 ? "Cheap (0.02-0.05)" : (price <= 0.15 ? "Medium (0.06-0.15)" : (price <= 0.5 ? "Expensive (0.16-0.50)" : "Very Expensive (0.51+)")));
                priceCategories.put(category, priceCategories.getOrDefault(category, 0) + count);
            }
            source.method_9226(() -> class_2561.method_43470((String)"\nBlocks by price category:"), false);
            for (Map.Entry<Object, Integer> entry3 : priceCategories.entrySet()) {
                int count = entry3.getValue();
                double percentage = (double)count * 100.0 / (double)totalBlocks;
                source.method_9226(() -> class_2561.method_43470((String)String.format("  %s: %d blocks (%.1f%%)", entry2.getKey(), count, percentage)), false);
            }
            source.method_9226(() -> class_2561.method_43470((String)"\nTop 10 most used blocks:"), false);
            blocks.entrySet().stream().sorted((a, b) -> Integer.compare((Integer)b.getValue(), (Integer)a.getValue())).limit(10L).forEach(entry -> {
                class_2248 block = ((class_2680)entry.getKey()).method_26204();
                int count = (Integer)entry.getValue();
                double price = PriceCalculator.getBlockPrice(block);
                double value = price * (double)count * 5.0;
                String blockName = block.method_9539().replace("block.minecraft.", "");
                source.method_9226(() -> class_2561.method_43470((String)String.format("  %s x%d @ %.2f = %.2f", blockName, count, price, value)), false);
            });
            double finalTotalValue = totalValue;
            long finalPrice = construction.getFinalPrice();
            double finalMultiplier = construction.getPriceMultiplier();
            source.method_9226(() -> class_2561.method_43470((String)("\nCalculated value: " + finalTotalValue)), false);
            source.method_9226(() -> class_2561.method_43470((String)("Final price: " + finalPrice)), false);
            source.method_9226(() -> class_2561.method_43470((String)("Price multiplier: " + finalMultiplier)), false);
            source.method_9226(() -> class_2561.method_43470((String)"================================="), false);
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Error: " + e.getMessage())));
            LOGGER.error("Failed to inspect construction price", (Throwable)e);
        }
    }
}

