/*
 * Decompiled with CFR 0.152.
 */
package com.abfann.schematicmarket.client.gui;

import com.abfann.schematicmarket.client.gui.ConstructionDetailScreen;
import com.abfann.schematicmarket.construction.Construction;
import com.abfann.schematicmarket.construction.ConstructionLoader;
import com.abfann.schematicmarket.economy.EconomyManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_757;

@Environment(value=EnvType.CLIENT)
public class CatalogScreen
extends class_437 {
    private static final class_2960 TEXTURE = new class_2960("schematicmarket", "textures/gui/catalog_gui.png");
    private static final int GUI_WIDTH = 195;
    private static final int GUI_HEIGHT = 162;
    private int x;
    private int y;
    private int currentPage = 0;
    private static final int ITEMS_PER_PAGE = 8;
    private final List<Construction> constructions = new ArrayList<Construction>(ConstructionLoader.getAllConstructions().values());
    private long playerBalance;

    public CatalogScreen() {
        super((class_2561)class_2561.method_43470((String)"Schematic Market"));
        this.constructions.sort((a, b) -> {
            int categoryCompare = a.getCategory().compareToIgnoreCase(b.getCategory());
            if (categoryCompare != 0) {
                return categoryCompare;
            }
            return a.getName().compareToIgnoreCase(b.getName());
        });
    }

    protected void method_25426() {
        super.method_25426();
        this.x = (this.field_22789 - 195) / 2;
        this.y = (this.field_22790 - 162) / 2;
        this.playerBalance = EconomyManager.getClientBalance();
    }

    private class_2960 loadConstructionTexture(Construction construction) {
        try {
            if (construction.getThumbnail() != null) {
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
        context.method_25302(TEXTURE, this.x, this.y, 0, 0, 195, 162);
        this.drawHeader(context);
        this.drawConstructions(context, mouseX, mouseY);
        this.drawNavigationButtons(context, mouseX, mouseY);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    private void drawHeader(class_332 context) {
        if (this.field_22793 == null) {
            return;
        }
        context.method_51433(this.field_22793, "Schematic Market", this.x + 4, this.y + 7, 0xFFFFFF, true);
        String balanceText = "" + this.playerBalance;
        context.method_51433(this.field_22793, balanceText, this.x + 150, this.y + 7, 0xFFFF00, false);
    }

    private void drawConstructions(class_332 context, int mouseX, int mouseY) {
        class_4587 matrices = context.method_51448();
        int startIndex = this.currentPage * 8;
        int endIndex = Math.min(startIndex + 8, this.constructions.size());
        int[] slotsX = new int[]{6, 53, 100, 147, 6, 53, 100, 147};
        int[] slotsY = new int[]{27, 27, 27, 27, 89, 89, 89, 89};
        int[] textY = new int[]{70, 70, 70, 70, 132, 132, 132, 132};
        for (int i = startIndex; i < endIndex; ++i) {
            int slotY;
            int slotX;
            Construction construction;
            int slotIndex;
            block7: {
                slotIndex = i - startIndex;
                construction = this.constructions.get(i);
                slotX = this.x + slotsX[slotIndex];
                slotY = this.y + slotsY[slotIndex];
                String thumbnailId = construction.getThumbnailId();
                if (thumbnailId != null && !thumbnailId.isEmpty()) {
                    try {
                        class_2960 thumbnailTexture = class_2960.method_12829((String)thumbnailId);
                        if (thumbnailTexture != null) {
                            RenderSystem.setShaderTexture((int)0, (class_2960)thumbnailTexture);
                            context.method_25290(thumbnailTexture, slotX, slotY, 0.0f, 0.0f, 42, 42, 42, 42);
                            break block7;
                        }
                        context.method_25294(slotX, slotY, slotX + 42, slotY + 42, -11184811);
                    }
                    catch (Exception e) {
                        context.method_25294(slotX, slotY, slotX + 42, slotY + 42, -11184811);
                    }
                } else {
                    context.method_25294(slotX, slotY, slotX + 42, slotY + 42, -11184811);
                }
            }
            Object name = construction.getName();
            if (this.field_22793.method_1727((String)name) > 42) {
                name = this.field_22793.method_27523((String)name, 38) + "...";
            }
            int textX = this.x + slotsX[slotIndex];
            int textYPos = this.y + textY[slotIndex];
            context.method_51433(this.field_22793, (String)name, textX, textYPos, 0xFFFFFF, false);
            String price = "" + construction.getFinalPrice();
            matrices.method_22903();
            matrices.method_46416((float)textX, (float)(textYPos + 10), 0.0f);
            matrices.method_22905(0.6f, 0.6f, 1.0f);
            context.method_51433(this.field_22793, price, 0, 0, 0xFFFF00, false);
            matrices.method_22909();
            if (mouseX < slotX || mouseX >= slotX + 42 || mouseY < slotY || mouseY >= slotY + 42) continue;
            context.method_25294(slotX, slotY, slotX + 42, slotY + 42, -2130706433);
        }
    }

    private void drawNavigationButtons(class_332 context, int mouseX, int mouseY) {
        int totalPages = (int)Math.ceil((double)this.constructions.size() / 8.0);
        if (totalPages <= 1) {
            return;
        }
        int buttonAreaX = this.x + 52;
        int buttonAreaY = this.y + 148;
        int buttonAreaWidth = 90;
        int totalButtonWidth = 43;
        int buttonStartX = buttonAreaX + (buttonAreaWidth - totalButtonWidth) / 2;
        if (this.currentPage > 0) {
            boolean hover = mouseX >= buttonStartX && mouseX < buttonStartX + 19 && mouseY >= buttonAreaY && mouseY < buttonAreaY + 9;
            int textureY = hover ? 176 : 165;
            context.method_25302(TEXTURE, buttonStartX, buttonAreaY, 1, textureY, 19, 9);
        }
        if (this.currentPage < totalPages - 1) {
            int nextX = buttonStartX + 24;
            boolean hover = mouseX >= nextX && mouseX < nextX + 19 && mouseY >= buttonAreaY && mouseY < buttonAreaY + 9;
            int textureY = hover ? 176 : 165;
            context.method_25302(TEXTURE, nextX, buttonAreaY, 22, textureY, 19, 9);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int startIndex = this.currentPage * 8;
        int endIndex = Math.min(startIndex + 8, this.constructions.size());
        int[] slotsX = new int[]{6, 53, 100, 147, 6, 53, 100, 147};
        int[] slotsY = new int[]{27, 27, 27, 27, 89, 89, 89, 89};
        for (int i = startIndex; i < endIndex; ++i) {
            int slotIndex = i - startIndex;
            int slotX = this.x + slotsX[slotIndex];
            int slotY = this.y + slotsY[slotIndex];
            if (!(mouseX >= (double)slotX) || !(mouseX < (double)(slotX + 42)) || !(mouseY >= (double)slotY) || !(mouseY < (double)(slotY + 42))) continue;
            Construction construction = this.constructions.get(i);
            this.onConstructionClicked(construction);
            return true;
        }
        int totalPages = (int)Math.ceil((double)this.constructions.size() / 8.0);
        if (totalPages > 1) {
            int nextX;
            int buttonAreaX = this.x + 52;
            int buttonAreaY = this.y + 148;
            int buttonAreaWidth = 90;
            int totalButtonWidth = 43;
            int buttonStartX = buttonAreaX + (buttonAreaWidth - totalButtonWidth) / 2;
            if (this.currentPage > 0 && mouseX >= (double)buttonStartX && mouseX < (double)(buttonStartX + 19) && mouseY >= (double)buttonAreaY && mouseY < (double)(buttonAreaY + 9)) {
                --this.currentPage;
                return true;
            }
            if (this.currentPage < totalPages - 1 && mouseX >= (double)(nextX = buttonStartX + 24) && mouseX < (double)(nextX + 19) && mouseY >= (double)buttonAreaY && mouseY < (double)(buttonAreaY + 9)) {
                ++this.currentPage;
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private void onConstructionClicked(Construction construction) {
        if (this.field_22787 != null) {
            this.field_22787.method_1507((class_437)new ConstructionDetailScreen(this, construction));
        }
    }

    public void updateBalance(long newBalance) {
        this.playerBalance = newBalance;
    }

    public boolean method_25421() {
        return false;
    }
}

