/*
 * Decompiled with CFR 0.152.
 */
package com.abfann.schematicmarket.client.gui;

import com.abfann.schematicmarket.construction.Construction;
import com.abfann.schematicmarket.economy.EconomyManager;
import com.abfann.schematicmarket.util.TranslationManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_757;

@Environment(value=EnvType.CLIENT)
public class ConstructionDetailScreen
extends class_437 {
    private static final class_2960 TEXTURE = new class_2960("schematicmarket", "textures/gui/detail_gui.png");
    private static final int GUI_WIDTH = 195;
    private static final int GUI_HEIGHT = 162;
    private int x;
    private int y;
    private final class_437 parent;
    private final Construction construction;
    private long playerBalance;
    private int currentImageIndex = 0;
    private int selectedRotation = 0;
    private int descriptionScroll = 0;
    private List<String> descriptionLines = new ArrayList<String>();

    public ConstructionDetailScreen(class_437 parent, Construction construction) {
        super((class_2561)class_2561.method_43470((String)construction.getName()));
        this.parent = parent;
        this.construction = construction;
    }

    protected void method_25426() {
        super.method_25426();
        this.x = (this.field_22789 - 195) / 2;
        this.y = (this.field_22790 - 162) / 2;
        this.playerBalance = EconomyManager.getClientBalance();
        this.descriptionLines = this.wrapText(this.construction.getDescription(), 110);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
        context.method_25302(TEXTURE, this.x, this.y, 0, 0, 195, 162);
        this.drawHeader(context);
        this.drawGallery(context, mouseX, mouseY);
        this.drawInfo(context);
        this.drawMaterials(context);
        this.drawRotationSelector(context, mouseX, mouseY);
        this.drawPurchaseButton(context, mouseX, mouseY);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    private void drawHeader(class_332 context) {
        String backText = TranslationManager.translate("gui.schematicmarket.detail.back", new Object[0]);
        context.method_51433(this.field_22793, backText, this.x + 4, this.y + 7, 0, false);
        String balanceText = "" + this.playerBalance;
        context.method_51433(this.field_22793, balanceText, this.x + 150, this.y + 7, 0xFFFF00, false);
    }

    private void drawGallery(class_332 context, int mouseX, int mouseY) {
        block5: {
            int imgX = this.x + 6;
            int imgY = this.y + 27;
            String thumbnailId = this.construction.getThumbnailId();
            if (thumbnailId != null && !thumbnailId.isEmpty()) {
                try {
                    class_2960 thumbnail = class_2960.method_12829((String)thumbnailId);
                    if (thumbnail != null) {
                        RenderSystem.setShaderTexture((int)0, (class_2960)thumbnail);
                        context.method_25290(thumbnail, imgX, imgY, 0.0f, 0.0f, 94, 94, 94, 94);
                        break block5;
                    }
                    context.method_25294(imgX, imgY, imgX + 94, imgY + 94, -11184811);
                }
                catch (Exception e) {
                    context.method_25294(imgX, imgY, imgX + 94, imgY + 94, -11184811);
                }
            } else {
                context.method_25294(imgX, imgY, imgX + 94, imgY + 94, -11184811);
            }
        }
    }

    private void drawInfo(class_332 context) {
        class_4587 matrices = context.method_51448();
        int infoX = this.x + 104;
        int infoY = this.y + 28;
        Object name = this.construction.getName();
        if (this.field_22793.method_1727((String)name) > 86) {
            name = this.field_22793.method_27523((String)name, 82) + "...";
        }
        context.method_51433(this.field_22793, (String)name, infoX, infoY, 0xFFFFFF, true);
        matrices.method_22903();
        matrices.method_46416((float)infoX, (float)(infoY + 12), 0.0f);
        matrices.method_22905(0.8f, 0.8f, 1.0f);
        context.method_51433(this.field_22793, this.construction.getCategory(), 0, 0, 0xFFFFFF, false);
        matrices.method_22909();
        String author = TranslationManager.translate("gui.schematicmarket.detail.author", this.construction.getAuthor());
        matrices.method_22903();
        matrices.method_46416((float)infoX, (float)(infoY + 21), 0.0f);
        matrices.method_22905(0.65f, 0.65f, 1.0f);
        context.method_51433(this.field_22793, author, 0, 0, 0xFFFFFF, false);
        matrices.method_22909();
        String size = TranslationManager.translate("gui.schematicmarket.detail.size", this.construction.getWidth(), this.construction.getHeight(), this.construction.getLength());
        matrices.method_22903();
        matrices.method_46416((float)infoX, (float)(infoY + 28), 0.0f);
        matrices.method_22905(0.6f, 0.6f, 1.0f);
        context.method_51433(this.field_22793, size, 0, 0, 0xFFFFFF, false);
        matrices.method_22909();
    }

    private void drawMaterials(class_332 context) {
        class_4587 matrices = context.method_51448();
        int descX = this.x + 105;
        int descY = this.y + 63;
        int descWidth = 83;
        int descHeight = 57;
        matrices.method_22903();
        matrices.method_46416((float)descX, (float)descY, 0.0f);
        matrices.method_22905(0.75f, 0.75f, 1.0f);
        int maxLines = 7;
        int startLine = Math.max(0, Math.min(this.descriptionScroll, this.descriptionLines.size() - maxLines));
        int endLine = Math.min(startLine + maxLines, this.descriptionLines.size());
        int lineY = 0;
        for (int i = startLine; i < endLine; ++i) {
            context.method_51433(this.field_22793, this.descriptionLines.get(i), 0, lineY, 0xFFFFFF, false);
            lineY += 9;
        }
        matrices.method_22909();
        if (this.descriptionLines.size() > maxLines) {
            matrices.method_22903();
            matrices.method_46416((float)(descX + 50), (float)(descY + descHeight - 5), 0.0f);
            matrices.method_22905(0.5f, 0.5f, 1.0f);
            String scrollHint = String.format("\u2195 %d/%d", startLine + 1, this.descriptionLines.size());
            context.method_51433(this.field_22793, scrollHint, 0, 0, 0x888888, false);
            matrices.method_22909();
        }
    }

    private void drawRotationSelector(class_332 context, int mouseX, int mouseY) {
        class_4587 matrices = context.method_51448();
        int rotX = this.x + 5;
        int rotY = this.y + 124;
        matrices.method_22903();
        matrices.method_46416((float)rotX, (float)rotY, 0.0f);
        matrices.method_22905(0.75f, 0.75f, 1.0f);
        String rotLabel = TranslationManager.translate("gui.schematicmarket.detail.rotation", new Object[0]);
        context.method_51433(this.field_22793, rotLabel, 0, 0, 0xFFFFFF, false);
        matrices.method_22909();
        String[] rotations = new String[]{"0\u00b0", "90\u00b0", "180\u00b0", "270\u00b0"};
        int optionX = rotX + 42;
        for (int i = 0; i < rotations.length; ++i) {
            boolean hover;
            boolean selected = this.selectedRotation == i;
            boolean bl = hover = mouseX >= optionX && mouseX < optionX + 22 && mouseY >= rotY && mouseY < rotY + 8;
            int color = selected ? 0xFFFF00 : (hover ? 0xFFFFFF : 0xAAAAAA);
            Object text = rotations[i];
            if (selected) {
                text = "\u00a7n" + (String)text;
            }
            matrices.method_22903();
            matrices.method_46416((float)optionX, (float)rotY, 0.0f);
            matrices.method_22905(0.7f, 0.7f, 1.0f);
            context.method_51433(this.field_22793, (String)text, 0, 0, color, false);
            matrices.method_22909();
            optionX += 28;
        }
    }

    private void drawPurchaseButton(class_332 context, int mouseX, int mouseY) {
        boolean hover;
        int buttonWidth = 120;
        int buttonHeight = 18;
        int buttonX = this.x + 4 + (185 - buttonWidth) / 2;
        int buttonY = this.y + 138;
        boolean canAfford = this.playerBalance >= this.construction.getFinalPrice();
        boolean bl = hover = mouseX >= buttonX && mouseX < buttonX + buttonWidth && mouseY >= buttonY && mouseY < buttonY + buttonHeight;
        int textureY = !canAfford ? 187 : (hover ? 207 : 167);
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
        context.method_25302(TEXTURE, buttonX, buttonY, 22, textureY, buttonWidth, buttonHeight);
        String priceText = this.construction.getFinalPrice() + " \ud83d\udc8e";
        int textWidth = this.field_22793.method_1727(priceText);
        int textX = buttonX + (buttonWidth - textWidth) / 2;
        int textY = buttonY + 5;
        int textColor = canAfford ? 0 : 0x888888;
        context.method_51433(this.field_22793, priceText, textX, textY, textColor, false);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (mouseX >= (double)(this.x + 4) && mouseX < (double)(this.x + 100) && mouseY >= (double)(this.y + 4) && mouseY < (double)(this.y + 16)) {
            this.method_25419();
            return true;
        }
        int rotX = this.x + 42;
        int rotY = this.y + 124;
        for (int i = 0; i < 4; ++i) {
            int optionX = rotX + 5 + i * 28;
            if (!(mouseX >= (double)optionX) || !(mouseX < (double)(optionX + 22)) || !(mouseY >= (double)rotY) || !(mouseY < (double)(rotY + 8))) continue;
            this.selectedRotation = i;
            return true;
        }
        int buttonWidth = 120;
        int buttonHeight = 18;
        int buttonX = this.x + 4 + (185 - buttonWidth) / 2;
        int buttonY = this.y + 138;
        if (mouseX >= (double)buttonX && mouseX < (double)(buttonX + buttonWidth) && mouseY >= (double)buttonY && mouseY < (double)(buttonY + buttonHeight)) {
            if (this.playerBalance >= this.construction.getFinalPrice()) {
                this.onPurchaseClicked();
            }
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private void onPurchaseClicked() {
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            class_2540 buf = PacketByteBufs.create();
            buf.method_10814(this.construction.getId());
            buf.writeInt(this.selectedRotation);
            ClientPlayNetworking.send((class_2960)new class_2960("schematicmarket", "purchase_construction"), (class_2540)buf);
            this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a77Purchasing " + this.construction.getName() + "...")), false);
            this.method_25419();
        }
    }

    private List<String> wrapText(String text, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            String testLine;
            String string = testLine = currentLine.length() == 0 ? word : currentLine + " " + word;
            if (this.field_22793.method_1727(testLine) <= maxWidth) {
                if (currentLine.length() > 0) {
                    currentLine.append(" ");
                }
                currentLine.append(word);
                continue;
            }
            if (currentLine.length() > 0) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder(word);
                continue;
            }
            lines.add(this.field_22793.method_27523(word, maxWidth));
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        int descX = this.x + 105;
        int descY = this.y + 63;
        if (mouseX >= (double)descX && mouseX < (double)(descX + 83) && mouseY >= (double)descY && mouseY < (double)(descY + 57)) {
            int maxScroll = Math.max(0, this.descriptionLines.size() - 7);
            if (amount > 0.0) {
                this.descriptionScroll = Math.max(0, this.descriptionScroll - 1);
            } else if (amount < 0.0) {
                this.descriptionScroll = Math.min(maxScroll, this.descriptionScroll + 1);
            }
            return true;
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    public void updateBalance(long newBalance) {
        this.playerBalance = newBalance;
    }

    public boolean method_25421() {
        return false;
    }
}

