/*
 * Decompiled with CFR 0.152.
 */
package com.abfann.schematicmarket.construction;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2680;

public class Construction {
    private final String id;
    private final String name;
    private final String description;
    private final String author;
    private final String category;
    private final List<String> tags;
    private final Path schematicPath;
    private final List<Path> imagePaths;
    private final int width;
    private final int height;
    private final int length;
    private final Map<class_2680, Integer> blockCounts;
    private final long basePrice;
    private final double priceMultiplier;
    private final long finalPrice;
    private final String thumbnailId;

    public Construction(String id, String name, String description, String author, String category, List<String> tags, Path schematicPath, List<Path> imagePaths, int width, int height, int length, Map<class_2680, Integer> blockCounts, long basePrice, double priceMultiplier, String thumbnailId) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.author = author;
        this.category = category;
        this.tags = tags != null ? tags : new ArrayList();
        this.schematicPath = schematicPath;
        this.imagePaths = imagePaths;
        this.width = width;
        this.height = height;
        this.length = length;
        this.blockCounts = blockCounts;
        this.basePrice = basePrice;
        this.priceMultiplier = priceMultiplier;
        this.finalPrice = (long)((double)basePrice * priceMultiplier);
        this.thumbnailId = thumbnailId;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getCategory() {
        return this.category;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Path getSchematicPath() {
        return this.schematicPath;
    }

    public List<Path> getImagePaths() {
        return this.imagePaths;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getLength() {
        return this.length;
    }

    public Map<class_2680, Integer> getBlockCounts() {
        return this.blockCounts;
    }

    public long getBasePrice() {
        return this.basePrice;
    }

    public double getPriceMultiplier() {
        return this.priceMultiplier;
    }

    public long getFinalPrice() {
        return this.finalPrice;
    }

    public String getThumbnailId() {
        return this.thumbnailId;
    }

    public Path getThumbnail() {
        return this.imagePaths.isEmpty() ? null : this.imagePaths.get(0);
    }

    public int getTotalBlocks() {
        return this.blockCounts.values().stream().mapToInt(Integer::intValue).sum();
    }

    public List<String> getFormattedMaterials() {
        ArrayList<String> materials = new ArrayList<String>();
        this.blockCounts.entrySet().stream().sorted((e1, e2) -> ((Integer)e2.getValue()).compareTo((Integer)e1.getValue())).limit(10L).forEach(entry -> {
            class_2680 state = (class_2680)entry.getKey();
            int count = (Integer)entry.getValue();
            String blockName = state.method_26204().method_9518().getString();
            materials.add(blockName + " x" + count);
        });
        return materials;
    }

    public String toString() {
        return "Construction{id='" + this.id + "', name='" + this.name + "', category='" + this.category + "', size=" + this.width + "x" + this.height + "x" + this.length + ", price=" + this.finalPrice + "}";
    }
}

