/*
 * Decompiled with CFR 0.152.
 */
package com.abfann.schematicmarket.construction;

import com.abfann.schematicmarket.SchematicMarket;
import com.abfann.schematicmarket.construction.Construction;
import com.abfann.schematicmarket.construction.ConstructionMetadata;
import com.abfann.schematicmarket.construction.PriceCalculator;
import com.abfann.schematicmarket.construction.schematic.SchematicData;
import com.abfann.schematicmarket.construction.schematic.SchematicReader;
import java.io.IOException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;

public class ConstructionLoader {
    private static final Map<String, Construction> CONSTRUCTIONS = new HashMap<String, Construction>();
    private static final Path CONFIG_CONSTRUCTIONS_DIR = FabricLoader.getInstance().getConfigDir().resolve("schematicmarket").resolve("constructions");

    public static void loadAll() {
        CONSTRUCTIONS.clear();
        SchematicMarket.LOGGER.info("Loading constructions...");
        ConstructionLoader.loadFromResources();
        ConstructionLoader.loadFromConfig();
        SchematicMarket.LOGGER.info("Loaded {} constructions total", (Object)CONSTRUCTIONS.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadFromResources() {
        try {
            URI uri = ConstructionLoader.class.getResource("/assets/schematicmarket/constructions").toURI();
            FileSystem fileSystem = null;
            boolean shouldCloseFileSystem = false;
            try {
                Path constructionsPath;
                if (uri.getScheme().equals("jar")) {
                    try {
                        fileSystem = FileSystems.getFileSystem(uri);
                    }
                    catch (FileSystemNotFoundException e) {
                        fileSystem = FileSystems.newFileSystem(uri, new HashMap());
                        shouldCloseFileSystem = true;
                    }
                    constructionsPath = fileSystem.getPath("/assets/schematicmarket/constructions", new String[0]);
                } else {
                    constructionsPath = Paths.get(uri);
                }
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(constructionsPath, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
                    for (Path constructionDir : stream) {
                        String constructionId = constructionDir.getFileName().toString();
                        ConstructionLoader.loadConstructionFromResources(constructionDir);
                    }
                }
            }
            finally {
                if (shouldCloseFileSystem && fileSystem != null) {
                    fileSystem.close();
                }
            }
        }
        catch (Exception e) {
            SchematicMarket.LOGGER.error("Failed to load constructions from resources", (Throwable)e);
        }
    }

    private static void loadConstructionFromResources(Path constructionDir) {
        String id = constructionDir.getFileName().toString();
        try {
            SchematicMarket.LOGGER.info("Loading construction from resources: {}", (Object)id);
            Path schematicPath = constructionDir.resolve("construction.schem");
            if (!Files.exists(schematicPath, new LinkOption[0])) {
                schematicPath = constructionDir.resolve("construction.schematic");
            }
            if (!Files.exists(schematicPath, new LinkOption[0])) {
                SchematicMarket.LOGGER.warn("No schematic file found for: {}", (Object)id);
                return;
            }
            SchematicData schematicData = SchematicReader.read(schematicPath);
            Path infoPath = constructionDir.resolve("info.json");
            ConstructionMetadata metadata = ConstructionMetadata.load(infoPath);
            long basePrice = PriceCalculator.calculatePrice(schematicData.getBlockCounts(), 1.0);
            Construction construction = new Construction(id, metadata.getName(), metadata.getDescription(), metadata.getAuthor(), metadata.getCategory(), metadata.getTags(), schematicPath, Collections.emptyList(), schematicData.getWidth(), schematicData.getHeight(), schematicData.getLength(), schematicData.getBlockCounts(), basePrice, metadata.getPriceMultiplier(), metadata.getThumbnail());
            CONSTRUCTIONS.put(id, construction);
            SchematicMarket.LOGGER.info("\u2713 Loaded from resources: {} - {} (Price: {})", new Object[]{id, construction.getName(), construction.getFinalPrice()});
        }
        catch (Exception e) {
            SchematicMarket.LOGGER.error("Failed to load construction from resources: {}", (Object)id, (Object)e);
        }
    }

    private static void loadFromConfig() {
        try {
            Files.createDirectories(CONFIG_CONSTRUCTIONS_DIR, new FileAttribute[0]);
            SchematicMarket.LOGGER.info("Loading constructions from config: {}", (Object)CONFIG_CONSTRUCTIONS_DIR);
            if (ConstructionLoader.isEmpty(CONFIG_CONSTRUCTIONS_DIR) && CONSTRUCTIONS.isEmpty()) {
                ConstructionLoader.createExampleConstruction();
            }
            try (Stream<Path> paths = Files.list(CONFIG_CONSTRUCTIONS_DIR);){
                paths.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(ConstructionLoader::loadConstructionFromConfig);
            }
        }
        catch (IOException e) {
            SchematicMarket.LOGGER.error("Failed to load constructions from config", (Throwable)e);
        }
    }

    private static void loadConstructionFromConfig(Path constructionDir) {
        String id = constructionDir.getFileName().toString();
        try {
            SchematicMarket.LOGGER.info("Loading construction from config: {}", (Object)id);
            Path schematicPath = ConstructionLoader.findSchematicFile(constructionDir);
            if (schematicPath == null) {
                SchematicMarket.LOGGER.warn("No schematic file found in: {}", (Object)constructionDir);
                return;
            }
            SchematicData schematicData = SchematicReader.read(schematicPath);
            Path infoPath = constructionDir.resolve("info.json");
            ConstructionMetadata metadata = ConstructionMetadata.load(infoPath);
            List<Path> imagePaths = ConstructionLoader.findImages(constructionDir);
            long basePrice = PriceCalculator.calculatePrice(schematicData.getBlockCounts(), 1.0);
            Construction construction = new Construction(id, metadata.getName(), metadata.getDescription(), metadata.getAuthor(), metadata.getCategory(), metadata.getTags(), schematicPath, imagePaths, schematicData.getWidth(), schematicData.getHeight(), schematicData.getLength(), schematicData.getBlockCounts(), basePrice, metadata.getPriceMultiplier(), metadata.getThumbnail());
            CONSTRUCTIONS.put(id, construction);
            SchematicMarket.LOGGER.info("\u2713 Loaded from config: {} - {} (Price: {})", new Object[]{id, construction.getName(), construction.getFinalPrice()});
        }
        catch (Exception e) {
            SchematicMarket.LOGGER.error("Failed to load construction from config: {}", (Object)id, (Object)e);
        }
    }

    private static Path findSchematicFile(Path dir) throws IOException {
        Path schemPath = dir.resolve("construction.schem");
        if (Files.exists(schemPath, new LinkOption[0])) {
            return schemPath;
        }
        Path schematicPath = dir.resolve("construction.schematic");
        if (Files.exists(schematicPath, new LinkOption[0])) {
            return schematicPath;
        }
        return null;
    }

    private static List<Path> findImages(Path dir) {
        Path imagePath;
        ArrayList<Path> images = new ArrayList<Path>();
        for (int i = 0; i < 10 && Files.exists(imagePath = dir.resolve(i + ".png"), new LinkOption[0]); ++i) {
            images.add(imagePath);
        }
        return images;
    }

    private static boolean isEmpty(Path dir) throws IOException {
        if (!Files.exists(dir, new LinkOption[0])) {
            return true;
        }
        try (Stream<Path> entries = Files.list(dir);){
            boolean bl = entries.findAny().isEmpty();
            return bl;
        }
    }

    private static void createExampleConstruction() {
        try {
            Path exampleDir = CONFIG_CONSTRUCTIONS_DIR.resolve("example_construction");
            Files.createDirectories(exampleDir, new FileAttribute[0]);
            String exampleInfo = "{\n  \"name\": \"Custom Server Construction\",\n  \"description\": \"Place your .schem file here and edit this info.json. Delete this example when ready.\",\n  \"author\": \"Server Admin\",\n  \"category\": \"Custom\",\n  \"price_multiplier\": 1.0,\n  \"tags\": [\"custom\", \"server\"],\n  \"thumbnail\": null\n}\n";
            Files.writeString(exampleDir.resolve("info.json"), (CharSequence)exampleInfo, new OpenOption[0]);
            String readme = "HOW TO ADD CUSTOM CONSTRUCTIONS TO THE SERVER\n=============================================\n\nIMPORTANT: Constructions included in the mod should be placed in:\nsrc/main/resources/assets/schematicmarket/constructions/\n\nThis folder (config/schematicmarket/constructions/) is for\nCUSTOM SERVER-SIDE constructions that admins can add without\nupdating the mod.\n\nTo add a custom construction:\n1. Create a folder with the construction name\n2. Add construction.schem or construction.schematic\n3. Add info.json (see example below)\n4. Restart server or use /reload\n\nNote: Custom constructions from config won't show thumbnails\nunless you implement a texture sync system.\n";
            Files.writeString(exampleDir.resolve("README.txt"), (CharSequence)readme, new OpenOption[0]);
            SchematicMarket.LOGGER.info("Created example construction directory");
        }
        catch (IOException e) {
            SchematicMarket.LOGGER.error("Failed to create example construction", (Throwable)e);
        }
    }

    public static Map<String, Construction> getAllConstructions() {
        return new HashMap<String, Construction>(CONSTRUCTIONS);
    }

    public static Construction getConstruction(String id) {
        return CONSTRUCTIONS.get(id);
    }

    public static List<Construction> getByCategory(String category) {
        return CONSTRUCTIONS.values().stream().filter(c -> c.getCategory().equalsIgnoreCase(category)).toList();
    }

    public static List<Construction> getConstructions() {
        ArrayList<Construction> constructions = new ArrayList<Construction>(CONSTRUCTIONS.values());
        constructions.sort((a, b) -> {
            int categoryCompare = a.getCategory().compareToIgnoreCase(b.getCategory());
            if (categoryCompare != 0) {
                return categoryCompare;
            }
            return a.getName().compareToIgnoreCase(b.getName());
        });
        return constructions;
    }
}

