/*
 * Decompiled with CFR 0.152.
 */
package com.abfann.schematicmarket.construction;

import com.google.gson.Gson;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class ConstructionMetadata {
    private String name;
    private String description;
    private String author;
    private String category;
    private double price_multiplier = 1.0;
    private List<String> tags;
    private String thumbnail;

    public static ConstructionMetadata load(Path infoJsonPath) throws IOException {
        if (!Files.exists(infoJsonPath, new LinkOption[0])) {
            return ConstructionMetadata.createDefault();
        }
        try {
            String json = Files.readString(infoJsonPath);
            Gson gson = new Gson();
            return (ConstructionMetadata)gson.fromJson(json, ConstructionMetadata.class);
        }
        catch (Exception e) {
            throw new IOException("Failed to parse info.json: " + e.getMessage(), e);
        }
    }

    public static ConstructionMetadata createDefault() {
        ConstructionMetadata metadata = new ConstructionMetadata();
        metadata.name = "Unnamed Construction";
        metadata.description = "No description provided";
        metadata.author = "Unknown";
        metadata.category = "Other";
        metadata.price_multiplier = 1.0;
        metadata.tags = new ArrayList<String>();
        return metadata;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public double getPriceMultiplier() {
        return this.price_multiplier;
    }

    public void setPriceMultiplier(double price_multiplier) {
        this.price_multiplier = price_multiplier;
    }

    public List<String> getTags() {
        return this.tags != null ? this.tags : new ArrayList<String>();
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public String getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(String thumbnail) {
        this.thumbnail = thumbnail;
    }
}

