/*
 * Decompiled with CFR 0.152.
 */
package com.abfann.schematicmarket.construction.schematic;

import com.abfann.schematicmarket.SchematicMarket;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1936;
import net.minecraft.class_2215;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2312;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2354;
import net.minecraft.class_2382;
import net.minecraft.class_2389;
import net.minecraft.class_2401;
import net.minecraft.class_2423;
import net.minecraft.class_2457;
import net.minecraft.class_2465;
import net.minecraft.class_2470;
import net.minecraft.class_2482;
import net.minecraft.class_2487;
import net.minecraft.class_2508;
import net.minecraft.class_2510;
import net.minecraft.class_2527;
import net.minecraft.class_2533;
import net.minecraft.class_2544;
import net.minecraft.class_2546;
import net.minecraft.class_2551;
import net.minecraft.class_2555;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2750;
import net.minecraft.class_2756;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7923;

public class SchematicPaster {
    public static void paste(class_3218 world, class_2338 startPos, class_2487 schematicNbt, int rotation) {
        try {
            if (schematicNbt.method_10545("Palette")) {
                SchematicPaster.pasteSpongeSchematic(world, startPos, schematicNbt, rotation);
            } else if (schematicNbt.method_10545("Blocks")) {
                SchematicPaster.pasteMCEditSchematic(world, startPos, schematicNbt, rotation);
            } else {
                SchematicMarket.LOGGER.error("Unknown schematic format");
            }
        }
        catch (Exception e) {
            SchematicMarket.LOGGER.error("Failed to paste schematic", (Throwable)e);
        }
    }

    private static void pasteSpongeSchematic(class_3218 world, class_2338 startPos, class_2487 nbt, int rotation) {
        int width = nbt.method_10568("Width");
        int height = nbt.method_10568("Height");
        int length = nbt.method_10568("Length");
        SchematicMarket.LOGGER.info("Pasting schematic: {}x{}x{} with rotation {}", new Object[]{width, height, length, rotation * 90});
        class_2487 palette = nbt.method_10562("Palette");
        HashMap<Integer, class_2680> paletteMap = new HashMap<Integer, class_2680>();
        for (String key : palette.method_10541()) {
            int id = palette.method_10550(key);
            class_2680 state = SchematicPaster.parseBlockState(key);
            paletteMap.put(id, state);
        }
        byte[] blockData = nbt.method_10547("BlockData");
        HashMap<class_2338, class_2680> solidBlocks = new HashMap<class_2338, class_2680>();
        HashMap<class_2338, class_2680> attachableBlocks = new HashMap<class_2338, class_2680>();
        int index = 0;
        for (int y = 0; y < height; ++y) {
            for (int z = 0; z < length; ++z) {
                for (int x = 0; x < width && index < blockData.length; ++index, ++x) {
                    int paletteId = Byte.toUnsignedInt(blockData[index]);
                    class_2680 state = paletteMap.getOrDefault(paletteId, class_2246.field_10124.method_9564());
                    if (state.method_26215()) continue;
                    class_2338 rotatedPos = SchematicPaster.rotatePosition(x, y, z, width, height, length, rotation);
                    class_2338 worldPos = startPos.method_10081((class_2382)rotatedPos);
                    class_2680 rotatedState = SchematicPaster.rotateBlockState(state, rotation);
                    if (SchematicPaster.needsSupport(state.method_26204())) {
                        attachableBlocks.put(worldPos, rotatedState);
                        continue;
                    }
                    solidBlocks.put(worldPos, rotatedState);
                }
            }
        }
        for (Map.Entry entry : solidBlocks.entrySet()) {
            world.method_8652((class_2338)entry.getKey(), (class_2680)entry.getValue(), 3);
        }
        for (Map.Entry entry : attachableBlocks.entrySet()) {
            world.method_8652((class_2338)entry.getKey(), (class_2680)entry.getValue(), 3);
        }
        SchematicMarket.LOGGER.info("Successfully pasted schematic ({} solid, {} attachable)", (Object)solidBlocks.size(), (Object)attachableBlocks.size());
    }

    private static void pasteMCEditSchematic(class_3218 world, class_2338 startPos, class_2487 nbt, int rotation) {
        int width = nbt.method_10568("Width");
        int height = nbt.method_10568("Height");
        int length = nbt.method_10568("Length");
        SchematicMarket.LOGGER.info("Pasting MCEdit schematic: {}x{}x{} with rotation {}", new Object[]{width, height, length, rotation * 90});
        byte[] blocks = nbt.method_10547("Blocks");
        byte[] blockData = nbt.method_10547("Data");
        HashMap<class_2338, class_2680> solidBlocks = new HashMap<class_2338, class_2680>();
        HashMap<class_2338, class_2680> attachableBlocks = new HashMap<class_2338, class_2680>();
        int index = 0;
        for (int y = 0; y < height; ++y) {
            for (int z = 0; z < length; ++z) {
                for (int x = 0; x < width && index < blocks.length; ++index, ++x) {
                    int data;
                    int blockId = Byte.toUnsignedInt(blocks[index]);
                    class_2680 state = SchematicPaster.legacyIdToBlockState(blockId, data = index < blockData.length ? Byte.toUnsignedInt(blockData[index]) : 0);
                    if (state.method_26215()) continue;
                    class_2338 rotatedPos = SchematicPaster.rotatePosition(x, y, z, width, height, length, rotation);
                    class_2338 worldPos = startPos.method_10081((class_2382)rotatedPos);
                    class_2680 rotatedState = SchematicPaster.rotateBlockState(state, rotation);
                    if (SchematicPaster.needsSupport(state.method_26204())) {
                        attachableBlocks.put(worldPos, rotatedState);
                        continue;
                    }
                    solidBlocks.put(worldPos, rotatedState);
                }
            }
        }
        for (Map.Entry entry : solidBlocks.entrySet()) {
            world.method_8652((class_2338)entry.getKey(), (class_2680)entry.getValue(), 3);
        }
        for (Map.Entry entry : attachableBlocks.entrySet()) {
            world.method_8652((class_2338)entry.getKey(), (class_2680)entry.getValue(), 3);
        }
        for (Map.Entry entry : solidBlocks.entrySet()) {
            class_2338 pos;
            class_2680 newState;
            class_2680 state = (class_2680)entry.getValue();
            if (!(state.method_26204() instanceof class_2510) && !(state.method_26204() instanceof class_2354) && !(state.method_26204() instanceof class_2349) && !(state.method_26204() instanceof class_2544) && !(state.method_26204() instanceof class_2389) || (newState = state.method_26191(class_2350.field_11043, world.method_8320((pos = (class_2338)entry.getKey()).method_10095()), (class_1936)world, pos, pos.method_10095())) == state) continue;
            world.method_8652(pos, newState, 3);
        }
        SchematicMarket.LOGGER.info("Successfully pasted schematic ({} solid, {} attachable)", (Object)solidBlocks.size(), (Object)attachableBlocks.size());
    }

    private static class_2338 rotatePosition(int x, int y, int z, int width, int height, int length, int rotation) {
        return switch (rotation) {
            case 1 -> new class_2338(length - z - 1, y, x);
            case 2 -> new class_2338(width - x - 1, y, length - z - 1);
            case 3 -> new class_2338(z, y, width - x - 1);
            default -> new class_2338(x, y, z);
        };
    }

    private static class_2680 rotateBlockState(class_2680 state, int rotation) {
        return state.method_26186(switch (rotation) {
            case 1 -> class_2470.field_11463;
            case 2 -> class_2470.field_11464;
            case 3 -> class_2470.field_11465;
            default -> class_2470.field_11467;
        });
    }

    private static class_2680 parseBlockState(String blockStateString) {
        try {
            String[] parts = blockStateString.split("\\[");
            String blockId = parts[0];
            class_2960 id = class_2960.method_12829((String)blockId);
            if (id == null || !class_7923.field_41175.method_10250(id)) {
                return class_2246.field_10124.method_9564();
            }
            class_2248 block = (class_2248)class_7923.field_41175.method_10223(id);
            class_2680 state = block.method_9564();
            if (parts.length > 1) {
                String[] properties;
                String propertiesStr = parts[1].replace("]", "");
                for (String property : properties = propertiesStr.split(",")) {
                    String[] keyValue = property.split("=");
                    if (keyValue.length != 2) continue;
                    String key = keyValue[0];
                    String value = keyValue[1];
                    state = SchematicPaster.applyProperty(state, key, value);
                }
            }
            return state;
        }
        catch (Exception e) {
            SchematicMarket.LOGGER.debug("Failed to parse blockstate: {}", (Object)blockStateString, (Object)e);
            return class_2246.field_10124.method_9564();
        }
    }

    private static class_2680 applyProperty(class_2680 state, String propertyName, String value) {
        try {
            for (class_2769 property : state.method_28501()) {
                Optional optionalValue;
                if (!property.method_11899().equals(propertyName) || !(optionalValue = property.method_11900(value)).isPresent()) continue;
                return (class_2680)state.method_11657(property, (Comparable)optionalValue.get());
            }
        }
        catch (Exception e) {
            SchematicMarket.LOGGER.debug("Failed to apply property {}={}", new Object[]{propertyName, value, e});
        }
        return state;
    }

    private static boolean needsSupport(class_2248 block) {
        return block instanceof class_2323 || block instanceof class_2527 || block instanceof class_2555 || block instanceof class_2269 || block instanceof class_2401 || block instanceof class_2508 || block instanceof class_2551 || block instanceof class_2215 || block instanceof class_2546 || block instanceof class_2312 || block instanceof class_2457;
    }

    private static class_2680 legacyIdToBlockState(int blockId, int data) {
        switch (blockId) {
            case 0: {
                return class_2246.field_10124.method_9564();
            }
            case 1: {
                return class_2246.field_10340.method_9564();
            }
            case 2: {
                return class_2246.field_10219.method_9564();
            }
            case 3: {
                return class_2246.field_10566.method_9564();
            }
            case 4: {
                return class_2246.field_10445.method_9564();
            }
            case 5: {
                return switch (data) {
                    case 1 -> class_2246.field_9975.method_9564();
                    case 2 -> class_2246.field_10148.method_9564();
                    case 3 -> class_2246.field_10334.method_9564();
                    case 4 -> class_2246.field_10218.method_9564();
                    case 5 -> class_2246.field_10075.method_9564();
                    default -> class_2246.field_10161.method_9564();
                };
            }
            case 6: {
                return class_2246.field_10394.method_9564();
            }
            case 7: {
                return class_2246.field_9987.method_9564();
            }
            case 8: 
            case 9: {
                return class_2246.field_10382.method_9564();
            }
            case 10: 
            case 11: {
                return class_2246.field_10164.method_9564();
            }
            case 12: {
                return class_2246.field_10102.method_9564();
            }
            case 13: {
                return class_2246.field_10255.method_9564();
            }
            case 14: {
                return class_2246.field_10571.method_9564();
            }
            case 15: {
                return class_2246.field_10212.method_9564();
            }
            case 16: {
                return class_2246.field_10418.method_9564();
            }
            case 17: {
                class_2248 logType = switch (data % 4) {
                    case 1 -> class_2246.field_10037;
                    case 2 -> class_2246.field_10511;
                    case 3 -> class_2246.field_10306;
                    default -> class_2246.field_10431;
                };
                class_2680 state = logType.method_9564();
                if (data >= 4 && data < 8) {
                    state = (class_2680)state.method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11048);
                } else if (data >= 8) {
                    state = (class_2680)state.method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11051);
                }
                return state;
            }
            case 18: {
                return class_2246.field_10503.method_9564();
            }
            case 19: {
                return class_2246.field_10258.method_9564();
            }
            case 20: {
                return class_2246.field_10033.method_9564();
            }
            case 21: {
                return class_2246.field_10090.method_9564();
            }
            case 22: {
                return class_2246.field_10441.method_9564();
            }
            case 23: {
                return class_2246.field_10200.method_9564();
            }
            case 24: {
                return class_2246.field_9979.method_9564();
            }
            case 25: {
                return class_2246.field_10179.method_9564();
            }
            case 26: {
                return class_2246.field_10069.method_9564();
            }
            case 27: {
                return class_2246.field_10425.method_9564();
            }
            case 28: {
                return class_2246.field_10025.method_9564();
            }
            case 29: {
                return class_2246.field_10615.method_9564();
            }
            case 30: {
                return class_2246.field_10343.method_9564();
            }
            case 31: {
                return class_2246.field_10479.method_9564();
            }
            case 32: {
                return class_2246.field_10428.method_9564();
            }
            case 33: {
                return class_2246.field_10560.method_9564();
            }
            case 35: {
                return switch (data) {
                    case 0 -> class_2246.field_10446.method_9564();
                    case 1 -> class_2246.field_10095.method_9564();
                    case 2 -> class_2246.field_10215.method_9564();
                    case 3 -> class_2246.field_10294.method_9564();
                    case 4 -> class_2246.field_10490.method_9564();
                    case 5 -> class_2246.field_10028.method_9564();
                    case 6 -> class_2246.field_10459.method_9564();
                    case 7 -> class_2246.field_10423.method_9564();
                    case 8 -> class_2246.field_10222.method_9564();
                    case 9 -> class_2246.field_10619.method_9564();
                    case 10 -> class_2246.field_10259.method_9564();
                    case 11 -> class_2246.field_10514.method_9564();
                    case 12 -> class_2246.field_10113.method_9564();
                    case 13 -> class_2246.field_10170.method_9564();
                    case 14 -> class_2246.field_10314.method_9564();
                    case 15 -> class_2246.field_10146.method_9564();
                    default -> class_2246.field_10446.method_9564();
                };
            }
            case 37: {
                return class_2246.field_10182.method_9564();
            }
            case 38: {
                return class_2246.field_10449.method_9564();
            }
            case 39: {
                return class_2246.field_10251.method_9564();
            }
            case 40: {
                return class_2246.field_10559.method_9564();
            }
            case 41: {
                return class_2246.field_10205.method_9564();
            }
            case 42: {
                return class_2246.field_10085.method_9564();
            }
            case 43: {
                class_2248 slabType = switch (data & 7) {
                    case 1 -> class_2246.field_10007;
                    case 2 -> class_2246.field_10119;
                    case 3 -> class_2246.field_10351;
                    case 4 -> class_2246.field_10191;
                    case 5 -> class_2246.field_10131;
                    case 6 -> class_2246.field_10390;
                    case 7 -> class_2246.field_10237;
                    default -> class_2246.field_10454;
                };
                class_2680 state = slabType.method_9564();
                return (class_2680)state.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12682);
            }
            case 44: {
                class_2248 slabType = switch (data & 7) {
                    case 1 -> class_2246.field_10007;
                    case 2 -> class_2246.field_10119;
                    case 3 -> class_2246.field_10351;
                    case 4 -> class_2246.field_10191;
                    case 5 -> class_2246.field_10131;
                    case 6 -> class_2246.field_10390;
                    case 7 -> class_2246.field_10237;
                    default -> class_2246.field_10454;
                };
                class_2680 state = slabType.method_9564();
                return SchematicPaster.applySlabProperties(state, data);
            }
            case 45: {
                return class_2246.field_10104.method_9564();
            }
            case 46: {
                return class_2246.field_10375.method_9564();
            }
            case 47: {
                return class_2246.field_10504.method_9564();
            }
            case 48: {
                return class_2246.field_9989.method_9564();
            }
            case 49: {
                return class_2246.field_10540.method_9564();
            }
            case 50: {
                if ((data & 7) == 5 || data == 0) {
                    return class_2246.field_10336.method_9564();
                }
                class_2680 state = class_2246.field_10099.method_9564();
                return SchematicPaster.applyWallTorchProperties(state, data);
            }
            case 51: {
                return class_2246.field_10036.method_9564();
            }
            case 52: {
                return class_2246.field_10260.method_9564();
            }
            case 53: {
                class_2680 state = class_2246.field_10563.method_9564();
                return SchematicPaster.applyStairProperties(state, data);
            }
            case 54: {
                class_2680 state = class_2246.field_10034.method_9564();
                return SchematicPaster.applyBasicFacing(state, data);
            }
            case 55: {
                return class_2246.field_10091.method_9564();
            }
            case 56: {
                return class_2246.field_10442.method_9564();
            }
            case 57: {
                return class_2246.field_10201.method_9564();
            }
            case 58: {
                return class_2246.field_9980.method_9564();
            }
            case 59: {
                return class_2246.field_10293.method_9564();
            }
            case 60: {
                return class_2246.field_10362.method_9564();
            }
            case 61: 
            case 62: {
                class_2680 state = class_2246.field_10181.method_9564();
                return SchematicPaster.applyBasicFacing(state, data);
            }
            case 63: {
                return class_2246.field_10121.method_9564();
            }
            case 64: {
                class_2680 state = class_2246.field_10149.method_9564();
                return SchematicPaster.applyDoorProperties(state, data);
            }
            case 65: {
                return class_2246.field_9983.method_9564();
            }
            case 66: {
                return class_2246.field_10167.method_9564();
            }
            case 67: {
                class_2680 state = class_2246.field_10596.method_9564();
                return SchematicPaster.applyStairProperties(state, data);
            }
            case 68: {
                return class_2246.field_10187.method_9564();
            }
            case 69: {
                return class_2246.field_10363.method_9564();
            }
            case 70: {
                return class_2246.field_10158.method_9564();
            }
            case 71: {
                return class_2246.field_9973.method_9564();
            }
            case 72: {
                return class_2246.field_10484.method_9564();
            }
            case 73: 
            case 74: {
                return class_2246.field_10080.method_9564();
            }
            case 75: 
            case 76: {
                if ((data & 7) == 5 || data == 0) {
                    return class_2246.field_10523.method_9564();
                }
                class_2680 state = class_2246.field_10301.method_9564();
                return SchematicPaster.applyWallTorchProperties(state, data);
            }
            case 77: {
                class_2680 state = class_2246.field_10494.method_9564();
                return SchematicPaster.applyButtonProperties(state, data);
            }
            case 78: {
                return class_2246.field_10477.method_9564();
            }
            case 79: {
                return class_2246.field_10295.method_9564();
            }
            case 80: {
                return class_2246.field_10491.method_9564();
            }
            case 81: {
                return class_2246.field_10029.method_9564();
            }
            case 82: {
                return class_2246.field_10460.method_9564();
            }
            case 83: {
                return class_2246.field_10424.method_9564();
            }
            case 84: {
                return class_2246.field_10223.method_9564();
            }
            case 85: {
                return class_2246.field_10620.method_9564();
            }
            case 86: {
                return class_2246.field_10261.method_9564();
            }
            case 87: {
                return class_2246.field_10515.method_9564();
            }
            case 88: {
                return class_2246.field_10114.method_9564();
            }
            case 89: {
                return class_2246.field_10171.method_9564();
            }
            case 90: {
                class_2680 state = class_2246.field_10316.method_9564();
                return SchematicPaster.applyNetherPortalProperties(state, data);
            }
            case 91: {
                return class_2246.field_10009.method_9564();
            }
            case 92: {
                return class_2246.field_10183.method_9564();
            }
            case 93: 
            case 94: {
                return class_2246.field_10450.method_9564();
            }
            case 95: {
                return switch (data) {
                    case 0 -> class_2246.field_10087.method_9564();
                    case 1 -> class_2246.field_10227.method_9564();
                    case 2 -> class_2246.field_10574.method_9564();
                    case 3 -> class_2246.field_10271.method_9564();
                    case 4 -> class_2246.field_10049.method_9564();
                    case 5 -> class_2246.field_10157.method_9564();
                    case 6 -> class_2246.field_10317.method_9564();
                    case 7 -> class_2246.field_10555.method_9564();
                    case 8 -> class_2246.field_9996.method_9564();
                    case 9 -> class_2246.field_10248.method_9564();
                    case 10 -> class_2246.field_10399.method_9564();
                    case 11 -> class_2246.field_10060.method_9564();
                    case 12 -> class_2246.field_10073.method_9564();
                    case 13 -> class_2246.field_10357.method_9564();
                    case 14 -> class_2246.field_10272.method_9564();
                    case 15 -> class_2246.field_9997.method_9564();
                    default -> class_2246.field_10087.method_9564();
                };
            }
            case 96: {
                class_2680 state = class_2246.field_10137.method_9564();
                return SchematicPaster.applyTrapdoorProperties(state, data);
            }
            case 97: {
                return class_2246.field_10277.method_9564();
            }
            case 98: {
                return class_2246.field_10056.method_9564();
            }
            case 99: {
                return class_2246.field_10580.method_9564();
            }
            case 100: {
                return class_2246.field_10240.method_9564();
            }
            case 101: {
                return class_2246.field_10576.method_9564();
            }
            case 102: {
                return class_2246.field_10285.method_9564();
            }
            case 103: {
                return class_2246.field_10545.method_9564();
            }
            case 104: {
                return class_2246.field_9984.method_9564();
            }
            case 105: {
                return class_2246.field_10168.method_9564();
            }
            case 106: {
                return class_2246.field_10597.method_9564();
            }
            case 107: {
                return class_2246.field_10188.method_9564();
            }
            case 108: {
                class_2680 state = class_2246.field_10089.method_9564();
                return SchematicPaster.applyStairProperties(state, data);
            }
            case 109: {
                class_2680 state = class_2246.field_10392.method_9564();
                return SchematicPaster.applyStairProperties(state, data);
            }
            case 110: {
                return class_2246.field_10402.method_9564();
            }
            case 111: {
                return class_2246.field_10588.method_9564();
            }
            case 112: {
                return class_2246.field_10266.method_9564();
            }
            case 113: {
                return class_2246.field_10364.method_9564();
            }
            case 114: {
                return class_2246.field_10159.method_9564();
            }
            case 115: {
                return class_2246.field_9974.method_9564();
            }
            case 116: {
                return class_2246.field_10485.method_9564();
            }
            case 117: {
                return class_2246.field_10333.method_9564();
            }
            case 118: {
                return class_2246.field_10593.method_9564();
            }
            case 119: {
                return class_2246.field_10027.method_9564();
            }
            case 120: {
                return class_2246.field_10398.method_9564();
            }
            case 121: {
                return class_2246.field_10471.method_9564();
            }
            case 122: {
                return class_2246.field_10081.method_9564();
            }
            case 123: 
            case 124: {
                return class_2246.field_10524.method_9564();
            }
            case 125: {
                class_2248 slabType = switch (data & 7) {
                    case 1 -> class_2246.field_10071;
                    case 2 -> class_2246.field_10257;
                    case 3 -> class_2246.field_10617;
                    case 4 -> class_2246.field_10031;
                    case 5 -> class_2246.field_10500;
                    default -> class_2246.field_10119;
                };
                class_2680 state = slabType.method_9564();
                return (class_2680)state.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12682);
            }
            case 126: {
                class_2248 slabType = switch (data & 7) {
                    case 1 -> class_2246.field_10071;
                    case 2 -> class_2246.field_10257;
                    case 3 -> class_2246.field_10617;
                    case 4 -> class_2246.field_10031;
                    case 5 -> class_2246.field_10500;
                    default -> class_2246.field_10119;
                };
                class_2680 state = slabType.method_9564();
                return SchematicPaster.applySlabProperties(state, data);
            }
            case 127: {
                return class_2246.field_10302.method_9564();
            }
            case 128: {
                class_2680 state = class_2246.field_10142.method_9564();
                return SchematicPaster.applyStairProperties(state, data);
            }
            case 129: {
                return class_2246.field_10013.method_9564();
            }
            case 130: {
                return class_2246.field_10443.method_9564();
            }
            case 131: {
                return class_2246.field_10348.method_9564();
            }
            case 132: {
                return class_2246.field_10589.method_9564();
            }
            case 133: {
                return class_2246.field_10234.method_9564();
            }
            case 134: {
                class_2680 state = class_2246.field_10569.method_9564();
                return SchematicPaster.applyStairProperties(state, data);
            }
            case 135: {
                class_2680 state = class_2246.field_10408.method_9564();
                return SchematicPaster.applyStairProperties(state, data);
            }
            case 136: {
                class_2680 state = class_2246.field_10122.method_9564();
                return SchematicPaster.applyStairProperties(state, data);
            }
            case 137: {
                return class_2246.field_10525.method_9564();
            }
            case 138: {
                return class_2246.field_10327.method_9564();
            }
            case 139: {
                return class_2246.field_10625.method_9564();
            }
            case 140: {
                return class_2246.field_10495.method_9564();
            }
            case 141: {
                return class_2246.field_10609.method_9564();
            }
            case 142: {
                return class_2246.field_10247.method_9564();
            }
            case 143: {
                class_2680 state = class_2246.field_10057.method_9564();
                return SchematicPaster.applyButtonProperties(state, data);
            }
            case 144: {
                return class_2246.field_10481.method_9564();
            }
            case 145: {
                return class_2246.field_10535.method_9564();
            }
            case 146: {
                return class_2246.field_10380.method_9564();
            }
            case 147: {
                return class_2246.field_10224.method_9564();
            }
            case 148: {
                return class_2246.field_10582.method_9564();
            }
            case 149: 
            case 150: {
                return class_2246.field_10377.method_9564();
            }
            case 151: {
                return class_2246.field_10429.method_9564();
            }
            case 152: {
                return class_2246.field_10002.method_9564();
            }
            case 153: {
                return class_2246.field_10213.method_9564();
            }
            case 154: {
                return class_2246.field_10312.method_9564();
            }
            case 155: {
                return class_2246.field_10153.method_9564();
            }
            case 156: {
                class_2680 state = class_2246.field_10451.method_9564();
                return SchematicPaster.applyStairProperties(state, data);
            }
            case 157: {
                return class_2246.field_10546.method_9564();
            }
            case 158: {
                return class_2246.field_10228.method_9564();
            }
            case 159: {
                return switch (data) {
                    case 0 -> class_2246.field_10611.method_9564();
                    case 1 -> class_2246.field_10184.method_9564();
                    case 2 -> class_2246.field_10015.method_9564();
                    case 3 -> class_2246.field_10325.method_9564();
                    case 4 -> class_2246.field_10143.method_9564();
                    case 5 -> class_2246.field_10014.method_9564();
                    case 6 -> class_2246.field_10444.method_9564();
                    case 7 -> class_2246.field_10349.method_9564();
                    case 8 -> class_2246.field_10590.method_9564();
                    case 9 -> class_2246.field_10235.method_9564();
                    case 10 -> class_2246.field_10570.method_9564();
                    case 11 -> class_2246.field_10409.method_9564();
                    case 12 -> class_2246.field_10123.method_9564();
                    case 13 -> class_2246.field_10526.method_9564();
                    case 14 -> class_2246.field_10328.method_9564();
                    case 15 -> class_2246.field_10626.method_9564();
                    default -> class_2246.field_10611.method_9564();
                };
            }
            case 160: {
                return switch (data) {
                    case 0 -> class_2246.field_9991.method_9564();
                    case 1 -> class_2246.field_10496.method_9564();
                    case 2 -> class_2246.field_10469.method_9564();
                    case 3 -> class_2246.field_10193.method_9564();
                    case 4 -> class_2246.field_10578.method_9564();
                    case 5 -> class_2246.field_10305.method_9564();
                    case 6 -> class_2246.field_10565.method_9564();
                    case 7 -> class_2246.field_10077.method_9564();
                    case 8 -> class_2246.field_10129.method_9564();
                    case 9 -> class_2246.field_10355.method_9564();
                    case 10 -> class_2246.field_10152.method_9564();
                    case 11 -> class_2246.field_9982.method_9564();
                    case 12 -> class_2246.field_10163.method_9564();
                    case 13 -> class_2246.field_10419.method_9564();
                    case 14 -> class_2246.field_10118.method_9564();
                    case 15 -> class_2246.field_10070.method_9564();
                    default -> class_2246.field_9991.method_9564();
                };
            }
            case 161: {
                return class_2246.field_10098.method_9564();
            }
            case 162: {
                return class_2246.field_10533.method_9564();
            }
            case 163: {
                class_2680 state = class_2246.field_10256.method_9564();
                return SchematicPaster.applyStairProperties(state, data);
            }
            case 164: {
                class_2680 state = class_2246.field_10616.method_9564();
                return SchematicPaster.applyStairProperties(state, data);
            }
            case 165: {
                return class_2246.field_10030.method_9564();
            }
            case 166: {
                return class_2246.field_10499.method_9564();
            }
            case 167: {
                class_2680 state = class_2246.field_10453.method_9564();
                return SchematicPaster.applyTrapdoorProperties(state, data);
            }
            case 168: {
                return class_2246.field_10135.method_9564();
            }
            case 169: {
                return class_2246.field_10174.method_9564();
            }
            case 170: {
                return class_2246.field_10359.method_9564();
            }
            case 171: {
                return switch (data) {
                    case 0 -> class_2246.field_10466.method_9564();
                    case 1 -> class_2246.field_9977.method_9564();
                    case 2 -> class_2246.field_10482.method_9564();
                    case 3 -> class_2246.field_10290.method_9564();
                    case 4 -> class_2246.field_10512.method_9564();
                    case 5 -> class_2246.field_10040.method_9564();
                    case 6 -> class_2246.field_10393.method_9564();
                    case 7 -> class_2246.field_10591.method_9564();
                    case 8 -> class_2246.field_10209.method_9564();
                    case 9 -> class_2246.field_10433.method_9564();
                    case 10 -> class_2246.field_10510.method_9564();
                    case 11 -> class_2246.field_10043.method_9564();
                    case 12 -> class_2246.field_10473.method_9564();
                    case 13 -> class_2246.field_10338.method_9564();
                    case 14 -> class_2246.field_10536.method_9564();
                    case 15 -> class_2246.field_10106.method_9564();
                    default -> class_2246.field_10466.method_9564();
                };
            }
            case 172: {
                return class_2246.field_10415.method_9564();
            }
            case 173: {
                return class_2246.field_10381.method_9564();
            }
            case 174: {
                return class_2246.field_10225.method_9564();
            }
            case 175: {
                return class_2246.field_10583.method_9564();
            }
            case 176: {
                class_2680 state = class_2246.field_10154.method_9564();
                return SchematicPaster.applyStandingBannerProperties(state, data);
            }
            case 177: {
                class_2680 state = class_2246.field_10202.method_9564();
                return SchematicPaster.applyWallBannerProperties(state, data);
            }
            case 179: {
                return class_2246.field_10344.method_9564();
            }
            case 180: {
                return class_2246.field_10420.method_9564();
            }
            case 181: {
                return class_2246.field_10624.method_9564();
            }
            case 182: {
                return class_2246.field_10624.method_9564();
            }
            case 183: {
                return class_2246.field_10291.method_9564();
            }
            case 184: {
                return class_2246.field_10513.method_9564();
            }
            case 185: {
                return class_2246.field_10041.method_9564();
            }
            case 186: {
                return class_2246.field_10196.method_9564();
            }
            case 187: {
                return class_2246.field_10457.method_9564();
            }
            case 188: {
                return class_2246.field_10020.method_9564();
            }
            case 189: {
                return class_2246.field_10299.method_9564();
            }
            case 190: {
                return class_2246.field_10319.method_9564();
            }
            case 191: {
                return class_2246.field_10132.method_9564();
            }
            case 192: {
                return class_2246.field_10144.method_9564();
            }
            case 193: {
                return class_2246.field_10521.method_9564();
            }
            case 194: {
                return class_2246.field_10352.method_9564();
            }
            case 195: {
                return class_2246.field_10627.method_9564();
            }
            case 196: {
                return class_2246.field_10232.method_9564();
            }
            case 197: {
                return class_2246.field_10403.method_9564();
            }
            case 198: {
                return class_2246.field_10455.method_9564();
            }
            case 199: {
                return class_2246.field_10021.method_9564();
            }
            case 200: {
                return class_2246.field_10528.method_9564();
            }
            case 201: {
                return class_2246.field_10286.method_9564();
            }
            case 202: {
                return class_2246.field_10505.method_9564();
            }
            case 203: {
                return class_2246.field_9992.method_9564();
            }
            case 204: {
                return class_2246.field_10175.method_9564();
            }
            case 205: {
                return class_2246.field_10175.method_9564();
            }
            case 206: {
                return class_2246.field_10462.method_9564();
            }
            case 207: {
                return class_2246.field_10341.method_9564();
            }
            case 209: {
                return class_2246.field_10583.method_9564();
            }
            case 210: {
                return class_2246.field_10263.method_9564();
            }
            case 211: {
                return class_2246.field_10395.method_9564();
            }
            case 212: {
                return class_2246.field_10110.method_9564();
            }
            case 213: {
                return class_2246.field_10092.method_9564();
            }
            case 214: {
                return class_2246.field_10541.method_9564();
            }
            case 215: {
                return class_2246.field_9986.method_9564();
            }
            case 216: {
                return class_2246.field_10166.method_9564();
            }
            case 217: {
                return class_2246.field_10369.method_9564();
            }
            case 218: {
                return class_2246.field_10282.method_9564();
            }
            case 219: {
                return class_2246.field_10199.method_9564();
            }
            case 220: {
                return class_2246.field_10407.method_9564();
            }
            case 255: {
                return class_2246.field_10465.method_9564();
            }
        }
        if (blockId != 0) {
            SchematicMarket.LOGGER.debug("Unknown legacy block ID: {} (data: {})", (Object)blockId, (Object)data);
        }
        return class_2246.field_10124.method_9564();
    }

    private static class_2680 applyStairProperties(class_2680 state, int data) {
        class_2350 facing = switch (data & 3) {
            case 0 -> class_2350.field_11034;
            case 1 -> class_2350.field_11039;
            case 2 -> class_2350.field_11035;
            case 3 -> class_2350.field_11043;
            default -> class_2350.field_11043;
        };
        state = (class_2680)state.method_11657((class_2769)class_2510.field_11571, (Comparable)facing);
        state = (data & 4) != 0 ? (class_2680)state.method_11657((class_2769)class_2510.field_11572, (Comparable)class_2760.field_12619) : (class_2680)state.method_11657((class_2769)class_2510.field_11572, (Comparable)class_2760.field_12617);
        return state;
    }

    private static class_2680 applyDoorProperties(class_2680 state, int data) {
        if ((data & 8) != 0) {
            state = (class_2680)state.method_11657((class_2769)class_2323.field_10946, (Comparable)class_2756.field_12609);
            state = (data & 1) != 0 ? (class_2680)state.method_11657((class_2769)class_2323.field_10941, (Comparable)class_2750.field_12586) : (class_2680)state.method_11657((class_2769)class_2323.field_10941, (Comparable)class_2750.field_12588);
            state = (class_2680)state.method_11657((class_2769)class_2323.field_10938, (Comparable)class_2350.field_11043);
            return state;
        }
        class_2350 facing = switch (data & 3) {
            case 0 -> class_2350.field_11034;
            case 1 -> class_2350.field_11035;
            case 2 -> class_2350.field_11039;
            case 3 -> class_2350.field_11043;
            default -> class_2350.field_11043;
        };
        state = (class_2680)state.method_11657((class_2769)class_2323.field_10938, (Comparable)facing);
        state = (class_2680)state.method_11657((class_2769)class_2323.field_10946, (Comparable)class_2756.field_12607);
        if ((data & 4) != 0) {
            state = (class_2680)state.method_11657((class_2769)class_2323.field_10945, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    private static class_2680 applySlabProperties(class_2680 state, int data) {
        state = (data & 8) != 0 ? (class_2680)state.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679) : (class_2680)state.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12681);
        return state;
    }

    private static class_2680 applyButtonProperties(class_2680 state, int data) {
        int facing = data & 7;
        switch (facing) {
            case 0: {
                state = (class_2680)state.method_11657((class_2769)class_2269.field_11007, (Comparable)class_2738.field_12475);
                state = (class_2680)state.method_11657((class_2769)class_2269.field_11177, (Comparable)class_2350.field_11043);
                break;
            }
            case 1: {
                state = (class_2680)state.method_11657((class_2769)class_2269.field_11007, (Comparable)class_2738.field_12471);
                state = (class_2680)state.method_11657((class_2769)class_2269.field_11177, (Comparable)class_2350.field_11034);
                break;
            }
            case 2: {
                state = (class_2680)state.method_11657((class_2769)class_2269.field_11007, (Comparable)class_2738.field_12471);
                state = (class_2680)state.method_11657((class_2769)class_2269.field_11177, (Comparable)class_2350.field_11039);
                break;
            }
            case 3: {
                state = (class_2680)state.method_11657((class_2769)class_2269.field_11007, (Comparable)class_2738.field_12471);
                state = (class_2680)state.method_11657((class_2769)class_2269.field_11177, (Comparable)class_2350.field_11035);
                break;
            }
            case 4: {
                state = (class_2680)state.method_11657((class_2769)class_2269.field_11007, (Comparable)class_2738.field_12471);
                state = (class_2680)state.method_11657((class_2769)class_2269.field_11177, (Comparable)class_2350.field_11043);
                break;
            }
            case 5: {
                state = (class_2680)state.method_11657((class_2769)class_2269.field_11007, (Comparable)class_2738.field_12473);
                state = (class_2680)state.method_11657((class_2769)class_2269.field_11177, (Comparable)class_2350.field_11043);
            }
        }
        return state;
    }

    private static class_2680 applyWallBannerProperties(class_2680 state, int data) {
        class_2350 facing = switch (data) {
            case 2 -> class_2350.field_11043;
            case 3 -> class_2350.field_11035;
            case 4 -> class_2350.field_11039;
            case 5 -> class_2350.field_11034;
            default -> class_2350.field_11043;
        };
        state = (class_2680)state.method_11657((class_2769)class_2546.field_11722, (Comparable)facing);
        return state;
    }

    private static class_2680 applyStandingBannerProperties(class_2680 state, int data) {
        int rotation = data & 0xF;
        state = (class_2680)state.method_11657((class_2769)class_2215.field_9924, (Comparable)Integer.valueOf(rotation));
        return state;
    }

    private static class_2680 applyBasicFacing(class_2680 state, int data) {
        class_2350 facing = switch (data & 7) {
            case 2 -> class_2350.field_11043;
            case 3 -> class_2350.field_11035;
            case 4 -> class_2350.field_11039;
            case 5 -> class_2350.field_11034;
            default -> class_2350.field_11043;
        };
        try {
            return (class_2680)state.method_11657((class_2769)class_2741.field_12525, (Comparable)facing);
        }
        catch (Exception e) {
            return state;
        }
    }

    private static class_2680 applyNetherPortalProperties(class_2680 state, int data) {
        state = (data & 3) == 1 ? (class_2680)state.method_11657((class_2769)class_2423.field_11310, (Comparable)class_2350.class_2351.field_11048) : (class_2680)state.method_11657((class_2769)class_2423.field_11310, (Comparable)class_2350.class_2351.field_11051);
        return state;
    }

    private static class_2680 applyWallTorchProperties(class_2680 state, int data) {
        class_2350 facing = switch (data & 7) {
            case 1 -> class_2350.field_11034;
            case 2 -> class_2350.field_11039;
            case 3 -> class_2350.field_11035;
            case 4 -> class_2350.field_11043;
            default -> class_2350.field_11043;
        };
        state = (class_2680)state.method_11657((class_2769)class_2555.field_11731, (Comparable)facing);
        return state;
    }

    private static class_2680 applyTrapdoorProperties(class_2680 state, int data) {
        boolean isOpen = (data & 4) != 0;
        boolean isTop = (data & 8) != 0;
        class_2350 baseFacing = switch (data & 3) {
            case 0 -> class_2350.field_11035;
            case 1 -> class_2350.field_11043;
            case 2 -> class_2350.field_11034;
            case 3 -> class_2350.field_11039;
            default -> class_2350.field_11043;
        };
        class_2350 facing = isOpen ? baseFacing.method_10153() : baseFacing;
        state = (class_2680)state.method_11657((class_2769)class_2533.field_11177, (Comparable)facing);
        state = (class_2680)state.method_11657((class_2769)class_2533.field_11631, (Comparable)Boolean.valueOf(isOpen));
        state = isTop ? (class_2680)state.method_11657((class_2769)class_2533.field_11625, (Comparable)class_2760.field_12619) : (class_2680)state.method_11657((class_2769)class_2533.field_11625, (Comparable)class_2760.field_12617);
        return state;
    }
}

