/*
 * Decompiled with CFR 0.152.
 */
package com.abfann.schematicmarket.construction.schematic;

import com.abfann.schematicmarket.SchematicMarket;
import com.abfann.schematicmarket.construction.schematic.SchematicData;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class SchematicReader {
    public static SchematicData read(Path schematicPath) throws IOException {
        String fileName = schematicPath.getFileName().toString().toLowerCase();
        if (fileName.endsWith(".schem")) {
            return SchematicReader.readSpongeSchematic(schematicPath);
        }
        if (fileName.endsWith(".schematic")) {
            return SchematicReader.readMCEditSchematic(schematicPath);
        }
        throw new IOException("Unsupported schematic format: " + fileName);
    }

    private static SchematicData readSpongeSchematic(Path path) throws IOException {
        try {
            class_2487 nbt;
            try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
                nbt = class_2507.method_10629((InputStream)stream);
            }
            short width = nbt.method_10568("Width");
            short height = nbt.method_10568("Height");
            short length = nbt.method_10568("Length");
            SchematicMarket.LOGGER.info("Reading .schem: {}x{}x{}", new Object[]{width, height, length});
            class_2487 palette = nbt.method_10562("Palette");
            HashMap<Integer, class_2680> paletteMap = new HashMap<Integer, class_2680>();
            for (String key : palette.method_10541()) {
                int id = palette.method_10550(key);
                class_2680 state = SchematicReader.parseBlockState(key);
                paletteMap.put(id, state);
            }
            byte[] blockData = nbt.method_10547("BlockData");
            HashMap<class_2680, Integer> blockCounts = new HashMap<class_2680, Integer>();
            for (int i = 0; i < blockData.length; ++i) {
                int paletteId = Byte.toUnsignedInt(blockData[i]);
                class_2680 state = paletteMap.getOrDefault(paletteId, class_2246.field_10124.method_9564());
                if (state.method_26215()) continue;
                blockCounts.put(state, blockCounts.getOrDefault(state, 0) + 1);
            }
            SchematicMarket.LOGGER.info("Loaded {} unique block types", (Object)blockCounts.size());
            SchematicMarket.LOGGER.info("=== BLOCK TYPES FOUND ===");
            int count = 0;
            for (Map.Entry entry : blockCounts.entrySet()) {
                SchematicMarket.LOGGER.info("  - {} x{}", entry.getKey(), entry.getValue());
                if (++count < 10) continue;
                break;
            }
            SchematicMarket.LOGGER.info("=========================");
            return new SchematicData(width, height, length, blockCounts, nbt);
        }
        catch (Exception e) {
            throw new IOException("Failed to read .schem file: " + e.getMessage(), e);
        }
    }

    private static SchematicData readMCEditSchematic(Path path) throws IOException {
        try {
            class_2487 nbt;
            try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
                nbt = class_2507.method_10629((InputStream)stream);
            }
            short width = nbt.method_10568("Width");
            short height = nbt.method_10568("Height");
            short length = nbt.method_10568("Length");
            SchematicMarket.LOGGER.info("Reading .schematic: {}x{}x{}", new Object[]{width, height, length});
            byte[] blocks = nbt.method_10547("Blocks");
            byte[] blockData = nbt.method_10547("Data");
            HashMap<class_2680, Integer> blockCounts = new HashMap<class_2680, Integer>();
            for (int i = 0; i < blocks.length; ++i) {
                int data;
                int blockId = Byte.toUnsignedInt(blocks[i]);
                class_2680 state = SchematicReader.legacyIdToBlockState(blockId, data = i < blockData.length ? Byte.toUnsignedInt(blockData[i]) : 0);
                if (state.method_26215()) continue;
                blockCounts.put(state, blockCounts.getOrDefault(state, 0) + 1);
            }
            SchematicMarket.LOGGER.info("Loaded {} unique block types", (Object)blockCounts.size());
            return new SchematicData(width, height, length, blockCounts, nbt);
        }
        catch (Exception e) {
            throw new IOException("Failed to read .schematic file: " + e.getMessage(), e);
        }
    }

    private static class_2680 parseBlockState(String blockStateString) {
        try {
            String[] parts = blockStateString.split("\\[");
            String blockId = parts[0];
            class_2960 id = class_2960.method_12829((String)blockId);
            if (id == null || !class_7923.field_41175.method_10250(id)) {
                return class_2246.field_10124.method_9564();
            }
            class_2248 block = (class_2248)class_7923.field_41175.method_10223(id);
            return block.method_9564();
        }
        catch (Exception e) {
            SchematicMarket.LOGGER.warn("Failed to parse block state: {}", (Object)blockStateString);
            return class_2246.field_10124.method_9564();
        }
    }

    private static class_2680 legacyIdToBlockState(int blockId, int data) {
        switch (blockId) {
            case 0: {
                return class_2246.field_10124.method_9564();
            }
            case 1: {
                return class_2246.field_10340.method_9564();
            }
            case 2: {
                return class_2246.field_10219.method_9564();
            }
            case 3: {
                return class_2246.field_10566.method_9564();
            }
            case 4: {
                return class_2246.field_10445.method_9564();
            }
            case 5: {
                return class_2246.field_10161.method_9564();
            }
        }
        SchematicMarket.LOGGER.debug("Unknown legacy block ID: {}, using air", (Object)blockId);
        return class_2246.field_10124.method_9564();
    }
}

