/*
 * Decompiled with CFR 0.152.
 */
package com.abfann.schematicmarket.debug;

import com.abfann.schematicmarket.SchematicMarket;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import net.minecraft.class_2487;
import net.minecraft.class_2507;

public class SchematicInspector {
    public static void inspect(Path schematicPath) {
        try {
            SchematicMarket.LOGGER.info("========================================");
            SchematicMarket.LOGGER.info("INSPECTING: {}", (Object)schematicPath.getFileName());
            SchematicMarket.LOGGER.info("========================================");
            class_2487 nbt = class_2507.method_30613((File)schematicPath.toFile());
            SchematicMarket.LOGGER.info("Root NBT keys: {}", (Object)nbt.method_10541());
            if (nbt.method_10545("Palette")) {
                SchematicMarket.LOGGER.info("Format: Sponge (.schem)");
                SchematicInspector.inspectSponge(nbt);
            } else if (nbt.method_10545("Blocks")) {
                SchematicMarket.LOGGER.info("Format: MCEdit (.schematic)");
                SchematicInspector.inspectMCEdit(nbt);
            } else {
                SchematicMarket.LOGGER.warn("Unknown format!");
            }
            SchematicMarket.LOGGER.info("========================================");
        }
        catch (IOException e) {
            SchematicMarket.LOGGER.error("Failed to inspect schematic", (Throwable)e);
        }
    }

    private static void inspectSponge(class_2487 nbt) {
        SchematicMarket.LOGGER.info("Width: {}", (Object)nbt.method_10568("Width"));
        SchematicMarket.LOGGER.info("Height: {}", (Object)nbt.method_10568("Height"));
        SchematicMarket.LOGGER.info("Length: {}", (Object)nbt.method_10568("Length"));
        if (nbt.method_10545("Palette")) {
            class_2487 palette = nbt.method_10562("Palette");
            SchematicMarket.LOGGER.info("Palette entries: {}", (Object)palette.method_10541().size());
            for (String key : palette.method_10541()) {
                SchematicMarket.LOGGER.info("  - {} = {}", (Object)key, (Object)palette.method_10550(key));
            }
        }
        if (nbt.method_10545("BlockData")) {
            byte[] blockData = nbt.method_10547("BlockData");
            SchematicMarket.LOGGER.info("BlockData length: {}", (Object)blockData.length);
        }
    }

    private static void inspectMCEdit(class_2487 nbt) {
        SchematicMarket.LOGGER.info("Width: {}", (Object)nbt.method_10568("Width"));
        SchematicMarket.LOGGER.info("Height: {}", (Object)nbt.method_10568("Height"));
        SchematicMarket.LOGGER.info("Length: {}", (Object)nbt.method_10568("Length"));
        if (nbt.method_10545("Blocks")) {
            byte[] blocks = nbt.method_10547("Blocks");
            SchematicMarket.LOGGER.info("Blocks array length: {}", (Object)blocks.length);
            HashSet<Integer> uniqueIds = new HashSet<Integer>();
            for (byte b : blocks) {
                uniqueIds.add(Byte.toUnsignedInt(b));
            }
            SchematicMarket.LOGGER.info("Unique block IDs: {}", (Object)uniqueIds.size());
            SchematicMarket.LOGGER.info("Block IDs found: {}", uniqueIds);
        }
        if (nbt.method_10545("Data")) {
            byte[] data = nbt.method_10547("Data");
            SchematicMarket.LOGGER.info("Data array length: {}", (Object)data.length);
        }
    }
}

