/*
 * Decompiled with CFR 0.152.
 */
package com.abfann.schematicmarket.economy;

import com.abfann.schematicmarket.SchematicMarket;
import com.abfann.schematicmarket.economy.config.EconomyConfig;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class CurrencyHelper {
    public static class_1792 getCurrencyItem() {
        EconomyConfig config = EconomyConfig.getInstance();
        if (config == null) {
            return class_1802.field_8687;
        }
        class_2960 itemId = class_2960.method_12829((String)config.currencyItem);
        if (itemId != null && class_7923.field_41178.method_10250(itemId)) {
            return (class_1792)class_7923.field_41178.method_10223(itemId);
        }
        SchematicMarket.LOGGER.warn("Invalid currency item '{}', using emerald", (Object)config.currencyItem);
        return class_1802.field_8687;
    }

    public static String getCurrencyName() {
        return CurrencyHelper.getCurrencyItem().method_7848().getString();
    }

    public static String getCurrencyNamePlural() {
        String name = CurrencyHelper.getCurrencyName();
        if (name.endsWith("s") || name.endsWith("x") || name.endsWith("z")) {
            return name + "es";
        }
        return name + "s";
    }

    public static int countCurrencyInInventory(class_1661 inventory) {
        class_1792 currencyItem = CurrencyHelper.getCurrencyItem();
        int count = 0;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7909() != currencyItem) continue;
            count += stack.method_7947();
        }
        return count;
    }

    public static boolean removeCurrencyFromInventory(class_1661 inventory, int amount) {
        class_1792 currencyItem = CurrencyHelper.getCurrencyItem();
        int remaining = amount;
        if (CurrencyHelper.countCurrencyInInventory(inventory) < amount) {
            return false;
        }
        for (int i = 0; i < inventory.method_5439() && remaining > 0; ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7909() != currencyItem) continue;
            int toRemove = Math.min(remaining, stack.method_7947());
            stack.method_7934(toRemove);
            remaining -= toRemove;
        }
        return remaining == 0;
    }

    public static boolean addCurrencyToInventory(class_1661 inventory, int amount) {
        class_1792 currencyItem = CurrencyHelper.getCurrencyItem();
        int remaining = amount;
        for (int i = 0; i < inventory.method_5439() && remaining > 0; ++i) {
            int currentCount;
            int maxCount;
            int canAdd;
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7909() != currencyItem || (canAdd = (maxCount = stack.method_7914()) - (currentCount = stack.method_7947())) <= 0) continue;
            int toAdd = Math.min(remaining, canAdd);
            stack.method_7933(toAdd);
            remaining -= toAdd;
        }
        while (remaining > 0) {
            int slotIndex = inventory.method_7376();
            if (slotIndex == -1) {
                return false;
            }
            int stackSize = Math.min(remaining, currencyItem.method_7882());
            class_1799 newStack = new class_1799((class_1935)currencyItem, stackSize);
            inventory.method_5447(slotIndex, newStack);
            remaining -= stackSize;
        }
        return true;
    }

    public static int unitsToItems(long units) {
        EconomyConfig config = EconomyConfig.getInstance();
        if (config == null) {
            return (int)units;
        }
        return (int)(units * (long)config.itemsPerUnit);
    }

    public static long itemsToUnits(int items) {
        EconomyConfig config = EconomyConfig.getInstance();
        if (config == null) {
            return items;
        }
        return items / config.itemsPerUnit;
    }
}

