/*
 * Decompiled with CFR 0.152.
 */
package com.abfann.schematicmarket.economy;

import com.abfann.schematicmarket.SchematicMarket;
import com.abfann.schematicmarket.economy.config.EconomyConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.server.MinecraftServer;

public class EconomyManager {
    private static EconomyManager INSTANCE;
    private final Map<UUID, Long> playerBalances = new HashMap<UUID, Long>();
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private Path dataFile;
    private long maxBalance = 999999999L;
    private long startingBalance = 0L;
    private static long clientBalance;

    private EconomyManager() {
    }

    public static EconomyManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EconomyManager();
        }
        return INSTANCE;
    }

    public void initialize(MinecraftServer server) {
        EconomyConfig config = EconomyConfig.load();
        this.maxBalance = config.maxBalance;
        this.startingBalance = config.startingBalance;
        Path dataDir = server.method_3831().toPath().resolve("schematicmarket").resolve("data");
        try {
            Files.createDirectories(dataDir, new FileAttribute[0]);
            this.dataFile = dataDir.resolve("economy.json");
            this.loadData();
            SchematicMarket.LOGGER.info("Economy system initialized");
            SchematicMarket.LOGGER.info("Currency: {}", (Object)config.getCurrencyName());
            SchematicMarket.LOGGER.info("Max Balance: {}", (Object)this.maxBalance);
            SchematicMarket.LOGGER.info("Starting Balance: {}", (Object)this.startingBalance);
        }
        catch (IOException e) {
            SchematicMarket.LOGGER.error("Failed to initialize economy system", (Throwable)e);
        }
        ServerLifecycleEvents.SERVER_STOPPING.register(this::saveData);
    }

    public long getBalance(UUID playerUuid) {
        return this.playerBalances.getOrDefault(playerUuid, this.startingBalance);
    }

    public void setBalance(UUID playerUuid, long amount) {
        if (amount < 0L) {
            amount = 0L;
        }
        if (amount > this.maxBalance) {
            amount = this.maxBalance;
        }
        this.playerBalances.put(playerUuid, amount);
        this.saveData(null);
    }

    public boolean addBalance(UUID playerUuid, long amount) {
        if (amount <= 0L) {
            return false;
        }
        long currentBalance = this.getBalance(playerUuid);
        long newBalance = currentBalance + amount;
        if (newBalance > this.maxBalance) {
            newBalance = this.maxBalance;
        }
        this.playerBalances.put(playerUuid, newBalance);
        this.saveData(null);
        return true;
    }

    public boolean removeBalance(UUID playerUuid, long amount) {
        if (amount <= 0L) {
            return false;
        }
        long currentBalance = this.getBalance(playerUuid);
        if (currentBalance < amount) {
            return false;
        }
        long newBalance = currentBalance - amount;
        this.playerBalances.put(playerUuid, newBalance);
        this.saveData(null);
        return true;
    }

    public boolean transferBalance(UUID fromPlayer, UUID toPlayer, long amount) {
        if (amount <= 0L) {
            return false;
        }
        long fromBalance = this.getBalance(fromPlayer);
        if (fromBalance < amount) {
            return false;
        }
        this.removeBalance(fromPlayer, amount);
        this.addBalance(toPlayer, amount);
        return true;
    }

    public boolean hasBalance(UUID playerUuid, long amount) {
        return this.getBalance(playerUuid) >= amount;
    }

    private void loadData() {
        if (this.dataFile == null || !Files.exists(this.dataFile, new LinkOption[0])) {
            SchematicMarket.LOGGER.info("No economy data found, starting fresh");
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(this.dataFile);){
            Type type = new TypeToken<Map<UUID, Long>>(){}.getType();
            Map loadedData = (Map)this.gson.fromJson((Reader)reader, type);
            if (loadedData != null) {
                this.playerBalances.clear();
                this.playerBalances.putAll(loadedData);
                SchematicMarket.LOGGER.info("Loaded economy data for {} players", (Object)this.playerBalances.size());
            }
        }
        catch (IOException e) {
            SchematicMarket.LOGGER.error("Failed to load economy data", (Throwable)e);
        }
    }

    private void saveData(MinecraftServer server) {
        if (this.dataFile == null) {
            return;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(this.dataFile, new OpenOption[0]);){
            this.gson.toJson(this.playerBalances, (Appendable)writer);
        }
        catch (IOException e) {
            SchematicMarket.LOGGER.error("Failed to save economy data", (Throwable)e);
        }
    }

    public long getMaxBalance() {
        return this.maxBalance;
    }

    public void setMaxBalance(long maxBalance) {
        this.maxBalance = maxBalance;
    }

    public long getStartingBalance() {
        return this.startingBalance;
    }

    public void setStartingBalance(long startingBalance) {
        this.startingBalance = startingBalance;
    }

    public static void setClientBalance(long balance) {
        clientBalance = balance;
    }

    public static long getClientBalance() {
        return clientBalance;
    }

    static {
        clientBalance = 0L;
    }
}

