/*
 * Decompiled with CFR 0.152.
 */
package com.abfann.schematicmarket.economy.command;

import com.abfann.schematicmarket.economy.CurrencyHelper;
import com.abfann.schematicmarket.economy.EconomyManager;
import com.abfann.schematicmarket.network.SyncBalanceS2CPacket;
import com.abfann.schematicmarket.util.TranslationManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class DepositCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"deposit").then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(DepositCommand::executeDeposit)));
    }

    private static int executeDeposit(CommandContext<class_2168> context) {
        long maxBalance;
        class_2168 source = (class_2168)context.getSource();
        class_1297 class_12972 = source.method_9228();
        if (!(class_12972 instanceof class_3222)) {
            source.method_9213((class_2561)class_2561.method_43470((String)TranslationManager.translate("commands.schematicmarket.balance.player_only", new Object[0])));
            return 0;
        }
        class_3222 player = (class_3222)class_12972;
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        if (amount <= 0) {
            player.method_7353((class_2561)class_2561.method_43470((String)TranslationManager.translate("commands.schematicmarket.deposit.invalid_amount", new Object[0])), false);
            return 0;
        }
        int itemsInInventory = CurrencyHelper.countCurrencyInInventory(player.method_31548());
        if (itemsInInventory < amount) {
            String currencyName = CurrencyHelper.getCurrencyNamePlural();
            player.method_7353((class_2561)class_2561.method_43470((String)TranslationManager.translate("commands.schematicmarket.deposit.no_items", currencyName)), false);
            return 0;
        }
        long unitsToDeposit = CurrencyHelper.itemsToUnits(amount);
        EconomyManager economy = EconomyManager.getInstance();
        long currentBalance = economy.getBalance(player.method_5667());
        if (currentBalance + unitsToDeposit > (maxBalance = economy.getMaxBalance())) {
            player.method_7353((class_2561)class_2561.method_43470((String)TranslationManager.translate("commands.schematicmarket.deposit.max_reached", maxBalance)), false);
            return 0;
        }
        if (!CurrencyHelper.removeCurrencyFromInventory(player.method_31548(), amount)) {
            player.method_7353((class_2561)class_2561.method_43470((String)TranslationManager.translate("commands.schematicmarket.deposit.no_items", CurrencyHelper.getCurrencyNamePlural())), false);
            return 0;
        }
        economy.addBalance(player.method_5667(), unitsToDeposit);
        SyncBalanceS2CPacket.send(player, economy.getBalance(player.method_5667()));
        long newBalance = economy.getBalance(player.method_5667());
        String currencyName = CurrencyHelper.getCurrencyNamePlural();
        player.method_7353((class_2561)class_2561.method_43470((String)TranslationManager.translate("commands.schematicmarket.deposit.success", unitsToDeposit, currencyName, newBalance)), false);
        return 1;
    }
}

