/*
 * Decompiled with CFR 0.152.
 */
package com.abfann.schematicmarket.economy.command;

import com.abfann.schematicmarket.economy.CurrencyHelper;
import com.abfann.schematicmarket.economy.EconomyManager;
import com.abfann.schematicmarket.network.SyncBalanceS2CPacket;
import com.abfann.schematicmarket.util.TranslationManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class PayCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"pay").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"amount", (ArgumentType)LongArgumentType.longArg((long)1L)).executes(PayCommand::executePay))));
    }

    private static int executePay(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_1297 class_12972 = source.method_9228();
        if (!(class_12972 instanceof class_3222)) {
            source.method_9213((class_2561)class_2561.method_43470((String)TranslationManager.translate("commands.schematicmarket.balance.player_only", new Object[0])));
            return 0;
        }
        class_3222 sender = (class_3222)class_12972;
        class_3222 receiver = class_2186.method_9315(context, (String)"player");
        long amount = LongArgumentType.getLong(context, (String)"amount");
        if (amount <= 0L) {
            sender.method_7353((class_2561)class_2561.method_43470((String)TranslationManager.translate("commands.schematicmarket.pay.invalid_amount", new Object[0])), false);
            return 0;
        }
        if (sender.method_5667().equals(receiver.method_5667())) {
            sender.method_7353((class_2561)class_2561.method_43470((String)TranslationManager.translate("commands.schematicmarket.pay.self_payment", new Object[0])), false);
            return 0;
        }
        EconomyManager economy = EconomyManager.getInstance();
        long senderBalance = economy.getBalance(sender.method_5667());
        if (senderBalance < amount) {
            sender.method_7353((class_2561)class_2561.method_43470((String)TranslationManager.translate("commands.schematicmarket.pay.insufficient_balance", senderBalance)), false);
            return 0;
        }
        if (economy.transferBalance(sender.method_5667(), receiver.method_5667(), amount)) {
            SyncBalanceS2CPacket.send(sender, economy.getBalance(sender.method_5667()));
            SyncBalanceS2CPacket.send(receiver, economy.getBalance(receiver.method_5667()));
            String currencyName = CurrencyHelper.getCurrencyNamePlural();
            sender.method_7353((class_2561)class_2561.method_43470((String)TranslationManager.translate("commands.schematicmarket.pay.success", amount, currencyName, receiver.method_5477().getString())), false);
            receiver.method_7353((class_2561)class_2561.method_43470((String)TranslationManager.translate("commands.schematicmarket.pay.received", amount, currencyName, sender.method_5477().getString())), false);
            return 1;
        }
        return 0;
    }
}

