/*
 * Decompiled with CFR 0.152.
 */
package com.abfann.schematicmarket.economy.config;

import com.abfann.schematicmarket.SchematicMarket;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class EconomyConfig {
    public long maxBalance = 999999999L;
    public long startingBalance = 0L;
    public String currencyItem = "minecraft:emerald";
    public boolean enableDailyReward = false;
    public long dailyRewardAmount = 10L;
    public DailyRewardType dailyRewardType = DailyRewardType.REAL_TIME;
    public int itemsPerUnit = 1;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static EconomyConfig INSTANCE;
    private static Path configFile;

    public static EconomyConfig load() {
        block9: {
            try {
                Path configDir = FabricLoader.getInstance().getConfigDir().resolve("schematicmarket");
                Files.createDirectories(configDir, new FileAttribute[0]);
                configFile = configDir.resolve("economy_config.json");
                if (Files.exists(configFile, new LinkOption[0])) {
                    try (BufferedReader reader = Files.newBufferedReader(configFile);){
                        INSTANCE = (EconomyConfig)GSON.fromJson((Reader)reader, EconomyConfig.class);
                        SchematicMarket.LOGGER.info("Economy config loaded from: {}", (Object)configFile);
                        break block9;
                    }
                }
                INSTANCE = new EconomyConfig();
                EconomyConfig.save();
                SchematicMarket.LOGGER.info("Created default economy config at: {}", (Object)configFile);
            }
            catch (IOException e) {
                SchematicMarket.LOGGER.error("Failed to load economy config", (Throwable)e);
                INSTANCE = new EconomyConfig();
            }
        }
        INSTANCE.validate();
        return INSTANCE;
    }

    public static void save() {
        if (configFile == null || INSTANCE == null) {
            return;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(configFile, new OpenOption[0]);){
            GSON.toJson((Object)INSTANCE, (Appendable)writer);
            SchematicMarket.LOGGER.info("Economy config saved");
        }
        catch (IOException e) {
            SchematicMarket.LOGGER.error("Failed to save economy config", (Throwable)e);
        }
    }

    public static EconomyConfig getInstance() {
        return INSTANCE;
    }

    private void validate() {
        class_2960 itemId;
        if (this.maxBalance < 0L) {
            this.maxBalance = 999999999L;
        }
        if (this.startingBalance < 0L) {
            this.startingBalance = 0L;
        }
        if (this.startingBalance > this.maxBalance) {
            this.startingBalance = this.maxBalance;
        }
        if ((itemId = class_2960.method_12829((String)this.currencyItem)) == null || !class_7923.field_41178.method_10250(itemId)) {
            SchematicMarket.LOGGER.warn("Invalid currency item '{}', using emerald", (Object)this.currencyItem);
            this.currencyItem = "minecraft:emerald";
        }
        if (this.dailyRewardAmount < 0L) {
            this.dailyRewardAmount = 0L;
        }
        if (this.dailyRewardType == null) {
            this.dailyRewardType = DailyRewardType.REAL_TIME;
        }
        if (this.itemsPerUnit < 1) {
            this.itemsPerUnit = 1;
        }
    }

    public String getCurrencyName() {
        class_2960 itemId = class_2960.method_12829((String)this.currencyItem);
        if (itemId != null && class_7923.field_41178.method_10250(itemId)) {
            return ((class_1792)class_7923.field_41178.method_10223(itemId)).method_7848().getString();
        }
        return "Emerald";
    }

    public static enum DailyRewardType {
        REAL_TIME,
        MINECRAFT_TIME;

    }
}

