/*
 * Decompiled with CFR 0.152.
 */
package com.abfann.schematicmarket.network;

import com.abfann.schematicmarket.construction.Construction;
import com.abfann.schematicmarket.construction.ConstructionLoader;
import com.abfann.schematicmarket.economy.EconomyManager;
import com.abfann.schematicmarket.network.SyncBalanceS2CPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public class PurchaseConstructionC2SPacket {
    public static final class_2960 ID = new class_2960("schematicmarket", "purchase_construction");

    public static void register() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ID, PurchaseConstructionC2SPacket::receive);
    }

    private static void receive(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        String constructionId = buf.method_19772();
        int rotation = buf.readInt();
        server.execute(() -> PurchaseConstructionC2SPacket.processPurchase(player, constructionId, rotation));
    }

    private static void processPurchase(class_3222 player, String constructionId, int rotation) {
        long price;
        Construction construction = ConstructionLoader.getConstruction(constructionId);
        if (construction == null) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c\u2717 Construction not found"), false);
            return;
        }
        EconomyManager economy = EconomyManager.getInstance();
        long playerBalance = economy.getBalance(player.method_5667());
        if (playerBalance < (price = construction.getFinalPrice())) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c\u2717 Insufficient funds"), false);
            return;
        }
        economy.removeBalance(player.method_5667(), price);
        SyncBalanceS2CPacket.send(player, economy.getBalance(player.method_5667()));
        class_1799 constructionItem = PurchaseConstructionC2SPacket.createConstructionItem(construction, rotation);
        if (!player.method_31548().method_7394(constructionItem)) {
            player.method_7328(constructionItem, false);
        }
        player.method_7353((class_2561)class_2561.method_43470((String)String.format("\u00a7a\u2713 Purchased %s for %d", construction.getName(), price)), false);
    }

    private static class_1799 createConstructionItem(Construction construction, int rotation) {
        class_1799 item = new class_1799((class_1935)class_1802.field_8407);
        class_2487 nbt = item.method_7948();
        nbt.method_10582("ConstructionId", construction.getId());
        nbt.method_10569("Rotation", rotation);
        nbt.method_10556("IsConstruction", true);
        item.method_7977((class_2561)class_2561.method_43470((String)("\u00a76" + construction.getName() + " \u00a77[" + rotation * 90 + "\u00b0]")));
        return item;
    }
}

