/*
 * Decompiled with CFR 0.152.
 */
package com.abfann.schematicmarket.util;

import com.abfann.schematicmarket.SchematicMarket;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class TranslationManager {
    private static final Map<String, String> translations = new HashMap<String, String>();
    private static boolean initialized = false;

    public static void initialize() {
        if (initialized) {
            return;
        }
        try {
            InputStream stream = TranslationManager.class.getResourceAsStream("/assets/schematicmarket/lang/en_us.json");
            if (stream != null) {
                JsonObject json = (JsonObject)new Gson().fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), JsonObject.class);
                for (String key : json.keySet()) {
                    translations.put(key, json.get(key).getAsString());
                }
                SchematicMarket.LOGGER.info("Loaded {} translations", (Object)translations.size());
                initialized = true;
            } else {
                SchematicMarket.LOGGER.warn("Could not find language file");
            }
        }
        catch (Exception e) {
            SchematicMarket.LOGGER.error("Failed to load translations", (Throwable)e);
        }
    }

    public static String translate(String key, Object ... args) {
        String translation = translations.getOrDefault(key, key);
        if (args.length > 0) {
            translation = String.format(translation, args);
        }
        return translation;
    }

    public static boolean hasTranslation(String key) {
        return translations.containsKey(key);
    }
}

