/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.sherdduplication.common.impl.addons.jei;

import java.util.LinkedList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.registration.IRecipeRegistration;
import net.darkhax.sherdduplication.common.impl.SherdDuplication;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation PLUGIN_ID = SherdDuplication.id("jei_plugin");

    @NotNull
    public ResourceLocation getPluginUid() {
        return PLUGIN_ID;
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(RecipeTypes.CRAFTING, JEIPlugin.createRecipes(registration.getJeiHelpers()));
    }

    private static List<RecipeHolder<CraftingRecipe>> createRecipes(IJeiHelpers helpers) {
        LinkedList<RecipeHolder<CraftingRecipe>> recipes = new LinkedList<RecipeHolder<CraftingRecipe>>();
        String group = "sherdduplication.jei.sherds";
        for (Holder item : BuiltInRegistries.ITEM.getTagOrEmpty(ItemTags.DECORATED_POT_SHERDS)) {
            if (item.is(SherdDuplication.CANT_DUPLICATE)) continue;
            ResourceLocation itemId = ((ResourceKey)item.unwrapKey().orElseThrow()).location();
            ResourceLocation recipeId = SherdDuplication.id("jei." + itemId.getNamespace() + "." + itemId.getPath());
            ItemStack sherdInput = ((Item)item.value()).getDefaultInstance();
            ItemStack output = sherdInput.copyWithCount(4);
            recipes.add((RecipeHolder<CraftingRecipe>)new RecipeHolder(recipeId, (Recipe)helpers.getVanillaRecipeFactory().createShapedRecipeBuilder(CraftingBookCategory.MISC, List.of(output)).group("sherdduplication.jei.sherds").define(Character.valueOf('a'), Ingredient.of(SherdDuplication.OUTER_INGREDIENT)).define(Character.valueOf('b'), Ingredient.of(SherdDuplication.INNER_INGREDIENT)).define(Character.valueOf('c'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)item.value()})).pattern("aca").pattern("aba").pattern("aaa").build()));
        }
        return recipes;
    }
}

