/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.sherdduplication.common.impl.crafting;

import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.sherdduplication.common.impl.SherdDuplication;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class SherdCopyRecipe
extends CustomRecipe {
    private static final CachedSupplier<RecipeSerializer<?>> RECIPE_SERIALIZER = CachedSupplier.of((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (ResourceLocation)SherdDuplication.id("copy_sherd"));

    public SherdCopyRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput input, @NotNull Level level) {
        if (!this.canCraftInDimensions(input.width(), input.height())) {
            return false;
        }
        for (int slotId = 0; slotId < input.size(); ++slotId) {
            ItemStack currentStack = input.getItem(slotId);
            if (slotId == 1 && !currentStack.is(ItemTags.DECORATED_POT_SHERDS) || currentStack.is(SherdDuplication.CANT_DUPLICATE)) {
                return false;
            }
            if (slotId == 4 && !currentStack.is(SherdDuplication.INNER_INGREDIENT)) {
                return false;
            }
            if (slotId == 1 || slotId == 4 || currentStack.is(SherdDuplication.OUTER_INGREDIENT)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput input, @NotNull HolderLookup.Provider provider) {
        ItemStack sherdStack = input.getItem(1);
        return sherdStack.is(ItemTags.DECORATED_POT_SHERDS) && !sherdStack.is(SherdDuplication.CANT_DUPLICATE) ? sherdStack.copyWithCount(4) : new ItemStack((ItemLike)Items.BRICK, 4);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width == 3 && height == 3;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RECIPE_SERIALIZER.get();
    }
}

