/*
 * Decompiled with CFR 0.152.
 */
package dev.custom.portals.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.custom.portals.config.CPSettings;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3620;

public class CustomPortal {
    public float offsetX;
    public float offsetZ;
    private final String frameId;
    private final String dimensionId;
    private final class_3620 color;
    private class_2338 spawnPos;
    private List<class_2338> portalBlocks;
    private int hasteRunes;
    private int gateRunes;
    private int weakEnhancerRunes;
    private int strongEnhancerRunes;
    private int infinityRunes;
    private final UUID creatorId;
    private boolean hasRedstoneSignal = false;
    private CustomPortal linked;
    public static final Codec<CustomPortal> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("frameId").forGetter(CustomPortal::getFrameId), (App)Codec.STRING.fieldOf("dimensionId").forGetter(CustomPortal::getDimensionId), (App)Codec.INT.fieldOf("color").forGetter(CustomPortal::getColorId), (App)class_2338.field_25064.fieldOf("spawnPos").forGetter(CustomPortal::getSpawnPos), (App)class_2338.field_25064.listOf().fieldOf("portalBlocks").forGetter(CustomPortal::getPortalBlocks), (App)Codec.FLOAT.fieldOf("offsetX").forGetter(CustomPortal::getOffsetX), (App)Codec.FLOAT.fieldOf("offsetZ").forGetter(CustomPortal::getOffsetZ), (App)Codec.STRING.fieldOf("creatorId").forGetter(CustomPortal::getCreatorIdAsString), (App)Codec.INT.fieldOf("hasteRunes").forGetter(CustomPortal::getHasteRunes), (App)Codec.INT.fieldOf("gateRunes").forGetter(CustomPortal::getGateRunes), (App)Codec.INT.fieldOf("weakEnhancerRunes").forGetter(CustomPortal::getWeakEnhancerRunes), (App)Codec.INT.fieldOf("strongEnhancerRunes").forGetter(CustomPortal::getStrongEnhancerRunes), (App)Codec.INT.fieldOf("infinityRunes").forGetter(CustomPortal::getInfinityRunes)).apply((Applicative)instance, CustomPortal::new));

    public CustomPortal(String frameId, String dimensionId, class_3620 color, class_2338 spawnPos, List<class_2338> portalBlocks, float offsetX, float offsetZ, UUID creatorId) {
        this.frameId = frameId;
        this.dimensionId = dimensionId;
        this.color = color;
        this.spawnPos = spawnPos;
        this.portalBlocks = portalBlocks;
        this.offsetX = offsetX;
        this.offsetZ = offsetZ;
        this.creatorId = creatorId;
        this.hasteRunes = 0;
        this.gateRunes = 0;
        this.weakEnhancerRunes = 0;
        this.strongEnhancerRunes = 0;
        this.infinityRunes = 0;
    }

    public float getOffsetX() {
        return this.offsetX;
    }

    public float getOffsetZ() {
        return this.offsetZ;
    }

    public CustomPortal(String frameId, String dimensionId, class_3620 color, class_2338 spawnPos, List<class_2338> portalBlocks, float offsetX, float offsetZ, UUID creatorId, int hasteRunes, int gateRunes, int weakEnhancerRunes, int strongEnhancerRunes, int infinityRunes) {
        this.frameId = frameId;
        this.dimensionId = dimensionId;
        this.color = color;
        this.spawnPos = spawnPos;
        this.portalBlocks = portalBlocks;
        this.offsetX = offsetX;
        this.offsetZ = offsetZ;
        this.creatorId = creatorId;
        this.hasteRunes = hasteRunes;
        this.gateRunes = gateRunes;
        this.weakEnhancerRunes = weakEnhancerRunes;
        this.strongEnhancerRunes = strongEnhancerRunes;
        this.infinityRunes = infinityRunes;
    }

    public CustomPortal(String frameId, String dimensionId, int colorId, class_2338 spawnPos, List<class_2338> portalBlocks, float offsetX, float offsetZ, String creatorId, int hasteRunes, int gateRunes, int weakEnhancerRunes, int strongEnhancerRunes, int infinityRunes) {
        this.frameId = frameId;
        this.dimensionId = dimensionId;
        this.color = class_3620.method_38479((int)colorId);
        this.spawnPos = spawnPos;
        this.portalBlocks = portalBlocks;
        this.offsetX = offsetX;
        this.offsetZ = offsetZ;
        this.creatorId = UUID.fromString(creatorId);
        this.hasteRunes = hasteRunes;
        this.gateRunes = gateRunes;
        this.weakEnhancerRunes = weakEnhancerRunes;
        this.strongEnhancerRunes = strongEnhancerRunes;
        this.infinityRunes = infinityRunes;
    }

    public String getFrameId() {
        return this.frameId;
    }

    public String getDimensionId() {
        return this.dimensionId;
    }

    public class_3620 getColor() {
        return this.color;
    }

    public int getColorId() {
        return this.color.field_16021;
    }

    public CustomPortal getLinked() {
        return this.linked;
    }

    public class_2338 getSpawnPos() {
        return this.spawnPos;
    }

    public List<class_2338> getPortalBlocks() {
        return this.portalBlocks;
    }

    public UUID getCreatorId() {
        return this.creatorId;
    }

    public String getCreatorIdAsString() {
        return this.creatorId.toString();
    }

    public boolean hasLinked() {
        return this.linked != null;
    }

    public boolean isInterdimensional() {
        return this.hasLinked() && !this.dimensionId.equals(this.linked.getDimensionId());
    }

    public boolean hasRedstoneSignal() {
        return this.hasRedstoneSignal;
    }

    public void setHasRedstoneSignal(boolean hasRedstoneSignal) {
        this.hasRedstoneSignal = hasRedstoneSignal;
    }

    public void setLinked(CustomPortal portal) {
        this.linked = portal;
    }

    public int getPlayerTeleportDelay() {
        if (CPSettings.instance().alwaysHaste == CPSettings.HasteEnum.YES) {
            return 1;
        }
        return this.hasHaste() ? 1 : 80;
    }

    public void setSpawnPos(class_2338 newSpawn) {
        this.spawnPos = newSpawn;
        this.offsetX = 0.5f;
        this.offsetZ = 0.5f;
    }

    public int getHasteRunes() {
        return this.hasteRunes;
    }

    public int getGateRunes() {
        return this.gateRunes;
    }

    public int getWeakEnhancerRunes() {
        return this.weakEnhancerRunes;
    }

    public int getStrongEnhancerRunes() {
        return this.strongEnhancerRunes;
    }

    public int getInfinityRunes() {
        return this.infinityRunes;
    }

    public void addHaste() {
        ++this.hasteRunes;
    }

    public void addGate() {
        ++this.gateRunes;
    }

    public void addWeakEnhancer() {
        ++this.weakEnhancerRunes;
    }

    public void addStrongEnhancer() {
        ++this.strongEnhancerRunes;
    }

    public void addInfinity() {
        ++this.infinityRunes;
    }

    public void removeHaste() {
        --this.hasteRunes;
    }

    public void removeGate() {
        --this.gateRunes;
    }

    public void removeWeakEnhancer() {
        --this.weakEnhancerRunes;
    }

    public void removeStrongEnhancer() {
        --this.strongEnhancerRunes;
    }

    public void removeInfinity() {
        --this.infinityRunes;
    }

    public boolean hasHaste() {
        int i = this.hasLinked() ? this.linked.getHasteRunes() : 0;
        return this.hasteRunes + i > 0;
    }

    public boolean hasGate() {
        int i = this.hasLinked() ? this.linked.getGateRunes() : 0;
        return this.gateRunes + i > 0;
    }

    public int getEnhanceTier() {
        int k;
        int i = this.hasLinked() ? this.linked.getInfinityRunes() : 0;
        int j = this.hasLinked() ? this.linked.getStrongEnhancerRunes() : 0;
        int n = k = this.hasLinked() ? this.linked.getWeakEnhancerRunes() : 0;
        if (this.infinityRunes + i > 0) {
            return 3;
        }
        if (this.strongEnhancerRunes + j > 0) {
            return 2;
        }
        if (this.weakEnhancerRunes + k > 0) {
            return 1;
        }
        return 0;
    }

    public void tryLink(CustomPortal portal) {
        if (CPSettings.instance().privatePortals && this.creatorId != null && portal.creatorId != null && !this.creatorId.equals(portal.getCreatorId())) {
            return;
        }
        if (portal.getColor() == this.color && portal.getFrameId().equals(this.frameId) && portal != this) {
            if (portal.hasLinked() && portal.getLinked() != this) {
                return;
            }
            if (!CPSettings.instance().unlimitedRange || !CPSettings.instance().alwaysInterdim) {
                int distance;
                if (!portal.getDimensionId().equals(this.dimensionId)) {
                    if (!(this.hasGate() || portal.hasGate() || CPSettings.instance().alwaysInterdim)) {
                        return;
                    }
                    if (portal.getDimensionId().equals("minecraft:the_nether")) {
                        translatedX = portal.getSpawnPos().method_10263() * 8;
                        int translatedZ = portal.getSpawnPos().method_10260() * 8;
                        class_2338 translatedSpawnPos = new class_2338(new class_2382(translatedX, portal.getSpawnPos().method_10264(), translatedZ));
                        distance = this.distance(this.spawnPos, translatedSpawnPos);
                    } else if (this.dimensionId.equals("minecraft:the_nether")) {
                        translatedX = this.spawnPos.method_10263() * 8;
                        int translatedZ = this.spawnPos.method_10260() * 8;
                        class_2338 translatedSpawnPos = new class_2338(new class_2382(translatedX, this.spawnPos.method_10264(), translatedZ));
                        distance = this.distance(translatedSpawnPos, portal.getSpawnPos());
                    } else {
                        distance = this.distance(this.spawnPos, portal.getSpawnPos());
                    }
                } else {
                    distance = this.distance(this.spawnPos, portal.getSpawnPos());
                }
                if (!CPSettings.instance().unlimitedRange) {
                    int tier = Math.max(portal.getEnhanceTier(), this.getEnhanceTier());
                    switch (tier) {
                        case 0: {
                            if (distance <= CPSettings.instance().defaultRange) break;
                            return;
                        }
                        case 1: {
                            if (distance <= CPSettings.instance().rangeWithEnhancer) break;
                            return;
                        }
                        case 2: {
                            if (distance <= CPSettings.instance().rangeWithStrongEnhancer) break;
                            return;
                        }
                    }
                }
            }
            this.linked = portal;
            portal.setLinked(this);
        }
    }

    private int distance(class_2338 pos1, class_2338 pos2) {
        int x1 = pos1.method_10263();
        int x2 = pos2.method_10263();
        int y1 = pos1.method_10264();
        int y2 = pos2.method_10264();
        int z1 = pos1.method_10260();
        int z2 = pos2.method_10260();
        double d = Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0) + Math.pow(z2 - z1, 2.0));
        return (int)d;
    }
}

