/*
 * Decompiled with CFR 0.152.
 */
package dev.custom.portals.util;

import dev.custom.portals.CustomPortals;
import dev.custom.portals.blocks.AbstractRuneBlock;
import dev.custom.portals.config.CPSettings;
import dev.custom.portals.data.BasePortalComponent;
import dev.custom.portals.data.CustomPortal;
import dev.custom.portals.registry.CPBlocks;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.UUID;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7923;

public class PortalHelper {
    public static final class_2960 DRAW_SPRITE_PACKET_ID = class_2960.method_60655((String)"customportals", (String)"draw_sprite");
    public static final class_2960 SCREEN_TRANSITION_PACKET_ID = class_2960.method_60655((String)"customportals", (String)"is_in_transition");

    private static class_2338 getUp(class_2338 pos, class_2350.class_2351 axis) {
        return axis == class_2350.class_2351.field_11052 ? pos.method_10095() : pos.method_10084();
    }

    private static class_2338 getDown(class_2338 pos, class_2350.class_2351 axis) {
        return axis == class_2350.class_2351.field_11052 ? pos.method_10072() : pos.method_10074();
    }

    private static class_2338 getLeft(class_2338 pos, class_2350.class_2351 axis) {
        return axis == class_2350.class_2351.field_11048 ? pos.method_10072() : pos.method_10078();
    }

    private static class_2338 getRight(class_2338 pos, class_2350.class_2351 axis) {
        return axis == class_2350.class_2351.field_11048 ? pos.method_10095() : pos.method_10067();
    }

    private static int getTranslatedX(class_2338 pos, class_2350.class_2351 axis) {
        return axis == class_2350.class_2351.field_11048 ? pos.method_10260() : pos.method_10263();
    }

    private static int getTranslatedY(class_2338 pos, class_2350.class_2351 axis) {
        return axis == class_2350.class_2351.field_11052 ? pos.method_10260() : pos.method_10264();
    }

    private static List<class_2338> getAdjacentsOnPlane(class_2338 blockPos, class_2350.class_2351 axis) {
        ArrayList<class_2338> adjacents = new ArrayList<class_2338>();
        adjacents.add(PortalHelper.getUp(blockPos, axis));
        adjacents.add(PortalHelper.getLeft(blockPos, axis));
        adjacents.add(PortalHelper.getRight(blockPos, axis));
        adjacents.add(PortalHelper.getDown(blockPos, axis));
        return adjacents;
    }

    private static List<class_2338> getAdjacents(class_2338 blockPos) {
        ArrayList<class_2338> adjacents = new ArrayList<class_2338>();
        adjacents.add(blockPos.method_10084());
        adjacents.add(blockPos.method_10074());
        adjacents.add(blockPos.method_10095());
        adjacents.add(blockPos.method_10072());
        adjacents.add(blockPos.method_10078());
        adjacents.add(blockPos.method_10067());
        return adjacents;
    }

    /*
     * WARNING - void declaration
     */
    private static SpawnPosData determineSpawnPos(List<class_2338> portalBlocks, class_2248 portalBlock, class_2350.class_2351 axis, class_1937 world) {
        int trueYSpawn;
        int n;
        void var11_20;
        int leftmost = PortalHelper.getTranslatedX(portalBlocks.get(0), axis);
        int rightmost = PortalHelper.getTranslatedX(portalBlocks.get(0), axis);
        for (class_2338 blockPos : portalBlocks) {
            int x = PortalHelper.getTranslatedX(blockPos, axis);
            if (x < leftmost) {
                leftmost = x;
            }
            if (x <= rightmost) continue;
            rightmost = x;
        }
        int xSpawn = (rightmost + leftmost) / 2;
        int length = rightmost - leftmost + 1;
        if (length % 2 == 0 && leftmost >= 0) {
            ++xSpawn;
        }
        ArrayList<class_2338> midPortalBlocks = new ArrayList<class_2338>();
        for (class_2338 class_23382 : portalBlocks) {
            int n2 = PortalHelper.getTranslatedX(class_23382, axis);
            if (n2 != xSpawn) continue;
            midPortalBlocks.add(class_23382);
        }
        class_2338 bottom = (class_2338)midPortalBlocks.get(0);
        for (class_2338 class_23383 : midPortalBlocks) {
            if (PortalHelper.getTranslatedY(class_23383, axis) >= PortalHelper.getTranslatedY(bottom, axis)) continue;
            bottom = class_23383;
        }
        int n3 = PortalHelper.getTranslatedY(bottom, axis);
        boolean bl = true;
        if (axis == class_2350.class_2351.field_11052) {
            class_2338 pos = bottom;
            while (world.method_8320(PortalHelper.getDown(pos, axis)).method_27852(portalBlock)) {
                pos = PortalHelper.getDown(pos, axis);
                ++var11_20;
            }
            n = n3 + var11_20 / 2;
        }
        int trueXSpawn = axis == class_2350.class_2351.field_11048 ? bottom.method_10263() : xSpawn;
        int n4 = trueYSpawn = axis == class_2350.class_2351.field_11052 ? bottom.method_10264() : n;
        int trueZSpawn = axis == class_2350.class_2351.field_11051 ? bottom.method_10260() : (axis == class_2350.class_2351.field_11048 ? xSpawn : n);
        float offsetX = 0.0f;
        float offsetZ = 0.0f;
        switch (axis) {
            case field_11048: {
                offsetX = 0.5f;
                if (length % 2 == 0) break;
                offsetZ = 0.5f;
                break;
            }
            case field_11052: {
                if (length % 2 != 0) {
                    offsetX = 0.5f;
                }
                if (var11_20 % 2 == false) break;
                offsetZ = 0.5f;
                break;
            }
            case field_11051: {
                offsetZ = 0.5f;
                if (length % 2 == 0) break;
                offsetX = 0.5f;
            }
        }
        class_2338 spawnPos = new class_2338(new class_2382(trueXSpawn, trueYSpawn, trueZSpawn));
        return new SpawnPosData(spawnPos, offsetX, offsetZ);
    }

    public static boolean buildPortal(class_2338 startPos, class_2248 portalBlock, UUID creatorId, class_1937 world) {
        if (PortalHelper.buildPortal(startPos, class_2350.class_2351.field_11048, portalBlock, creatorId, world)) {
            return true;
        }
        if (PortalHelper.buildPortal(startPos, class_2350.class_2351.field_11052, portalBlock, creatorId, world)) {
            return true;
        }
        return PortalHelper.buildPortal(startPos, class_2350.class_2351.field_11051, portalBlock, creatorId, world);
    }

    public static boolean buildPortal(class_2338 blockPos, class_2350.class_2351 axis, class_2248 portalBlock, UUID creatorId, class_1937 world) {
        if (!world.method_8320(blockPos).method_26215()) {
            return false;
        }
        List<class_2338> adjacents = PortalHelper.getAdjacentsOnPlane(blockPos, axis);
        class_2248 frameMaterial = class_2246.field_10124;
        for (class_2338 pos : adjacents) {
            class_2680 blockState = world.method_8320(pos);
            if (blockState.method_26215()) continue;
            if (frameMaterial != class_2246.field_10124) {
                if (frameMaterial.equals(blockState.method_26204())) continue;
                return false;
            }
            if (blockState.method_26234((class_1922)world, pos)) {
                frameMaterial = blockState.method_26204();
                continue;
            }
            return false;
        }
        class_2338 startPos = blockPos;
        if (frameMaterial == class_2246.field_10124) {
            int i = 0;
            while (world.method_8320(PortalHelper.getDown(startPos, axis)).method_26215()) {
                if (i > 30) {
                    return false;
                }
                startPos = PortalHelper.getDown(startPos, axis);
                ++i;
            }
            if (!world.method_8320(PortalHelper.getDown(startPos, axis)).method_26234((class_1922)world, PortalHelper.getDown(startPos, axis))) {
                return false;
            }
            frameMaterial = world.method_8320(PortalHelper.getDown(startPos, axis)).method_26204();
        }
        String frameId = class_7923.field_41175.method_10221((Object)frameMaterial).toString();
        List<String> blockIds = CPSettings.instance().filteredBlocks;
        if (CPSettings.instance().isWhitelist ? !blockIds.contains(frameId) : blockIds.contains(frameId)) {
            return false;
        }
        ArrayList<class_2338> portalBlocks = new ArrayList<class_2338>();
        Stack<class_2338> s = new Stack<class_2338>();
        HashSet<class_2338> visited = new HashSet<class_2338>();
        HashSet<class_2338> frames = new HashSet<class_2338>();
        s.push(startPos);
        while (!s.isEmpty()) {
            class_2338 curPos = (class_2338)s.pop();
            if (!visited.add(curPos)) continue;
            if (visited.size() > 900) {
                return false;
            }
            List<class_2338> curAdjacents = PortalHelper.getAdjacentsOnPlane(curPos, axis);
            Iterator iterator = curAdjacents.iterator();
            while (iterator.hasNext()) {
                class_2338 pos = (class_2338)iterator.next();
                class_2680 blockState = world.method_8320(pos);
                if (blockState.method_26215()) {
                    if (visited.contains(pos)) continue;
                    s.push(pos);
                    continue;
                }
                if (!blockState.method_27852(frameMaterial)) {
                    return false;
                }
                frames.add(pos);
            }
            portalBlocks.add(curPos);
        }
        class_2680 portalState = switch (axis) {
            default -> throw new MatchException(null, null);
            case class_2350.class_2351.field_11048 -> portalBlock.method_9564().method_26186(class_2470.field_11463);
            case class_2350.class_2351.field_11052 -> portalBlock.method_9564().method_26186(class_2470.field_11465);
            case class_2350.class_2351.field_11051 -> portalBlock.method_9564();
        };
        for (class_2338 pos : portalBlocks) {
            world.method_8501(pos, portalState);
        }
        SpawnPosData spawnPosData = PortalHelper.determineSpawnPos(portalBlocks, portalBlock, axis, world);
        CustomPortal portal = new CustomPortal(frameId, world.method_27983().method_29177().toString(), portalBlock.method_26403(), spawnPosData.blockPos, portalBlocks, spawnPosData.offsetX, spawnPosData.offsetZ, creatorId);
        ((BasePortalComponent)CustomPortals.PORTALS.get((Object)world)).registerPortal(portal);
        for (class_2338 framePos : frames) {
            List<class_2338> frameAdjacents = PortalHelper.getAdjacents(framePos);
            for (class_2338 adj : frameAdjacents) {
                class_2248 block = world.method_8320(adj).method_26204();
                if (!(block instanceof AbstractRuneBlock) || !((AbstractRuneBlock)block).getBlockMountedPos(adj, world.method_8320(adj)).equals((Object)framePos)) continue;
                ((AbstractRuneBlock)block).registerOnPortal(portal, world);
            }
        }
        if (!world.method_8608()) {
            ((BasePortalComponent)CustomPortals.PORTALS.get((Object)world)).syncWithAll(((class_3218)world).method_8503());
        }
        return true;
    }

    public static class_2248 getPortalBlockFromColorId(int colorId) {
        return switch (colorId) {
            case 29 -> CPBlocks.BLACK_PORTAL;
            case 25 -> CPBlocks.BLUE_PORTAL;
            case 26 -> CPBlocks.BROWN_PORTAL;
            case 23 -> CPBlocks.CYAN_PORTAL;
            case 21 -> CPBlocks.GRAY_PORTAL;
            case 27 -> CPBlocks.GREEN_PORTAL;
            case 17 -> CPBlocks.LIGHT_BLUE_PORTAL;
            case 22 -> CPBlocks.LIGHT_GRAY_PORTAL;
            case 19 -> CPBlocks.LIME_PORTAL;
            case 16 -> CPBlocks.MAGENTA_PORTAL;
            case 15 -> CPBlocks.ORANGE_PORTAL;
            case 20 -> CPBlocks.PINK_PORTAL;
            case 24 -> CPBlocks.PURPLE_PORTAL;
            case 28 -> CPBlocks.RED_PORTAL;
            case 8 -> CPBlocks.WHITE_PORTAL;
            case 18 -> CPBlocks.YELLOW_PORTAL;
            default -> class_2246.field_10316;
        };
    }

    static class SpawnPosData {
        protected class_2338 blockPos;
        protected float offsetX;
        protected float offsetZ;

        protected SpawnPosData(class_2338 blockPos, float offsetX, float offsetZ) {
            this.blockPos = blockPos;
            this.offsetX = offsetX;
            this.offsetZ = offsetZ;
        }
    }
}

