/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.telepathicgrunt.the_bumblezone.blocks.EssenceBlock;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.EssenceBlockEntity;
import com.telepathicgrunt.the_bumblezone.bossbars.ServerEssenceEvent;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzStats;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.packets.MusicPacketFromServer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;

public class EssenceBlockBlue
extends EssenceBlock {
    private static final int ENTITIES_TO_KILL = 50;

    public EssenceBlockBlue() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283743_));
    }

    @Override
    public ResourceLocation getArenaNbt() {
        return new ResourceLocation("the_bumblezone", "essence/blue_arena");
    }

    @Override
    public int getEventTimeFrame() {
        return 10800;
    }

    @Override
    public ServerEssenceEvent getServerEssenceEvent() {
        return (ServerEssenceEvent)new ServerEssenceEvent("essence.the_bumblezone.blue_essence_event", BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.NOTCHED_20).m_7003_(true);
    }

    @Override
    public ResourceLocation getEssenceItemReward() {
        return new ResourceLocation("the_bumblezone", "gameplay/rewards/blue_arena_victory");
    }

    @Override
    public int getEssenceXpReward() {
        return 3000;
    }

    @Override
    public boolean hasMiningFatigue() {
        return true;
    }

    @Override
    public void awardPlayerWinStat(ServerPlayer serverPlayer) {
        serverPlayer.m_36220_(BzStats.CALMING_EVENT_DEFEATED_RL.get());
    }

    @Override
    public void performUniqueArenaTick(ServerLevel serverLevel, BlockPos blockPos, BlockState blockState, EssenceBlockEntity essenceBlockEntity) {
        if (essenceBlockEntity.getPlayerInArena().size() == 0) {
            return;
        }
        int entitiesKilled = essenceBlockEntity.getExtraEventTrackingProgress();
        List<EssenceBlockEntity.EventEntities> eventEntitiesInArena = essenceBlockEntity.getEventEntitiesInArena();
        if (entitiesKilled != 50 && (double)eventEntitiesInArena.size() < Math.min(3.0 + (double)essenceBlockEntity.getPlayerInArena().size() * 1.5, (double)(50 - entitiesKilled))) {
            int currentEntityCount = eventEntitiesInArena.size() + entitiesKilled;
            EssenceBlockBlue.SpawnNewEnemy(serverLevel, blockPos, blockState, essenceBlockEntity, currentEntityCount, eventEntitiesInArena);
        } else {
            for (int i = eventEntitiesInArena.size() - 1; i >= 0; --i) {
                Mob mob;
                ServerPlayer player;
                UUID playerUUID;
                NeutralMob neutralMob;
                UUID entityToCheck = eventEntitiesInArena.get(i).uuid();
                Entity entity = serverLevel.m_8791_(entityToCheck);
                if (entity == null) {
                    ++entitiesKilled;
                    eventEntitiesInArena.remove(i);
                    continue;
                }
                if (entity instanceof NeutralMob && !((neutralMob = (NeutralMob)entity).m_5448_() instanceof Player)) {
                    playerUUID = essenceBlockEntity.getPlayerInArena().get(serverLevel.m_213780_().m_188503_(essenceBlockEntity.getPlayerInArena().size()));
                    player = serverLevel.m_7654_().m_6846_().m_11259_(playerUUID);
                    neutralMob.m_7870_(Integer.MAX_VALUE);
                    neutralMob.m_6925_(playerUUID);
                    neutralMob.m_6710_((LivingEntity)player);
                    continue;
                }
                if (!(entity instanceof Mob) || (mob = (Mob)entity).m_5448_() instanceof Player) continue;
                playerUUID = essenceBlockEntity.getPlayerInArena().get(serverLevel.m_213780_().m_188503_(essenceBlockEntity.getPlayerInArena().size()));
                player = serverLevel.m_7654_().m_6846_().m_11259_(playerUUID);
                mob.m_6710_((LivingEntity)player);
            }
        }
        this.handleGiantBubbles(serverLevel, blockPos);
        float newProgress = entitiesKilled / 50;
        essenceBlockEntity.getEventBar().m_142711_(1.0f - newProgress);
        essenceBlockEntity.setExtraEventTrackingProgress(entitiesKilled);
        if (entitiesKilled == 50) {
            EssenceBlockEntity.EndEvent(serverLevel, blockPos, blockState, essenceBlockEntity, true);
        }
    }

    private static void SpawnNewEnemy(ServerLevel serverLevel, BlockPos blockPos, BlockState blockState, EssenceBlockEntity essenceBlockEntity, int currentEntityCount, List<EssenceBlockEntity.EventEntities> eventEntitiesInArena) {
        EntityType entityTypeToSpawn;
        TagKey<EntityType<?>> enemyTagToUse = BzTags.ESSENCE_CALMING_ARENA_NORMAL_ENEMY;
        boolean isStrong = false;
        int entityToSpawnIndex = currentEntityCount + 1;
        if (entityToSpawnIndex == 28 || entityToSpawnIndex == 35 || entityToSpawnIndex == 48 || entityToSpawnIndex == 49 || entityToSpawnIndex == 50) {
            enemyTagToUse = BzTags.ESSENCE_CALMING_ARENA_BOSS_ENEMY;
        } else if (entityToSpawnIndex % 5 == 0) {
            enemyTagToUse = BzTags.ESSENCE_CALMING_ARENA_STRONG_ENEMY;
            isStrong = true;
        } else if (entityToSpawnIndex >= 25) {
            enemyTagToUse = BzTags.ESSENCE_CALMING_ARENA_LATE_NORMAL_ENEMY;
        }
        List entityTypeList = BuiltInRegistries.f_256780_.m_203431_(enemyTagToUse).map(holders -> holders.m_203614_().map(Holder::m_203334_).toList()).orElseGet(ArrayList::new);
        Direction direction = Direction.m_235672_((RandomSource)serverLevel.m_213780_());
        EntityType entityType = entityTypeToSpawn = entityTypeList.isEmpty() ? null : (EntityType)entityTypeList.get(serverLevel.m_213780_().m_188503_(entityTypeList.size()));
        if (entityTypeToSpawn == null) {
            return;
        }
        Entity entity = entityTypeToSpawn.m_262496_(serverLevel, blockPos.m_7918_(direction.m_122429_() * 3, direction.m_122430_() * 3, direction.m_122431_() * 3), MobSpawnType.TRIGGERED);
        if (entity == null) {
            return;
        }
        entity.m_20049_("the_bumblezone.blue_essence_arena");
        eventEntitiesInArena.add(new EssenceBlockEntity.EventEntities(entity.m_20148_()));
        UUID playerUUID = essenceBlockEntity.getPlayerInArena().get(serverLevel.m_213780_().m_188503_(essenceBlockEntity.getPlayerInArena().size()));
        ServerPlayer player = serverLevel.m_7654_().m_6846_().m_11259_(playerUUID);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = player;
            float maxHeart = Math.max(serverPlayer.m_21223_(), serverPlayer.m_21233_());
            float maxArmor = serverPlayer.m_21230_();
            float mobHealthBoost = maxHeart / 15.0f + maxArmor / 20.0f;
            float mobAttackBoost = maxHeart / 25.0f + maxArmor / 10.0f;
            boolean isEssenced = EssenceOfTheBees.hasEssence(serverPlayer);
            if (!isEssenced) {
                mobHealthBoost *= 1.5f;
                mobAttackBoost *= 1.5f;
            }
            float timeProgress = 1.0f - (float)essenceBlockEntity.getEventTimer() / (float)((EssenceBlock)blockState.m_60734_()).getEventTimeFrame();
            float enemyProgress = essenceBlockEntity.getExtraEventTrackingProgress() / 50;
            float progressDiff = (float)(Math.pow(enemyProgress - timeProgress + 1.0f, 2.0) - 1.0);
            if ((double)progressDiff > 0.1) {
                progressDiff = (float)(Math.pow((double)(enemyProgress - timeProgress) + 0.95, 5.0) - 0.95);
                mobHealthBoost += (float)((int)(progressDiff / 0.025f));
                mobAttackBoost += (float)((int)(progressDiff / 0.1f));
            }
            if (entity instanceof LivingEntity) {
                AttributeInstance livingEntityAttributeFollowRange;
                AttributeInstance livingEntityAttributeFlyingSpeed;
                AttributeInstance livingEntityAttributeSpeed;
                AttributeInstance livingEntityAttributeAttack;
                LivingEntity livingEntity = (LivingEntity)entity;
                AttributeInstance livingEntityAttributeHealth = livingEntity.m_21051_(Attributes.f_22276_);
                if (livingEntityAttributeHealth != null) {
                    livingEntityAttributeHealth.m_22125_(new AttributeModifier(UUID.fromString("03c85bd0-09eb-11ee-be56-0242ac120002"), "Essence Arena Health Boost", (double)mobHealthBoost, AttributeModifier.Operation.ADDITION));
                    livingEntity.m_5634_(mobHealthBoost);
                }
                if ((livingEntityAttributeAttack = livingEntity.m_21051_(Attributes.f_22281_)) != null) {
                    livingEntityAttributeAttack.m_22125_(new AttributeModifier(UUID.fromString("355141f8-09eb-11ee-be56-0242ac120002"), "Essence Arena Damage Boost", (double)mobAttackBoost, AttributeModifier.Operation.ADDITION));
                }
                if ((livingEntityAttributeSpeed = livingEntity.m_21051_(Attributes.f_22279_)) != null) {
                    livingEntityAttributeSpeed.m_22125_(new AttributeModifier(UUID.fromString("39ca0496-fa37-488f-8199-c4779f1afe0c"), "Essence Arena Speed Boost", isEssenced ? 0.04 : 0.08, AttributeModifier.Operation.ADDITION));
                }
                if ((livingEntityAttributeFlyingSpeed = livingEntity.m_21051_(Attributes.f_22280_)) != null) {
                    livingEntityAttributeFlyingSpeed.m_22125_(new AttributeModifier(UUID.fromString("c762c216-0a3a-11ee-be56-0242ac120002"), "Essence Arena Flying Speed Boost", 0.02, AttributeModifier.Operation.ADDITION));
                }
                if ((livingEntityAttributeFollowRange = livingEntity.m_21051_(Attributes.f_22277_)) != null) {
                    livingEntityAttributeFollowRange.m_22125_(new AttributeModifier(UUID.fromString("23a7a8a9-85bc-4dc3-9417-a4bd4b1b95a2"), "Essence Arena Sight Boost", 32.0, AttributeModifier.Operation.ADDITION));
                }
            }
            if (entity instanceof NeutralMob) {
                NeutralMob neutralMob = (NeutralMob)entity;
                neutralMob.m_7870_(Integer.MAX_VALUE);
                neutralMob.m_6925_(playerUUID);
                neutralMob.m_6710_((LivingEntity)serverPlayer);
            } else if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                List itemList = BuiltInRegistries.f_257033_.m_203431_(BzTags.CALMING_ARENA_DROWNED_BONUS_HELD_ITEM).map(holders -> holders.m_203614_().map(Holder::m_203334_).toList()).orElseGet(ArrayList::new);
                ItemStack bonusItem = itemList.isEmpty() ? ItemStack.f_41583_ : ((Item)itemList.get(serverLevel.m_213780_().m_188503_(itemList.size()))).m_7968_();
                mob.m_6710_((LivingEntity)serverPlayer);
                if (mob instanceof Drowned) {
                    ItemStack helmet;
                    Drowned drowned = (Drowned)mob;
                    ItemStack swimBoots = Items.f_42463_.m_7968_();
                    swimBoots.m_41663_(Enchantments.f_44973_, 3);
                    drowned.m_255207_(swimBoots);
                    drowned.m_21409_(EquipmentSlot.FEET, 0.2f);
                    ItemStack leggings = Items.f_42462_.m_7968_();
                    leggings.m_41663_(Enchantments.f_44972_, 1);
                    drowned.m_255207_(leggings);
                    drowned.m_21409_(EquipmentSlot.LEGS, 0.2f);
                    ItemStack chestplate = Items.f_42408_.m_7968_();
                    chestplate.m_41663_(Enchantments.f_44969_, 1);
                    drowned.m_255207_(chestplate);
                    drowned.m_21409_(EquipmentSlot.CHEST, 0.2f);
                    ItemStack itemStack = helmet = serverLevel.m_213780_().m_188501_() < 0.1f ? Items.f_42354_.m_7968_() : Items.f_42407_.m_7968_();
                    if (serverLevel.m_213780_().m_188501_() < 0.75f) {
                        helmet.m_41663_(Enchantments.f_44971_, 1);
                    } else {
                        helmet.m_41663_(Enchantments.f_44970_, 3);
                    }
                    drowned.m_255207_(helmet);
                    drowned.m_21409_(EquipmentSlot.HEAD, 0.15f);
                    if (isStrong) {
                        ItemStack trident = Items.f_42713_.m_7968_();
                        if ((double)serverLevel.m_213780_().m_188501_() < 0.25) {
                            trident.m_41663_(Enchantments.f_44958_, 1);
                        } else if ((double)serverLevel.m_213780_().m_188501_() < 0.25) {
                            trident.m_41663_(Enchantments.f_44955_, 1);
                        } else if ((double)serverLevel.m_213780_().m_188501_() < 0.25) {
                            trident.m_41663_(Enchantments.f_44956_, 1);
                        } else {
                            trident.m_41663_(Enchantments.f_44957_, 1);
                        }
                        drowned.m_8061_(EquipmentSlot.MAINHAND, trident);
                        drowned.m_21409_(EquipmentSlot.MAINHAND, 0.9f);
                    } else {
                        if (drowned.m_21205_().m_150930_(Items.f_42713_)) {
                            drowned.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                        } else if (drowned.m_21206_().m_150930_(Items.f_42713_)) {
                            drowned.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                        }
                        drowned.m_7292_(new MobEffectInstance(MobEffects.f_19596_, Integer.MAX_VALUE, 4, false, false, true));
                    }
                    if (drowned.m_21205_().m_41619_() && serverLevel.m_213780_().m_188501_() < 0.3f) {
                        drowned.m_8061_(EquipmentSlot.MAINHAND, bonusItem);
                        drowned.m_21409_(EquipmentSlot.MAINHAND, 2.0f);
                    } else if (drowned.m_21206_().m_41619_() && serverLevel.m_213780_().m_188501_() < 0.3f) {
                        drowned.m_8061_(EquipmentSlot.OFFHAND, bonusItem);
                        drowned.m_21409_(EquipmentSlot.OFFHAND, 2.0f);
                    }
                }
            }
        }
    }

    public void handleGiantBubbles(ServerLevel serverLevel, BlockPos blockPos) {
        int bubbleMoveTime;
        if (!BzGeneralConfigs.blueArenaBubblesMechanic) {
            return;
        }
        long gameTime = serverLevel.m_46467_();
        if (gameTime % (long)(bubbleMoveTime = 23) == 0L) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                int offSetBubble = direction.m_122434_() == Direction.Axis.X ? 0 : 8;
                int currentProgress = (int)((gameTime / (long)bubbleMoveTime + (long)offSetBubble) % 16L);
                BlockPos bubbleCenter = blockPos.m_7918_(direction.m_122429_() * 10, currentProgress - 8, direction.m_122431_() * 10);
                BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
                for (int y = -2; y <= 1; ++y) {
                    mutableBlockPos.m_122190_((Vec3i)bubbleCenter).m_122175_(Direction.UP, y);
                    if (mutableBlockPos.m_123342_() < blockPos.m_123342_() - 5 || mutableBlockPos.m_123342_() > blockPos.m_123342_() + 5) continue;
                    for (int x = -1; x <= 1; ++x) {
                        mutableBlockPos.m_122175_(Direction.EAST, x);
                        for (int z = -1; z <= 1; ++z) {
                            mutableBlockPos.m_122175_(Direction.SOUTH, z);
                            if (y == -2) {
                                serverLevel.m_7731_((BlockPos)mutableBlockPos, Blocks.f_49990_.m_49966_(), 2);
                            } else {
                                serverLevel.m_7731_((BlockPos)mutableBlockPos, BzBlocks.DENSE_BUBBLE_BLOCK.get().m_49966_(), 2);
                            }
                            mutableBlockPos.m_122175_(Direction.SOUTH, -z);
                        }
                        mutableBlockPos.m_122175_(Direction.EAST, -x);
                    }
                }
            }
        }
    }

    @Override
    public void onPlayerEnter(ServerLevel serverLevel, ServerPlayer serverPlayer, EssenceBlockEntity essenceBlockEntity) {
        MusicPacketFromServer.sendToClient((Player)serverPlayer, BzSounds.CALMING_EVENT.get().m_11660_(), true);
        super.onPlayerEnter(serverLevel, serverPlayer, essenceBlockEntity);
    }

    @Override
    public void onPlayerLeave(ServerLevel serverLevel, ServerPlayer serverPlayer, EssenceBlockEntity essenceBlockEntity) {
        MusicPacketFromServer.sendToClient((Player)serverPlayer, BzSounds.CALMING_EVENT.get().m_11660_(), false);
        super.onPlayerLeave(serverLevel, serverPlayer, essenceBlockEntity);
    }
}

