/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.telepathicgrunt.the_bumblezone.blocks.EssenceBlock;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.EssenceBlockEntity;
import com.telepathicgrunt.the_bumblezone.bossbars.ServerEssenceEvent;
import com.telepathicgrunt.the_bumblezone.client.rendering.cosmiccrystal.CosmicCrystalState;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.entities.living.CosmicCrystalEntity;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzStats;
import com.telepathicgrunt.the_bumblezone.packets.MusicPacketFromServer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;

public class EssenceBlockWhite
extends EssenceBlock {
    public EssenceBlockWhite() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283811_));
    }

    @Override
    public ResourceLocation getArenaNbt() {
        return new ResourceLocation("the_bumblezone", "essence/white_arena");
    }

    @Override
    public int getEventTimeFrame() {
        return 10000;
    }

    @Override
    public ServerEssenceEvent getServerEssenceEvent() {
        return (ServerEssenceEvent)new ServerEssenceEvent("essence.the_bumblezone.white_essence_event", BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.NOTCHED_6).m_7003_(true);
    }

    @Override
    public ResourceLocation getEssenceItemReward() {
        return new ResourceLocation("the_bumblezone", "gameplay/rewards/white_arena_victory");
    }

    @Override
    public int getEssenceXpReward() {
        return 3000;
    }

    @Override
    public boolean hasMiningFatigue() {
        return true;
    }

    @Override
    public void awardPlayerWinStat(ServerPlayer serverPlayer) {
        serverPlayer.m_36220_(BzStats.CONTINUITY_EVENT_DEFEATED_RL.get());
    }

    @Override
    public void performUniqueArenaTick(ServerLevel serverLevel, BlockPos blockPos, BlockState blockState, EssenceBlockEntity essenceBlockEntity) {
        if (essenceBlockEntity.getPlayerInArena().size() == 0) {
            return;
        }
        if (essenceBlockEntity.getEventTimer() > this.getEventTimeFrame() - 50) {
            return;
        }
        List<EssenceBlockEntity.EventEntities> eventEntitiesInArena = essenceBlockEntity.getEventEntitiesInArena();
        int totalCrystals = eventEntitiesInArena.size();
        int totalhealth = 0;
        float totalMaxHealth = 6 * BzGeneralConfigs.cosmicCrystalHealth;
        boolean respawnedACrystal = false;
        if (totalCrystals == 0 && essenceBlockEntity.getEventTimer() > this.getEventTimeFrame() - 100) {
            this.SpawnNewCrystal(serverLevel, blockPos, essenceBlockEntity, 0, 1.0f, eventEntitiesInArena);
            this.SpawnNewCrystal(serverLevel, blockPos, essenceBlockEntity, 60, 1.0f, eventEntitiesInArena);
            this.SpawnNewCrystal(serverLevel, blockPos, essenceBlockEntity, 120, 1.0f, eventEntitiesInArena);
            this.SpawnNewCrystal(serverLevel, blockPos, essenceBlockEntity, 180, 1.0f, eventEntitiesInArena);
            this.SpawnNewCrystal(serverLevel, blockPos, essenceBlockEntity, 240, 1.0f, eventEntitiesInArena);
            this.SpawnNewCrystal(serverLevel, blockPos, essenceBlockEntity, 300, 1.0f, eventEntitiesInArena);
            totalCrystals = 6;
        } else {
            ArrayList<CosmicCrystalEntity> crystals = new ArrayList<CosmicCrystalEntity>();
            boolean crystalsAreIdleLongEnough = true;
            for (int i = eventEntitiesInArena.size() - 1; i >= 0; --i) {
                Object nearbyCrystal2;
                UUID entityToCheck = eventEntitiesInArena.get(i).uuid();
                Object entity = serverLevel.m_8791_(entityToCheck);
                if (entity == null) {
                    List nearbyCosmicCrystalEntities = serverLevel.m_45976_(CosmicCrystalEntity.class, new AABB((double)((float)blockPos.m_123341_() - (float)essenceBlockEntity.getArenaSize().m_123341_() * 0.5f), (double)((float)blockPos.m_123342_() - (float)essenceBlockEntity.getArenaSize().m_123342_() * 0.5f), (double)((float)blockPos.m_123343_() - (float)essenceBlockEntity.getArenaSize().m_123343_() * 0.5f), (double)((float)blockPos.m_123341_() + (float)essenceBlockEntity.getArenaSize().m_123341_() * 0.5f), (double)((float)blockPos.m_123342_() + (float)essenceBlockEntity.getArenaSize().m_123342_() * 0.5f), (double)((float)blockPos.m_123343_() + (float)essenceBlockEntity.getArenaSize().m_123343_() * 0.5f)));
                    for (Object nearbyCrystal2 : nearbyCosmicCrystalEntities) {
                        if (!nearbyCrystal2.m_20148_().equals(entityToCheck) || !nearbyCrystal2.getEssenceController().equals(essenceBlockEntity.getUUID())) continue;
                        entity = nearbyCrystal2;
                        break;
                    }
                }
                if (entity == null) {
                    eventEntitiesInArena.remove(i);
                    this.SpawnNewCrystal(serverLevel, blockPos, essenceBlockEntity, 60 * i, 1.0f, eventEntitiesInArena);
                    respawnedACrystal = true;
                }
                if (!(entity instanceof CosmicCrystalEntity)) continue;
                CosmicCrystalEntity cosmicCrystalEntity = (CosmicCrystalEntity)((Object)entity);
                nearbyCrystal2 = blockState.m_60734_();
                if (nearbyCrystal2 instanceof EssenceBlock) {
                    EssenceBlock essenceBlock = (EssenceBlock)nearbyCrystal2;
                    if (essenceBlockEntity.getEventTimer() > essenceBlock.getEventTimeFrame() - 70) {
                        return;
                    }
                }
                totalhealth = (int)((float)totalhealth + cosmicCrystalEntity.m_21223_());
                if (cosmicCrystalEntity.getCosmicCrystalState() != CosmicCrystalState.NORMAL || cosmicCrystalEntity.currentStateTimeTick < 50) {
                    crystalsAreIdleLongEnough = false;
                }
                crystals.add(cosmicCrystalEntity);
            }
            float healthPercent = (float)Math.round((float)totalhealth / totalMaxHealth * 10.0f) / 10.0f;
            int shieldThreshold = (int)Math.ceil((double)healthPercent / 0.166);
            int reductionInTicks = 600 * (6 - shieldThreshold);
            boolean shield = shieldThreshold > 0 && essenceBlockEntity.getEventTimer() + reductionInTicks > this.getEventTimeFrame();
            crystals.forEach(c -> c.setShield(shield));
            if (crystalsAreIdleLongEnough && !crystals.isEmpty()) {
                CosmicCrystalEntity crystalEntity;
                int i;
                CosmicCrystalState chosenAttack;
                while (((CosmicCrystalEntity)((Object)crystals.get((int)0))).pastStates.contains((Object)(chosenAttack = CosmicCrystalState.values()[serverLevel.m_213780_().m_188503_(CosmicCrystalState.values().length)])) || chosenAttack == CosmicCrystalState.NORMAL) {
                }
                float threshold = healthPercent > 0.75f ? 0.0f : (healthPercent > 0.5f ? 0.333f : (healthPercent > 0.25f ? 0.666f : 1.0f));
                CosmicCrystalState finalChosenAttack = chosenAttack;
                crystals.forEach(c -> c.setCosmicCrystalState(finalChosenAttack));
                boolean missingCrystal = respawnedACrystal;
                for (i = 0; i < crystals.size(); ++i) {
                    float difficultyBuff;
                    float newDifficulty;
                    crystalEntity = (CosmicCrystalEntity)((Object)crystals.get(i));
                    int orbitOffset = crystalEntity.getOrbitOffsetDegrees();
                    if (orbitOffset % (360 / crystals.size()) != 0) {
                        missingCrystal = true;
                    }
                    if ((newDifficulty = (1.0f + 0.025f * (float)(6 - totalCrystals)) * (difficultyBuff = (float)(1.0 + Math.pow(threshold, 2.0) * (double)0.35f))) == crystalEntity.getDifficultyBoost()) continue;
                    crystalEntity.setDifficultyBoost(newDifficulty);
                }
                if (missingCrystal) {
                    for (i = 0; i < crystals.size(); ++i) {
                        crystalEntity = (CosmicCrystalEntity)((Object)crystals.get(i));
                        crystalEntity.setOrbitOffsetDegrees(i * (360 / crystals.size()));
                        crystalEntity.currentTickCount = 0;
                    }
                }
            }
        }
        if (totalCrystals == 0) {
            EssenceBlockEntity.EndEvent(serverLevel, blockPos, blockState, essenceBlockEntity, true);
        }
        essenceBlockEntity.getEventBar().m_142711_((float)totalhealth / totalMaxHealth);
    }

    private Entity SpawnNewCrystal(ServerLevel serverLevel, BlockPos blockPos, EssenceBlockEntity essenceBlockEntity, int orbitOffset, float difficultyBoost, List<EssenceBlockEntity.EventEntities> eventEntitiesInArena) {
        CosmicCrystalEntity entity = (CosmicCrystalEntity)BzEntities.COSMIC_CRYSTAL_ENTITY.get().m_262496_(serverLevel, blockPos, MobSpawnType.TRIGGERED);
        if (entity != null) {
            entity.m_20049_("the_bumblezone.white_essence_arena");
            entity.setEssenceControllerDimension((ResourceKey<Level>)serverLevel.m_46472_());
            entity.setEssenceController(essenceBlockEntity.getUUID());
            entity.setEssenceControllerBlockPos(essenceBlockEntity.m_58899_());
            entity.setOrbitOffsetDegrees(orbitOffset);
            entity.setDifficultyBoost(difficultyBoost);
            eventEntitiesInArena.add(new EssenceBlockEntity.EventEntities(entity.m_20148_()));
        }
        return entity;
    }

    public void crystalKilled(CosmicCrystalEntity cosmicCrystalEntity, EssenceBlockEntity essenceBlockEntity) {
        essenceBlockEntity.getEventEntitiesInArena().removeIf(e -> e.uuid().equals(cosmicCrystalEntity.m_20148_()));
    }

    @Override
    public void onPlayerEnter(ServerLevel serverLevel, ServerPlayer serverPlayer, EssenceBlockEntity essenceBlockEntity) {
        MusicPacketFromServer.sendToClient((Player)serverPlayer, BzSounds.CONTINUITY_EVENT.get().m_11660_(), true);
        super.onPlayerEnter(serverLevel, serverPlayer, essenceBlockEntity);
    }

    @Override
    public void onPlayerLeave(ServerLevel serverLevel, ServerPlayer serverPlayer, EssenceBlockEntity essenceBlockEntity) {
        MusicPacketFromServer.sendToClient((Player)serverPlayer, BzSounds.CONTINUITY_EVENT.get().m_11660_(), false);
        super.onPlayerLeave(serverLevel, serverPlayer, essenceBlockEntity);
    }
}

