/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.telepathicgrunt.the_bumblezone.items.HoneyBeeLeggings;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import it.unimi.dsi.fastutil.objects.Object2ShortMap;
import it.unimi.dsi.fastutil.objects.Object2ShortOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectArrayMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StickyHoneyResidue
extends Block {
    public static final BooleanProperty UP = PipeBlock.f_55152_;
    public static final BooleanProperty DOWN = PipeBlock.f_55153_;
    public static final BooleanProperty WEST = PipeBlock.f_55151_;
    public static final BooleanProperty EAST = PipeBlock.f_55149_;
    public static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    public static final BooleanProperty NORTH = PipeBlock.f_55148_;
    private static final VoxelShape[] BASE_SHAPES_BY_DIRECTION_ORDINAL = new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    protected final Short2ObjectMap<VoxelShape> shapeByIndex = new Short2ObjectArrayMap();
    private final Object2ShortMap<BlockState> stateToIndex = new Object2ShortOpenHashMap();
    public static final Map<Direction, BooleanProperty> FACING_TO_PROPERTY_MAP = (Map)PipeBlock.f_55154_.entrySet().stream().collect(Util.m_137448_());

    public StickyHoneyResidue() {
        this(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283895_).m_60910_().m_60913_(6.0f, 0.0f).m_60955_().m_280170_().m_278166_(PushReaction.DESTROY));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    public StickyHoneyResidue(BlockBehaviour.Properties settings) {
        super(settings);
        for (BlockState blockState : this.f_49792_.m_61056_()) {
            this.shapeByIndex.computeIfAbsent(this.getShapeIndex(blockState), bitFlag -> {
                VoxelShape shape = Shapes.m_83040_();
                for (Direction direction : Direction.values()) {
                    if ((bitFlag >> direction.ordinal() & 1) == 0) continue;
                    shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)BASE_SHAPES_BY_DIRECTION_ORDINAL[direction.ordinal()], (BooleanOp)BooleanOp.f_82695_);
                }
                return shape.m_83296_();
            });
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{UP, NORTH, EAST, SOUTH, WEST, DOWN});
    }

    private static short calculateBitFlag(BlockState blockState) {
        short bitFlag = 0;
        for (Direction direction : Direction.values()) {
            if (!((Boolean)blockState.m_61143_((Property)FACING_TO_PROPERTY_MAP.get(direction))).booleanValue()) continue;
            bitFlag = (short)(bitFlag | 1 << direction.ordinal());
        }
        return bitFlag;
    }

    protected short getShapeIndex(BlockState blockState) {
        return this.stateToIndex.computeIfAbsent((Object)blockState, StickyHoneyResidue::calculateBitFlag);
    }

    public VoxelShape m_5940_(BlockState blockstate, BlockGetter world, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.shapeByIndex.getOrDefault(this.getShapeIndex(blockstate), (Object)Shapes.m_83040_());
    }

    public boolean m_7420_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return true;
    }

    private int countFaces(BlockState blockState) {
        int i = 0;
        for (BooleanProperty booleanproperty : FACING_TO_PROPERTY_MAP.values()) {
            if (!((Boolean)blockState.m_61143_((Property)booleanproperty)).booleanValue()) continue;
            ++i;
        }
        return i;
    }

    public boolean m_6864_(BlockState blockState, BlockPlaceContext blockPlaceContext) {
        BlockState blockstate = blockPlaceContext.m_43725_().m_8055_(blockPlaceContext.m_8083_());
        if (blockstate.m_60713_((Block)this)) {
            return this.countFaces(blockstate) < FACING_TO_PROPERTY_MAP.size();
        }
        return super.m_6864_(blockState, blockPlaceContext);
    }

    @Deprecated
    public void m_7892_(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        if (entity.m_6095_().m_204039_(BzTags.STICKY_HONEY_RESIDUE_CANNOT_SLOW)) {
            super.m_7892_(blockState, level, blockPos, entity);
            return;
        }
        ItemStack beeLeggings = HoneyBeeLeggings.getEntityBeeLegging(entity);
        if (!beeLeggings.m_41619_()) {
            super.m_7892_(blockState, level, blockPos, entity);
            return;
        }
        VoxelShape voxelShape = this.m_5940_(blockState, (BlockGetter)level, blockPos, null);
        AABB entityBounds = entity.m_20191_().m_82386_((double)(-blockPos.m_123341_()), (double)(-blockPos.m_123342_()), (double)(-blockPos.m_123343_()));
        if (Shapes.m_83157_((VoxelShape)Shapes.m_83064_((AABB)entityBounds), (VoxelShape)voxelShape, (BooleanOp)BooleanOp.f_82689_)) {
            entity.m_7601_(blockState, new Vec3(0.35, (double)0.2f, 0.35));
            if (entity instanceof LivingEntity) {
                Player player;
                LivingEntity livingEntity = (LivingEntity)entity;
                if (!(entity instanceof Player) || !(player = (Player)entity).m_7500_()) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 1, false, false, true));
                }
            }
        }
        super.m_7892_(blockState, level, blockPos, entity);
    }

    public boolean m_7898_(BlockState blockstate, LevelReader world, BlockPos pos) {
        return StickyHoneyResidue.canHaveAtleastOneAttachment(blockstate, world, pos);
    }

    public static boolean canHaveAtleastOneAttachment(BlockState blockstate, LevelReader world, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BooleanProperty booleanproperty = FACING_TO_PROPERTY_MAP.get(direction);
            if (!((Boolean)blockstate.m_61143_((Property)booleanproperty)).booleanValue() || !GeneralUtils.isFaceFullFast((BlockGetter)world, pos.m_121945_(direction), direction.m_122424_())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAtleastOneAttachment(BlockState blockstate) {
        return StickyHoneyResidue.numberOfAttachments(blockstate) > 0;
    }

    private static int numberOfAttachments(BlockState blockstate) {
        int i = 0;
        for (BooleanProperty booleanproperty : FACING_TO_PROPERTY_MAP.values()) {
            if (!((Boolean)blockstate.m_61143_((Property)booleanproperty)).booleanValue()) continue;
            ++i;
        }
        return i;
    }

    private BlockState setAttachments(BlockState blockstate, LevelReader blockReader, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BooleanProperty booleanproperty = FACING_TO_PROPERTY_MAP.get(direction);
            if (!((Boolean)blockstate.m_61143_((Property)booleanproperty)).booleanValue()) continue;
            boolean flag = GeneralUtils.isFaceFullFast((BlockGetter)blockReader, pos.m_121945_(direction), direction.m_122424_());
            blockstate = (BlockState)blockstate.m_61124_((Property)booleanproperty, (Comparable)Boolean.valueOf(flag));
        }
        return blockstate;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState currentBlockstate = context.m_43725_().m_8055_(context.m_8083_());
        boolean isSameBlock = currentBlockstate.m_60734_() == this;
        BlockState newBlockstate = isSameBlock ? currentBlockstate : this.m_49966_();
        for (Direction direction : context.m_6232_()) {
            boolean faceIsAlreadyTrue;
            BooleanProperty booleanproperty = FACING_TO_PROPERTY_MAP.get(direction);
            boolean bl = faceIsAlreadyTrue = isSameBlock && (Boolean)currentBlockstate.m_61143_((Property)booleanproperty) != false;
            if (faceIsAlreadyTrue || !VineBlock.m_57853_((BlockGetter)context.m_43725_(), (BlockPos)context.m_8083_().m_121945_(direction), (Direction)direction)) continue;
            return (BlockState)newBlockstate.m_61124_((Property)booleanproperty, (Comparable)Boolean.valueOf(true));
        }
        return isSameBlock ? newBlockstate : null;
    }

    public BlockState m_7417_(BlockState blockstate, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        BlockState newBlockstate = this.setAttachments(blockstate, (LevelReader)world, currentPos);
        return !StickyHoneyResidue.hasAtleastOneAttachment(newBlockstate) ? Blocks.f_50016_.m_49966_() : newBlockstate;
    }

    public void m_213897_(BlockState blockstate, ServerLevel world, BlockPos currentPos, RandomSource random) {
        super.m_213897_(blockstate, world, currentPos, random);
        BlockState newBlockstate = this.setAttachments(blockstate, (LevelReader)world, currentPos);
        world.m_7731_(currentPos, newBlockstate, 3);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockstate, Level world, BlockPos pos) {
        return StickyHoneyResidue.numberOfAttachments(blockstate);
    }

    public int m_7753_(BlockState state, BlockGetter world, BlockPos pos) {
        return 1;
    }

    public InteractionResult m_6227_(BlockState blockstate, Level world, BlockPos position, Player playerEntity, InteractionHand playerHand, BlockHitResult raytraceResult) {
        ItemStack itemstack = playerEntity.m_21120_(playerHand);
        if (itemstack.m_204117_(BzTags.WASHING_ITEMS) && (!itemstack.m_150930_(Items.f_42589_) || itemstack.m_41783_() != null && itemstack.m_41783_().m_128461_("Potion").contains("water"))) {
            ServerPlayer serverPlayer;
            if (!itemstack.m_41619_()) {
                playerEntity.m_36246_(Stats.f_12982_.m_12902_((Object)itemstack.m_41720_()));
            }
            if (playerEntity instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)playerEntity;
                BzCriterias.CLEANUP_STICKY_HONEY_RESIDUE_TRIGGER.trigger(serverPlayer);
            }
            world.m_46961_(position, false);
            world.m_6263_(playerEntity, playerEntity.m_20185_(), playerEntity.m_20186_(), playerEntity.m_20189_(), BzSounds.WASHING_RESIDUES.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            if (playerEntity instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)playerEntity;
                if (((Boolean)blockstate.m_61143_((Property)UP)).booleanValue()) {
                    ((ServerLevel)world).m_8624_(serverPlayer, (ParticleOptions)ParticleTypes.f_123804_, true, (double)position.m_123341_() + 0.5, (double)position.m_123342_() + 0.95, (double)position.m_123343_() + 0.5, 6, 0.3, 0.0, 0.3, 1.0);
                }
                if (((Boolean)blockstate.m_61143_((Property)NORTH)).booleanValue()) {
                    ((ServerLevel)world).m_8624_(serverPlayer, (ParticleOptions)ParticleTypes.f_123804_, true, (double)position.m_123341_() + 0.5, (double)position.m_123342_() + 0.5, (double)position.m_123343_() + 0.05, 6, 0.3, 0.3, 0.0, 1.0);
                }
                if (((Boolean)blockstate.m_61143_((Property)EAST)).booleanValue()) {
                    ((ServerLevel)world).m_8624_(serverPlayer, (ParticleOptions)ParticleTypes.f_123804_, true, (double)position.m_123341_() + 0.95, (double)position.m_123342_() + 0.5, (double)position.m_123343_() + 0.5, 6, 0.0, 0.3, 0.3, 1.0);
                }
                if (((Boolean)blockstate.m_61143_((Property)SOUTH)).booleanValue()) {
                    ((ServerLevel)world).m_8624_(serverPlayer, (ParticleOptions)ParticleTypes.f_123804_, true, (double)position.m_123341_() + 0.5, (double)position.m_123342_() + 0.5, (double)position.m_123343_() + 0.95, 6, 0.3, 0.3, 0.0, 1.0);
                }
                if (((Boolean)blockstate.m_61143_((Property)WEST)).booleanValue()) {
                    ((ServerLevel)world).m_8624_(serverPlayer, (ParticleOptions)ParticleTypes.f_123804_, true, (double)position.m_123341_() + 0.05, (double)position.m_123342_() + 0.5, (double)position.m_123343_() + 0.5, 6, 0.0, 0.3, 0.3, 1.0);
                }
                if (((Boolean)blockstate.m_61143_((Property)DOWN)).booleanValue()) {
                    ((ServerLevel)world).m_8624_(serverPlayer, (ParticleOptions)ParticleTypes.f_123804_, true, (double)position.m_123341_() + 0.5, (double)position.m_123342_() + 0.05, (double)position.m_123343_() + 0.5, 6, 0.3, 0.0, 0.3, 1.0);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(blockstate, world, position, playerEntity, playerHand, raytraceResult);
    }

    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)blockState.m_61124_((Property)NORTH, (Comparable)((Boolean)blockState.m_61143_((Property)SOUTH)))).m_61124_((Property)EAST, (Comparable)((Boolean)blockState.m_61143_((Property)WEST)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)blockState.m_61143_((Property)NORTH)))).m_61124_((Property)WEST, (Comparable)((Boolean)blockState.m_61143_((Property)EAST)));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)blockState.m_61124_((Property)NORTH, (Comparable)((Boolean)blockState.m_61143_((Property)EAST)))).m_61124_((Property)EAST, (Comparable)((Boolean)blockState.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)blockState.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)blockState.m_61143_((Property)NORTH)));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)blockState.m_61124_((Property)NORTH, (Comparable)((Boolean)blockState.m_61143_((Property)WEST)))).m_61124_((Property)EAST, (Comparable)((Boolean)blockState.m_61143_((Property)NORTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)blockState.m_61143_((Property)EAST)))).m_61124_((Property)WEST, (Comparable)((Boolean)blockState.m_61143_((Property)SOUTH)));
            default -> blockState;
        };
    }

    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        return switch (mirror) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)blockState.m_61124_((Property)NORTH, (Comparable)((Boolean)blockState.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)blockState.m_61143_((Property)NORTH)));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)blockState.m_61124_((Property)EAST, (Comparable)((Boolean)blockState.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)blockState.m_61143_((Property)EAST)));
            default -> super.m_6943_(blockState, mirror);
        };
    }

    public void m_214162_(BlockState blockState, Level world, BlockPos position, RandomSource random) {
        for (int i = 0; i == random.m_188503_(50); ++i) {
            Direction randomDirection = Direction.values()[random.m_188503_(Direction.values().length)];
            if (randomDirection == Direction.DOWN) continue;
            this.addParticle((ParticleOptions)ParticleTypes.f_123779_, random, world, position, blockState, randomDirection);
        }
    }

    protected void addParticle(ParticleOptions particleType, RandomSource random, Level world, BlockPos blockPos, BlockState blockState, Direction direction) {
        short bitFlag = this.getShapeIndex(blockState);
        if ((bitFlag >> direction.ordinal() & 1) != 0) {
            VoxelShape chosenSide = BASE_SHAPES_BY_DIRECTION_ORDINAL[direction.ordinal()];
            this.addParticle(particleType, world, random, (double)blockPos.m_123341_() + chosenSide.m_83288_(Direction.Axis.X), (double)blockPos.m_123341_() + chosenSide.m_83297_(Direction.Axis.X), (double)blockPos.m_123342_() + chosenSide.m_83288_(Direction.Axis.Y), (double)blockPos.m_123342_() + chosenSide.m_83297_(Direction.Axis.Y), (double)blockPos.m_123343_() + chosenSide.m_83288_(Direction.Axis.Z), (double)blockPos.m_123343_() + chosenSide.m_83297_(Direction.Axis.Z));
        }
    }

    private void addParticle(ParticleOptions particleType, Level world, RandomSource random, double xMin, double xMax, double yMin, double yMax, double zMax, double zMin) {
        world.m_7106_(particleType, Mth.m_14139_((double)random.m_188500_(), (double)xMin, (double)xMax), Mth.m_14139_((double)random.m_188500_(), (double)yMin, (double)yMax), Mth.m_14139_((double)random.m_188500_(), (double)zMin, (double)zMax), 0.0, 0.0, 0.0);
    }
}

