/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.google.common.collect.MapMaker;
import com.telepathicgrunt.the_bumblezone.blocks.ProperFacingBlock;
import com.telepathicgrunt.the_bumblezone.mixin.gameplay.ServerGamePacketListenerImplAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzParticles;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzStats;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WindyAir
extends ProperFacingBlock {
    private static final ConcurrentMap<String, Map<Direction, Integer>> APPLIED_PUSH_FOR_ENTITY = new MapMaker().concurrencyLevel(2).weakKeys().makeMap();

    public WindyAir() {
        super(BlockBehaviour.Properties.m_284310_().m_60913_(0.01f, 0.0f).m_60910_().m_280170_().m_222994_().m_60955_().m_278166_(PushReaction.DESTROY));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_52588_, (Comparable)Direction.UP));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[0]).m_61104_(new Property[]{f_52588_});
    }

    public boolean m_7420_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return true;
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return collisionContext.m_7142_(BzItems.WINDY_AIR.get()) ? Shapes.m_83144_() : Shapes.m_83040_();
    }

    public VoxelShape m_5939_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return Shapes.m_83040_();
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.INVISIBLE;
    }

    public float m_7749_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return 1.0f;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)context.m_43719_());
    }

    public void m_7892_(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        Player player;
        if (entity instanceof Player ? (player = (Player)entity).m_7500_() && player.m_150110_().f_35935_ || player.m_5833_() : entity.m_6095_().m_204039_(BzTags.WINDY_AIR_IMMUNE)) {
            return;
        }
        if (APPLIED_PUSH_FOR_ENTITY.size() >= 200) {
            APPLIED_PUSH_FOR_ENTITY.clear();
        }
        if (!APPLIED_PUSH_FOR_ENTITY.containsKey(entity.m_20149_())) {
            APPLIED_PUSH_FOR_ENTITY.put(entity.m_20149_(), new HashMap());
        }
        Direction windDirection = (Direction)blockState.m_61143_((Property)f_52588_);
        if (((Map)APPLIED_PUSH_FOR_ENTITY.get(entity.m_20149_())).getOrDefault(windDirection, -1) == entity.f_19797_) {
            return;
        }
        double strength = windDirection == Direction.UP ? 0.089 : 0.0275;
        double size = entity.m_20191_().m_82309_();
        strength = size <= 1.0 ? (strength *= 1.0 / (size / 2.0 + 0.5)) : (strength *= 1.0 / (size * 2.0));
        if (entity instanceof ItemEntity) {
            strength *= windDirection == Direction.UP ? (double)0.9f : (double)0.7f;
        } else if (entity instanceof Mob) {
            strength *= windDirection == Direction.UP ? 2.0 : (double)0.7f;
        }
        Vec3 pushPower = Vec3.m_82528_((Vec3i)windDirection.m_122436_()).m_82490_(strength);
        Vec3 newVelocity = entity.m_20184_();
        if (entity instanceof ItemEntity) {
            newVelocity = newVelocity.m_82549_(newVelocity.m_82490_((double)-0.15f));
        }
        newVelocity = newVelocity.m_82549_(pushPower);
        if (!entity.m_20096_() && newVelocity.m_7098_() < 0.0 && windDirection != Direction.DOWN) {
            newVelocity = newVelocity.m_82520_(0.0, -newVelocity.m_7098_() + (double)0.04f, 0.0);
        }
        if (windDirection == Direction.UP && newVelocity.m_7098_() > -0.05) {
            entity.f_19789_ = 0.0f;
        }
        entity.m_20256_(newVelocity);
        ((Map)APPLIED_PUSH_FOR_ENTITY.get(entity.m_20149_())).put(windDirection, entity.f_19797_);
        if (entity instanceof Player) {
            Player player2 = (Player)entity;
            player2.m_36220_(BzStats.WINDY_AIR_TIME_RL.get());
        }
        if (windDirection != Direction.DOWN && entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            ((ServerGamePacketListenerImplAccessor)serverPlayer.f_8906_).bumblezone$setAboveGroundTickCount(0);
            ((ServerGamePacketListenerImplAccessor)serverPlayer.f_8906_).bumblezone$setAboveGroundVehicleTickCount(0);
        }
    }

    public void m_214162_(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        if (randomSource.m_188501_() < 0.25f) {
            Direction windDirection = (Direction)blockState.m_61143_((Property)f_52588_);
            double strength = 0.1;
            Vec3 pushPower = Vec3.m_82528_((Vec3i)windDirection.m_122436_()).m_82490_(strength);
            level.m_7106_((ParticleOptions)BzParticles.WIND_PARTICLE.get(), (double)blockPos.m_123341_() + randomSource.m_188500_(), (double)blockPos.m_123342_() + randomSource.m_188500_(), (double)blockPos.m_123343_() + randomSource.m_188500_(), pushPower.m_7096_() + randomSource.m_188583_() * 0.003, pushPower.m_7098_() + randomSource.m_188583_() * 0.003, pushPower.m_7094_() + randomSource.m_188583_() * 0.003);
            Player nearestPlayer = level.m_45924_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 3.0, true);
            if (nearestPlayer != null) {
                level.m_5594_(null, blockPos, BzSounds.WINDY_AIR_BLOWS.get(), SoundSource.AMBIENT, randomSource.m_188501_() * 0.05f + 0.5f, randomSource.m_188501_() * 0.1f + 0.8f);
            }
        }
    }

    protected void m_142387_(Level level, Player player, BlockPos blockPos, BlockState blockState) {
        VoxelShape voxelshape = Shapes.m_83144_();
        voxelshape.m_83286_((x1, y1, z1, x2, y2, z2) -> {
            double d1 = Math.min(1.0, x2 - x1);
            double d2 = Math.min(1.0, y2 - y1);
            double d3 = Math.min(1.0, z2 - z1);
            int i = Math.max(2, Mth.m_14165_((double)(d1 / 0.25)));
            int j = Math.max(2, Mth.m_14165_((double)(d2 / 0.25)));
            int k = Math.max(2, Mth.m_14165_((double)(d3 / 0.25)));
            for (int x = 0; x < i; ++x) {
                for (int y = 0; y < j; ++y) {
                    for (int z = 0; z < k; ++z) {
                        double d4 = ((double)x + 0.5) / (double)i;
                        double d5 = ((double)y + 0.5) / (double)j;
                        double d6 = ((double)z + 0.5) / (double)k;
                        double d7 = d4 * d1 + x1;
                        double d8 = d5 * d2 + y1;
                        double d9 = d6 * d3 + z1;
                        level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), (double)blockPos.m_123341_() + d7, (double)blockPos.m_123342_() + d8, (double)blockPos.m_123343_() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5);
                    }
                }
            }
        });
    }
}

