/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.pileofpollen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.telepathicgrunt.the_bumblezone.events.client.BlockRenderedOnScreenEvent;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class PileOfPollenRenderer {
    private static final ResourceLocation TEXTURE_POLLEN = new ResourceLocation("the_bumblezone", "textures/block/pile_of_pollen/pile_of_pollen.png");
    private static final ResourceLocation TEXTURE_POLLEN_SUSPICIOUS = new ResourceLocation("the_bumblezone", "textures/block/pile_of_pollen/pile_of_pollen_suspicious_1.png");

    public static boolean pileOfPollenOverlay(BlockRenderedOnScreenEvent event) {
        BlockState blockState = event.state();
        if (event.type().equals((Object)BlockRenderedOnScreenEvent.Type.BLOCK) && blockState.m_204336_(BzTags.POLLEN_BLOCKS)) {
            Player playerEntity = event.player();
            PoseStack matrixStack = event.stack();
            boolean isInPollen = false;
            for (int x = -1; x <= 1; ++x) {
                block1: for (int z = -1; z <= 1; ++z) {
                    for (int y = -1; y <= 1; ++y) {
                        if (x * x + y * y + z * z <= 2) continue;
                        double eyePosX = playerEntity.m_20185_() + (double)((float)x * playerEntity.m_20205_() * 0.155f);
                        double eyePosY = playerEntity.m_20188_() + (double)((float)y * 0.12f);
                        double eyePosZ = playerEntity.m_20189_() + (double)((float)z * playerEntity.m_20205_() * 0.155f);
                        Vec3 eyePosition = new Vec3(eyePosX, eyePosY, eyePosZ);
                        BlockPos eyeBlockPos = BlockPos.m_274446_((Position)eyePosition);
                        BlockState eyeBlock = playerEntity.m_9236_().m_8055_(eyeBlockPos);
                        VoxelShape blockBounds = eyeBlock.m_60808_((BlockGetter)playerEntity.m_9236_(), eyeBlockPos);
                        if (blockBounds.m_83281_()) continue;
                        Vec3 eyePos = eyePosition.m_82546_(Vec3.m_82528_((Vec3i)eyeBlockPos));
                        if (!blockBounds.m_83215_().m_82390_(eyePos)) continue;
                        isInPollen = true;
                        x = 2;
                        z = 2;
                        continue block1;
                    }
                }
            }
            if (!isInPollen) {
                return true;
            }
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)(blockState.m_60713_(BzBlocks.PILE_OF_POLLEN_SUSPICIOUS.get()) ? TEXTURE_POLLEN_SUSPICIOUS : TEXTURE_POLLEN));
            BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            float opacity = 1.0f;
            float brightness = 0.3f;
            float redStrength = 1.0f;
            float greenStrength = 0.9f;
            float blueStrength = 0.8f;
            RenderSystem.setShaderColor((float)(brightness * redStrength), (float)(brightness * greenStrength), (float)(brightness * blueStrength), (float)opacity);
            float pitch = -playerEntity.m_146908_() / 64.0f;
            float yaw = playerEntity.m_146909_() / 64.0f;
            float yawPlus4 = 4.0f + yaw;
            float pitchPlus4 = 4.0f + pitch;
            float movementScaling = 0.85f;
            Vector3f playerPosition = playerEntity.m_20182_().m_82542_((double)movementScaling, (double)movementScaling, (double)movementScaling).m_252839_();
            float smallXZOffset = playerPosition.x() * playerPosition.z() * 0.0f;
            float smallYOffset = playerPosition.y() * 0.33f;
            Matrix4f matrix4f = matrixStack.m_85850_().m_252922_();
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferbuilder.m_252986_(matrix4f, -1.0f, -1.0f, -0.5f).m_7421_(pitchPlus4 - smallXZOffset, yawPlus4 - playerPosition.y()).m_5752_();
            bufferbuilder.m_252986_(matrix4f, 1.0f, -1.0f, -0.5f).m_7421_(pitch - smallXZOffset, yawPlus4 - playerPosition.y()).m_5752_();
            bufferbuilder.m_252986_(matrix4f, 1.0f, 1.0f, -0.5f).m_7421_(pitch - smallXZOffset, yaw - playerPosition.y()).m_5752_();
            bufferbuilder.m_252986_(matrix4f, -1.0f, 1.0f, -0.5f).m_7421_(pitchPlus4 - smallXZOffset, yaw - playerPosition.y()).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            RenderSystem.setShaderColor((float)(brightness * redStrength), (float)(brightness * greenStrength), (float)(brightness * blueStrength), (float)(opacity * 0.33f));
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferbuilder.m_252986_(matrix4f, -1.0f, -1.0f, -0.5f).m_7421_(pitchPlus4 - playerPosition.x(), yawPlus4 - smallYOffset).m_5752_();
            bufferbuilder.m_252986_(matrix4f, 1.0f, -1.0f, -0.5f).m_7421_(pitch - playerPosition.x(), yawPlus4 - smallYOffset).m_5752_();
            bufferbuilder.m_252986_(matrix4f, 1.0f, 1.0f, -0.5f).m_7421_(pitch - playerPosition.x(), yaw - smallYOffset).m_5752_();
            bufferbuilder.m_252986_(matrix4f, -1.0f, 1.0f, -0.5f).m_7421_(pitchPlus4 - playerPosition.x(), yaw - smallYOffset).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            RenderSystem.setShaderColor((float)(brightness * redStrength), (float)(brightness * greenStrength), (float)(brightness * blueStrength), (float)(opacity * 0.33f));
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferbuilder.m_252986_(matrix4f, -1.0f, -1.0f, -0.5f).m_7421_(pitchPlus4 - playerPosition.z(), yawPlus4 - smallYOffset).m_5752_();
            bufferbuilder.m_252986_(matrix4f, 1.0f, -1.0f, -0.5f).m_7421_(pitch - playerPosition.z(), yawPlus4 - smallYOffset).m_5752_();
            bufferbuilder.m_252986_(matrix4f, 1.0f, 1.0f, -0.5f).m_7421_(pitch - playerPosition.z(), yaw - smallYOffset).m_5752_();
            bufferbuilder.m_252986_(matrix4f, -1.0f, 1.0f, -0.5f).m_7421_(pitchPlus4 - playerPosition.z(), yaw - smallYOffset).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            RenderSystem.disableBlend();
            return true;
        }
        return false;
    }
}

