/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.purplespike;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.telepathicgrunt.the_bumblezone.client.rendering.purplespike.PurpleSpikeModel;
import com.telepathicgrunt.the_bumblezone.entities.nonliving.PurpleSpikeEntity;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class PurpleSpikeRenderer<M extends EntityModel<PurpleSpikeEntity>>
extends EntityRenderer<PurpleSpikeEntity>
implements RenderLayerParent<PurpleSpikeEntity, M> {
    private static final ResourceLocation SKIN = new ResourceLocation("the_bumblezone", "textures/entity/purple_spike.png");
    protected final PurpleSpikeModel<PurpleSpikeEntity> model;
    protected final List<RenderLayer<PurpleSpikeEntity, M>> layers = Lists.newArrayList();

    public PurpleSpikeRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new PurpleSpikeModel(context.m_174023_(PurpleSpikeModel.LAYER_LOCATION));
    }

    protected final boolean addLayer(RenderLayer<PurpleSpikeEntity, M> renderLayer) {
        return this.layers.add(renderLayer);
    }

    public M m_7200_() {
        return (M)((Object)this.model);
    }

    public void render(PurpleSpikeEntity ringEntity, float f, float g, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        poseStack.m_85836_();
        float m = Mth.m_14179_((float)g, (float)ringEntity.f_19860_, (float)ringEntity.m_146909_());
        float offSet = 1.0f + Math.min((float)ringEntity.spikeChargeClientTimeTracker / 40.0f, 0.5f);
        poseStack.m_85841_(1.0f, 1.0f, 1.0f);
        poseStack.m_252880_(0.0f, offSet, 0.0f);
        poseStack.m_252781_(Axis.f_252392_.m_252977_(180.0f - ringEntity.m_146908_()));
        poseStack.m_252781_(Axis.f_252495_.m_252977_(180.0f - ringEntity.m_146909_()));
        this.model.m_6839_(ringEntity, 0.0f, 0.0f, g);
        this.model.m_6973_(ringEntity, 0.0f, 0.0f, 0.0f, 0.0f, m);
        Minecraft minecraft = Minecraft.m_91087_();
        boolean bl = this.isBodyVisible(ringEntity);
        boolean bl2 = !bl && !ringEntity.m_20177_((Player)minecraft.f_91074_);
        boolean bl3 = minecraft.m_91314_((Entity)ringEntity);
        RenderType renderType = this.getRenderType(ringEntity, bl, bl2, bl3);
        if (renderType != null) {
            VertexConsumer vertexConsumer = multiBufferSource.m_6299_(renderType);
            this.model.m_7695_(poseStack, vertexConsumer, i, 0, 1.0f, 1.0f, 1.0f, bl2 ? 0.15f : 1.0f);
        }
        if (!ringEntity.m_5833_()) {
            for (RenderLayer<PurpleSpikeEntity, M> renderLayer : this.layers) {
                renderLayer.m_6494_(poseStack, multiBufferSource, i, (Entity)ringEntity, 0.0f, 0.0f, g, 0.0f, 0.0f, m);
            }
        }
        poseStack.m_85849_();
    }

    @Nullable
    protected RenderType getRenderType(PurpleSpikeEntity ringEntity, boolean bl, boolean bl2, boolean bl3) {
        ResourceLocation resourceLocation = this.getTextureLocation(ringEntity);
        if (bl2) {
            return RenderType.m_110467_((ResourceLocation)resourceLocation);
        }
        if (bl) {
            return this.model.m_103119_(resourceLocation);
        }
        if (bl3) {
            return RenderType.m_110491_((ResourceLocation)resourceLocation);
        }
        return null;
    }

    protected boolean isBodyVisible(PurpleSpikeEntity ringEntity) {
        return !ringEntity.m_20145_();
    }

    public ResourceLocation getTextureLocation(PurpleSpikeEntity ringEntity) {
        return SKIN;
    }
}

