/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.rootmin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.telepathicgrunt.the_bumblezone.client.rendering.rootmin.RootminModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.rootmin.RootminRenderer;
import com.telepathicgrunt.the_bumblezone.entities.mobs.RootminEntity;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;

public class RootminGrassRenderer
extends RenderLayer<RootminEntity, RootminModel> {
    private static final ResourceLocation GRASS = new ResourceLocation("the_bumblezone", "textures/entity/rootmin_grass.png");
    private final RootminRenderer renderLayerParent;

    public RootminGrassRenderer(RootminRenderer renderLayerParent, EntityModelSet entityModelSet) {
        super((RenderLayerParent)renderLayerParent);
        this.renderLayerParent = renderLayerParent;
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, RootminEntity entity, float f, float g, float partialTicks, float j, float k, float l) {
        poseStack.m_85836_();
        this.renderGrassBodyTop(entity, partialTicks, poseStack, multiBufferSource, packedLight);
        poseStack.m_85849_();
    }

    private void renderGrassBodyTop(RootminEntity rootminEntity, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        boolean bl3;
        boolean bl;
        Minecraft minecraft = Minecraft.m_91087_();
        boolean bl2 = !(bl = this.renderLayerParent.isBodyVisible(rootminEntity)) && !rootminEntity.m_20177_((Player)minecraft.f_91074_);
        RenderType renderType = this.getRenderTypeGrass(bl, bl2, bl3 = minecraft.m_91314_((Entity)rootminEntity));
        if (renderType != null) {
            VertexConsumer vertexConsumer = buffer.m_6299_(renderType);
            int p = LivingEntityRenderer.m_115338_((LivingEntity)rootminEntity, (float)this.renderLayerParent.getWhiteOverlayProgress(rootminEntity, partialTicks));
            if (rootminEntity.m_8077_() && "jeb_".equals(rootminEntity.m_7755_().getString())) {
                int speed = 25;
                int offset = rootminEntity.f_19797_ / speed + rootminEntity.m_19879_();
                int dyeColors = DyeColor.values().length;
                int firstDye = offset % dyeColors;
                int secondDye = (offset + 1) % dyeColors;
                float theColorThingy = ((float)(rootminEntity.f_19797_ % speed) + partialTicks) / 25.0f;
                float[] fs = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)firstDye));
                float[] gs = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)secondDye));
                float red = fs[0] * (1.0f - theColorThingy) + gs[0] * theColorThingy;
                float green = fs[1] * (1.0f - theColorThingy) + gs[1] * theColorThingy;
                float blue = fs[2] * (1.0f - theColorThingy) + gs[2] * theColorThingy;
                this.renderLayerParent.m_7200_().m_7695_(stack, vertexConsumer, packedLight, p, red, green, blue, bl2 ? 0.15f : 1.0f);
            } else {
                int biomeColor = rootminEntity.m_9236_().m_6171_(rootminEntity.m_20183_(), BiomeColors.f_108789_);
                this.renderLayerParent.m_7200_().m_7695_(stack, vertexConsumer, packedLight, p, (float)GeneralUtils.getRed(biomeColor) / 255.0f, (float)GeneralUtils.getGreen(biomeColor) / 255.0f, (float)GeneralUtils.getBlue(biomeColor) / 255.0f, bl2 ? 0.15f : 1.0f);
            }
        }
    }

    protected RenderType getRenderTypeGrass(boolean bl, boolean bl2, boolean bl3) {
        if (bl2) {
            return RenderType.m_110467_((ResourceLocation)GRASS);
        }
        if (bl) {
            return ((RootminModel)this.renderLayerParent.m_7200_()).m_103119_(GRASS);
        }
        if (bl3) {
            return RenderType.m_110491_((ResourceLocation)GRASS);
        }
        return null;
    }

    protected float xOffset(float f) {
        return f * 0.01f;
    }

    protected ResourceLocation getTextureLocation() {
        return GRASS;
    }

    protected EntityModel<RootminEntity> model() {
        return this.renderLayerParent.m_7200_();
    }
}

