/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.enchantments;

import com.telepathicgrunt.the_bumblezone.events.player.PlayerBreakSpeedEvent;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzEnchantments;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.platform.BzEnchantment;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.utils.OptionalBoolean;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;

public class CombCutterEnchantment
extends BzEnchantment {
    private static final GeneralUtils.Lazy<Set<Block>> TARGET_BLOCKS = new GeneralUtils.Lazy();
    private static final GeneralUtils.Lazy<Set<Block>> LESSER_TARGET_BLOCKS = new GeneralUtils.Lazy();

    public CombCutterEnchantment() {
        super(Enchantment.Rarity.RARE, EnchantmentCategory.BREAKABLE, new EquipmentSlot[]{EquipmentSlot.MAINHAND});
    }

    public Set<Block> getTargetBlocks() {
        return TARGET_BLOCKS.getOrCompute(() -> {
            HashSet<Block> validBlocks = new HashSet<Block>();
            for (ResourceLocation key : BuiltInRegistries.f_256975_.m_6566_()) {
                String path = key.m_135815_();
                if (!path.contains("comb") && !path.contains("luminescent_wax") && !path.contains("ancient_wax")) continue;
                validBlocks.add((Block)BuiltInRegistries.f_256975_.m_7745_(key));
            }
            return validBlocks;
        });
    }

    public Set<Block> getLesserTargetBlocks() {
        return LESSER_TARGET_BLOCKS.getOrCompute(() -> {
            HashSet<Block> validBlocks = new HashSet<Block>();
            for (ResourceLocation key : BuiltInRegistries.f_256975_.m_6566_()) {
                String path = key.m_135815_();
                Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(key);
                if (!(block instanceof BeehiveBlock) && !path.contains("hive") && !path.contains("nest") && (!path.contains("wax") || path.contains("waxed"))) continue;
                validBlocks.add(block);
            }
            return validBlocks;
        });
    }

    public static void attemptFasterMining(PlayerBreakSpeedEvent event) {
        if (BzEnchantments.COMB_CUTTER.get().getTargetBlocks().contains(event.state().m_60734_())) {
            CombCutterEnchantment.mineFaster(event, false);
        } else if (BzEnchantments.COMB_CUTTER.get().getLesserTargetBlocks().contains(event.state().m_60734_())) {
            CombCutterEnchantment.mineFaster(event, true);
        }
    }

    private static void mineFaster(PlayerBreakSpeedEvent event, boolean lesserTarget) {
        Player playerEntity = event.player();
        ItemStack itemStack = playerEntity.m_21205_();
        int equipmentLevel = EnchantmentHelper.m_44836_((Enchantment)BzEnchantments.COMB_CUTTER.get(), (LivingEntity)playerEntity);
        if (equipmentLevel > 0 && !itemStack.m_41619_()) {
            int destroyModifier = (int)Math.max(Math.ceil(event.state().m_60734_().m_155943_()), 0.0);
            double newSpeed = Math.min(Math.pow(equipmentLevel, 2 + destroyModifier) + (double)(lesserTarget ? 3 : 13), 50.0);
            if (playerEntity.m_21023_(MobEffects.f_19599_)) {
                int amplifier = playerEntity.m_21124_(MobEffects.f_19599_).m_19564_();
                if (amplifier < 0) {
                    amplifier = 3;
                }
                newSpeed /= (Math.pow(amplifier, 6.0) + 2.0) * 20.0;
            }
            event.speed().addAndGet(newSpeed);
        }
    }

    public static void increasedCombDrops(Player playerEntity, Level world, BlockPos pos) {
        ItemStack itemStack = playerEntity.m_21205_();
        int equipmentLevel = EnchantmentHelper.m_44836_((Enchantment)BzEnchantments.COMB_CUTTER.get(), (LivingEntity)playerEntity);
        if (equipmentLevel > 0 && !itemStack.m_41619_()) {
            Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.f_42784_, equipmentLevel * 3));
            if (playerEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)playerEntity;
                BzCriterias.COMB_CUTTER_EXTRA_DROPS_TRIGGER.trigger(serverPlayer);
            }
        }
    }

    public int m_6183_(int level) {
        return 1 + 55 * (level - 1);
    }

    public int m_6175_(int level) {
        return super.m_6183_(level) + 23;
    }

    public int m_6586_() {
        return 2;
    }

    public boolean m_6081_(ItemStack stack) {
        return stack.m_204117_(BzTags.ENCHANTABLE_COMB_CUTTER) || stack.m_150930_(Items.f_42517_);
    }

    @Override
    public OptionalBoolean bz$canApplyAtEnchantingTable(ItemStack stack) {
        return OptionalBoolean.of(this.m_6081_(stack));
    }
}

