/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.goals;

import com.telepathicgrunt.the_bumblezone.client.rendering.rootmin.RootminPose;
import com.telepathicgrunt.the_bumblezone.entities.mobs.RootminEntity;
import com.telepathicgrunt.the_bumblezone.items.BeeArmor;
import com.telepathicgrunt.the_bumblezone.items.FlowerHeadwearHelmet;
import java.util.EnumSet;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.phys.AABB;

public class RootminCuriosityGoal
extends Goal {
    protected final RootminEntity mob;
    protected final TargetingConditions targetConditions;
    protected boolean isCuriousNow = false;
    protected LivingEntity inspect = null;
    protected int exposingTiming = 0;
    protected int curiosityWaiting = 0;

    public RootminCuriosityGoal(RootminEntity pathfinderMob) {
        this.mob = pathfinderMob;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.targetConditions = TargetingConditions.m_148352_().m_26883_(this.mob.m_21133_(Attributes.f_22277_)).m_26888_(null);
    }

    protected AABB getTargetSearchArea(double d) {
        return this.mob.m_20191_().m_82377_(d, 4.0, d);
    }

    public boolean m_8036_() {
        if (this.mob.getRootminPose() != RootminPose.ENTITY_TO_BLOCK || this.mob.animationTimeBetweenHiding != 0) {
            return false;
        }
        if (this.mob.m_5448_() != null) {
            return false;
        }
        if (this.mob.curiosityCooldown > 0) {
            return false;
        }
        if (this.mob.m_20148_().getLeastSignificantBits() + (long)(this.mob.f_19797_ % 20) != 0L) {
            return false;
        }
        double seeRange = this.mob.m_21133_(Attributes.f_22277_);
        this.inspect = this.mob.m_9236_().m_45982_(this.mob.m_9236_().m_6443_(LivingEntity.class, this.getTargetSearchArea(seeRange), livingEntity -> BeeArmor.getBeeThemedWearablesCount((Entity)livingEntity) > 0 || !FlowerHeadwearHelmet.getFlowerHeadwear((Entity)livingEntity).m_41619_()), this.targetConditions, (LivingEntity)this.mob, this.mob.m_20185_(), this.mob.m_20188_(), this.mob.m_20189_());
        if (this.inspect == null) {
            return false;
        }
        return this.inspect.m_20280_((Entity)this.mob) <= 1024.0;
    }

    public boolean m_8045_() {
        return !(this.mob.m_21224_() || this.inspect == null || this.inspect.m_21224_() || this.isCuriousNow && this.curiosityWaiting <= 0 && this.mob.getRootminPose() != RootminPose.CURIOUS || BeeArmor.getBeeThemedWearablesCount((Entity)this.inspect) <= 0 && FlowerHeadwearHelmet.getFlowerHeadwear((Entity)this.inspect).m_41619_() || this.mob.m_20183_().m_123333_((Vec3i)this.inspect.m_20183_()) >= 32);
    }

    public void m_8056_() {
        if (this.mob.getRootminPose() == RootminPose.ENTITY_TO_BLOCK) {
            this.mob.exposeFromBlock();
            this.exposingTiming = 20;
        }
        this.curiosityWaiting = 0;
        this.isCuriousNow = false;
    }

    public void m_8041_() {
        this.mob.curiosityCooldown = 600;
        this.mob.exposedTimer = 0;
        this.exposingTiming = 0;
        this.curiosityWaiting = 0;
        this.mob.setRootminPose(RootminPose.NONE);
    }

    public void m_8037_() {
        if (this.exposingTiming > 0) {
            --this.exposingTiming;
        } else if (this.curiosityWaiting > 0) {
            --this.curiosityWaiting;
            this.mob.m_21391_((Entity)this.inspect, 60.0f, 30.0f);
        } else if (!this.isCuriousNow) {
            if (this.mob.m_20280_((Entity)this.inspect) < 25.0) {
                this.mob.m_21573_().m_26573_();
                this.isCuriousNow = true;
                this.mob.runCurious();
                this.curiosityWaiting = 60;
            } else {
                this.mob.m_21573_().m_5624_((Entity)this.inspect, 1.0);
            }
        }
    }
}

