/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.mobs;

import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class VariantBeeEntity
extends Bee {
    private static final EntityDataAccessor<String> VARIANT = SynchedEntityData.m_135353_(VariantBeeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final String VARIANT_TAG = "variant";

    public VariantBeeEntity(Level worldIn) {
        super(BzEntities.VARIANT_BEE.get(), worldIn);
    }

    public VariantBeeEntity(EntityType<? extends VariantBeeEntity> type, Level worldIn) {
        super(type, worldIn);
        this.getVariant();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.m_148772_().m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0, Bee.class));
    }

    public boolean m_7848_(Animal animal) {
        if (animal.getClass().equals(Bee.class)) {
            return this.m_27593_() && animal.m_27593_();
        }
        return super.m_7848_(animal);
    }

    public String getVariant() {
        String variant = (String)this.f_19804_.m_135370_(VARIANT);
        if (!(this.m_9236_().m_5776_() || variant != null && !variant.isEmpty() || BzGeneralConfigs.variantBeeTypes.isEmpty())) {
            variant = BzGeneralConfigs.variantBeeTypes.get(this.f_19796_.m_188503_(BzGeneralConfigs.variantBeeTypes.size()));
            this.setVariant(variant);
        }
        return variant;
    }

    public void setVariant(String variant) {
        if (!(this.m_9236_().m_5776_() || variant != null && !variant.isEmpty() || BzGeneralConfigs.variantBeeTypes.isEmpty())) {
            variant = BzGeneralConfigs.variantBeeTypes.get(this.f_19796_.m_188503_(BzGeneralConfigs.variantBeeTypes.size()));
        }
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)"");
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128359_(VARIANT_TAG, this.getVariant());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setVariant(compoundTag.m_128461_(VARIANT_TAG));
    }

    public Bee m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        if (ageableMob instanceof VariantBeeEntity) {
            VariantBeeEntity variantBeeEntity = (VariantBeeEntity)ageableMob;
            VariantBeeEntity babyBee = (VariantBeeEntity)BzEntities.VARIANT_BEE.get().m_20615_((Level)serverLevel);
            if (babyBee != null) {
                babyBee.setVariant(this.f_19796_.m_188499_() ? variantBeeEntity.getVariant() : this.getVariant());
            }
            return babyBee;
        }
        if (ageableMob instanceof Bee) {
            if (this.f_19796_.m_188499_()) {
                VariantBeeEntity babyBee = (VariantBeeEntity)BzEntities.VARIANT_BEE.get().m_20615_((Level)serverLevel);
                if (babyBee != null) {
                    babyBee.setVariant(this.getVariant());
                }
                return babyBee;
            }
            return (Bee)EntityType.f_20550_.m_20615_((Level)serverLevel);
        }
        return (Bee)BzEntities.VARIANT_BEE.get().m_20615_((Level)serverLevel);
    }

    public void m_7601_(BlockState blockState, Vec3 speedMult) {
        if (blockState.m_60734_() instanceof SweetBerryBushBlock) {
            return;
        }
        super.m_7601_(blockState, speedMult);
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource == this.m_9236_().m_269111_().m_269555_()) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    protected Component m_5677_() {
        if (this.getVariant() != null) {
            return Component.m_237115_((String)("buzzing_briefcase.the_bumblezone.bee_typing." + this.getVariant()));
        }
        return this.m_6095_().m_20676_();
    }
}

