/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.nonliving;

import com.telepathicgrunt.the_bumblezone.blocks.blockentities.EssenceBlockEntity;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.modinit.BzDamageSources;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class PurpleSpikeEntity
extends Entity {
    private static final EntityDataAccessor<Boolean> DATA_ID_SPIKE_CHARGE = SynchedEntityData.m_135353_(PurpleSpikeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_ID_SPIKE_ACTIVE = SynchedEntityData.m_135353_(PurpleSpikeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int spikeChargeTimer = 0;
    public int spikeTimer = 0;
    public boolean spikeChargeClientPhaseTracker = false;
    public int spikeChargeClientTimeTracker = 0;
    private UUID essenceController = null;
    private BlockPos essenceControllerBlockPos = null;
    private ResourceKey<Level> essenceControllerDimension = null;

    public PurpleSpikeEntity(EntityType<? extends PurpleSpikeEntity> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ID_SPIKE_CHARGE, (Object)(this.spikeChargeTimer > 0 ? 1 : 0));
        this.f_19804_.m_135372_(DATA_ID_SPIKE_ACTIVE, (Object)(this.spikeTimer > 0 ? 1 : 0));
    }

    public UUID getEssenceController() {
        return this.essenceController;
    }

    public void setEssenceController(UUID essenceController) {
        this.essenceController = essenceController;
    }

    public BlockPos getEssenceControllerBlockPos() {
        return this.essenceControllerBlockPos;
    }

    public void setEssenceControllerBlockPos(BlockPos essenceControllerBlockPos) {
        this.essenceControllerBlockPos = essenceControllerBlockPos;
    }

    public ResourceKey<Level> getEssenceControllerDimension() {
        return this.essenceControllerDimension;
    }

    public void setEssenceControllerDimension(ResourceKey<Level> essenceControllerDimension) {
        this.essenceControllerDimension = essenceControllerDimension;
    }

    public boolean hasSpikeCharge() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_SPIKE_CHARGE);
    }

    protected void setHasSpikeCharge(boolean hasSpikeCharge) {
        this.f_19804_.m_135381_(DATA_ID_SPIKE_CHARGE, (Object)hasSpikeCharge);
    }

    public boolean hasSpike() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_SPIKE_ACTIVE);
    }

    protected void setHasSpike(boolean hasSpike) {
        this.f_19804_.m_135381_(DATA_ID_SPIKE_ACTIVE, (Object)hasSpike);
    }

    public int getSpikeChargeTimer() {
        return this.spikeChargeTimer;
    }

    public void setSpikeChargeTimer(int spikeChargeTimer) {
        if (this.getSpikeTimer() > 0 && this.spikeChargeTimer == 0) {
            this.addSpikeTimer(spikeChargeTimer);
            return;
        }
        this.spikeChargeTimer = spikeChargeTimer;
    }

    public int getSpikeTimer() {
        return this.spikeTimer;
    }

    public void setSpikeTimer(int spikeTimer) {
        this.spikeTimer = spikeTimer;
    }

    public void addSpikeTimer(int spikeTimer) {
        this.spikeTimer += spikeTimer;
    }

    protected float m_6380_(Pose pose, EntityDimensions entityDimensions) {
        return 0.0f;
    }

    public void m_8119_() {
        List list;
        super.m_8119_();
        boolean hasSpikeCharge = this.hasSpikeCharge();
        boolean hasSpike = this.hasSpike();
        if (this.m_9236_().m_5776_()) {
            if (this.f_19797_ % 2 == 0 && !hasSpikeCharge && hasSpike) {
                this.makeParticle(1, false);
            }
            if (this.spikeChargeClientPhaseTracker != hasSpikeCharge) {
                if (!this.spikeChargeClientPhaseTracker && hasSpike) {
                    this.spikeChargeClientTimeTracker = 0;
                }
                this.spikeChargeClientPhaseTracker = hasSpikeCharge;
            }
            this.spikeChargeClientTimeTracker = !hasSpikeCharge && !hasSpike ? 0 : ++this.spikeChargeClientTimeTracker;
        } else {
            this.setHasSpike(this.getSpikeTimer() > 0);
            this.setHasSpikeCharge(this.getSpikeChargeTimer() > 0);
            if (this.spikeChargeTimer > 0) {
                --this.spikeChargeTimer;
            } else if (this.spikeTimer > 0) {
                --this.spikeTimer;
            }
        }
        if (hasSpike && !hasSpikeCharge && this.f_19797_ % 3 == 0 && !(list = this.m_9236_().m_45933_((Entity)this, this.m_20191_())).isEmpty()) {
            for (Entity entity : list) {
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    if (!this.m_9236_().m_5776_()) {
                        float damageAmount;
                        float maxHealth = Math.max(livingEntity.m_21223_(), livingEntity.m_21233_());
                        if (livingEntity instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                            if (serverPlayer.m_7500_()) continue;
                            damageAmount = EssenceOfTheBees.hasEssence(serverPlayer) ? maxHealth / 5.0f : maxHealth / 3.0f;
                        } else {
                            damageAmount = maxHealth / 10.0f;
                        }
                        livingEntity.m_6469_(this.m_9236_().m_269111_().m_269298_(BzDamageSources.SPIKE_TYPE, (Entity)this), damageAmount);
                        for (MobEffect mobEffect : new HashSet(livingEntity.m_21221_().keySet())) {
                            if (!mobEffect.m_19486_()) continue;
                            livingEntity.m_21195_(mobEffect);
                        }
                        livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200, 1, true, true, true));
                    }
                    this.makeParticle(1, true);
                    continue;
                }
                if (entity instanceof ItemEntity) continue;
                entity.m_6469_(this.m_9236_().m_269111_().m_269298_(BzDamageSources.SPIKE_TYPE, (Entity)this), 1.0f);
                this.makeParticle(1, true);
            }
        }
        if (!this.m_9236_().m_5776_() && this.f_19797_ % 20 == 0) {
            this.checkIfStillInEvent();
        }
    }

    private void checkIfStillInEvent() {
        UUID essenceUuid = this.getEssenceController();
        ResourceKey<Level> essenceDimension = this.getEssenceControllerDimension();
        BlockPos essenceBlockPos = this.getEssenceControllerBlockPos();
        if (essenceBlockPos == null || essenceUuid == null || essenceDimension == null) {
            return;
        }
        BlockPos blockPos = this.m_20183_();
        EssenceBlockEntity essenceBlockEntity = EssenceBlockEntity.getEssenceBlockAtLocation(this.m_9236_(), essenceDimension, essenceBlockPos, essenceUuid);
        if (essenceBlockEntity != null) {
            BlockPos arenaSize = essenceBlockEntity.getArenaSize();
            if (Math.abs(blockPos.m_123341_() - essenceBlockPos.m_123341_()) > arenaSize.m_123341_() / 2 || Math.abs(blockPos.m_123342_() - essenceBlockPos.m_123342_()) > arenaSize.m_123342_() / 2 || Math.abs(blockPos.m_123343_() - essenceBlockPos.m_123343_()) > arenaSize.m_123343_() / 2) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        } else {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void m_6075_() {
    }

    private void makeParticle(int particlesToSpawn, boolean hit) {
        block4: {
            if (particlesToSpawn <= 0) break block4;
            if (hit) {
                Vec3 center = this.m_20183_().m_252807_();
                for (int i = 0; i < particlesToSpawn; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123797_, center.m_7096_(), center.m_7098_() - 0.5, center.m_7094_(), (double)(this.f_19796_.m_188501_() - 0.5f), (double)(this.f_19796_.m_188501_() + 0.5f), (double)(this.f_19796_.m_188501_() - 0.5f));
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123798_, center.m_7096_(), center.m_7098_() - 0.5, center.m_7094_(), (double)(this.f_19796_.m_188501_() - 0.5f), (double)(this.f_19796_.m_188501_() + 0.5f), (double)(this.f_19796_.m_188501_() - 0.5f));
                }
            } else {
                double size = this.m_20191_().m_82309_();
                double x = this.m_20185_() + (double)(this.f_19796_.m_188501_() - 0.5f) * size;
                double y = this.m_20186_() + size / 3.0 + (double)(this.f_19796_.m_188501_() - 0.5f) * size;
                double z = this.m_20189_() + (double)(this.f_19796_.m_188501_() - 0.5f) * size;
                for (int i = 0; i < particlesToSpawn; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123808_, x, y, z, (double)((this.f_19796_.m_188501_() - 0.5f) * 0.05f), (double)((this.f_19796_.m_188501_() + 0.5f) * 0.5f), (double)((this.f_19796_.m_188501_() - 0.5f) * 0.05f));
                }
            }
        }
    }

    public boolean m_6051_() {
        return false;
    }

    protected void m_20157_() {
    }

    public boolean m_6072_() {
        return false;
    }

    public Entity m_5489_(ServerLevel serverLevel) {
        return this;
    }

    public int m_287157_() {
        return Integer.MAX_VALUE;
    }

    public boolean m_6000_(double x, double y, double z) {
        return this.hasSpike() || this.hasSpikeCharge();
    }

    protected void m_7378_(CompoundTag compoundTag) {
        this.setSpikeTimer(compoundTag.m_128451_("spike_timer"));
        this.setSpikeChargeTimer(compoundTag.m_128451_("spike_charge_timer"));
        if (compoundTag.m_128441_("essenceController")) {
            this.setEssenceController(compoundTag.m_128342_("essenceController"));
        }
        if (compoundTag.m_128441_("essenceControllerBlockPos")) {
            this.setEssenceControllerBlockPos(NbtUtils.m_129239_((CompoundTag)compoundTag.m_128469_("essenceControllerBlockPos")));
        }
        if (compoundTag.m_128441_("essenceControllerDimension")) {
            this.setEssenceControllerDimension((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(compoundTag.m_128461_("essenceControllerDimension"))));
        }
    }

    protected void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128405_("spike_timer", this.getSpikeTimer());
        compoundTag.m_128405_("spike_charge_timer", this.getSpikeChargeTimer());
        if (this.getEssenceController() != null) {
            compoundTag.m_128362_("essenceController", this.getEssenceController());
        }
        if (this.getEssenceControllerBlockPos() != null) {
            compoundTag.m_128365_("essenceControllerBlockPos", (Tag)NbtUtils.m_129224_((BlockPos)this.getEssenceControllerBlockPos()));
        }
        if (this.getEssenceControllerDimension() != null) {
            compoundTag.m_128359_("essenceControllerDimension", this.getEssenceControllerDimension().m_135782_().toString());
        }
    }
}

