/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.fluids;

import com.telepathicgrunt.the_bumblezone.fluids.base.BzFlowingFluid;
import com.telepathicgrunt.the_bumblezone.fluids.base.FluidInfo;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public abstract class SugarWaterFluid
extends BzFlowingFluid {
    protected SugarWaterFluid(FluidInfo properties, boolean source) {
        super(properties, source);
    }

    @Override
    public Fluid m_5615_() {
        return (Fluid)BzFluids.SUGAR_WATER_FLUID_FLOWING.get();
    }

    @Override
    public Fluid m_5613_() {
        return (Fluid)BzFluids.SUGAR_WATER_FLUID.get();
    }

    @Override
    public Item m_6859_() {
        return BzItems.SUGAR_WATER_BUCKET.get();
    }

    public void m_213812_(Level level, BlockPos position, FluidState state, RandomSource random) {
        int startIndex;
        if (random.m_188499_() || !level.m_46832_(position, position)) {
            return;
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int currentIndex = startIndex = random.m_188503_(4); currentIndex < startIndex + 4; ++currentIndex) {
            Optional<Integer> agePropertyMaxAge;
            Direction direction = Direction.m_122407_((int)currentIndex);
            mutablePos.m_122190_((Vec3i)position).m_122173_(direction).m_122173_(Direction.UP);
            BlockState sideCropState = level.m_8055_((BlockPos)mutablePos);
            if (!sideCropState.m_204336_(BzTags.SUGAR_WATER_GROWS_PLANT_FASTER)) continue;
            if (sideCropState.m_60734_() instanceof SugarCaneBlock) {
                BlockState newTopSugarCaneLikeBlock;
                Optional<Integer> agePropertyMaxAge2;
                int height;
                if (level.m_8055_(mutablePos.m_7495_()).m_60734_() instanceof SugarCaneBlock) continue;
                for (height = 1; sideCropState.m_60734_() == Blocks.f_50130_ && height <= 5; ++height) {
                    sideCropState = level.m_8055_((BlockPos)mutablePos.m_122173_(Direction.UP));
                }
                if (height >= 6) continue;
                mutablePos.m_122173_(Direction.DOWN);
                BlockState topSugarCaneLikeBlock = level.m_8055_((BlockPos)mutablePos);
                Optional<Property<Integer>> blockCurrentAge = GeneralUtils.getBlockCurrentAge(topSugarCaneLikeBlock);
                if (!blockCurrentAge.isPresent() || !(agePropertyMaxAge2 = GeneralUtils.getAgePropertyMaxAge(blockCurrentAge.get())).isPresent()) continue;
                if (agePropertyMaxAge2.get().equals(topSugarCaneLikeBlock.m_61143_(blockCurrentAge.get()))) {
                    mutablePos.m_122173_(Direction.UP);
                    newTopSugarCaneLikeBlock = (BlockState)topSugarCaneLikeBlock.m_61124_(blockCurrentAge.get(), (Comparable)Integer.valueOf(0));
                    newTopSugarCaneLikeBlock = GeneralUtils.copyNonAgeProperties(topSugarCaneLikeBlock, newTopSugarCaneLikeBlock);
                    level.m_7731_((BlockPos)mutablePos, newTopSugarCaneLikeBlock, 3);
                    continue;
                }
                newTopSugarCaneLikeBlock = (BlockState)topSugarCaneLikeBlock.m_61124_(blockCurrentAge.get(), (Comparable)Integer.valueOf((Integer)topSugarCaneLikeBlock.m_61143_(blockCurrentAge.get()) + 1));
                newTopSugarCaneLikeBlock = GeneralUtils.copyNonAgeProperties(topSugarCaneLikeBlock, newTopSugarCaneLikeBlock);
                level.m_7731_((BlockPos)mutablePos, newTopSugarCaneLikeBlock, 3);
                continue;
            }
            Optional<Property<Integer>> blockCurrentAge = GeneralUtils.getBlockCurrentAge(sideCropState);
            if (!blockCurrentAge.isPresent() || !(agePropertyMaxAge = GeneralUtils.getAgePropertyMaxAge(blockCurrentAge.get())).isPresent() || agePropertyMaxAge.get().equals(sideCropState.m_61143_(blockCurrentAge.get()))) continue;
            BlockState newSideCropState = (BlockState)sideCropState.m_61124_(blockCurrentAge.get(), (Comparable)Integer.valueOf((Integer)sideCropState.m_61143_(blockCurrentAge.get()) + 1));
            newSideCropState = GeneralUtils.copyNonAgeProperties(sideCropState, newSideCropState);
            level.m_7731_((BlockPos)mutablePos, newSideCropState, 3);
        }
    }

    public void m_213811_(Level worldIn, BlockPos pos, FluidState state, RandomSource random) {
        if (!state.m_76170_() && !((Boolean)state.m_61143_((Property)f_75947_)).booleanValue()) {
            if (random.m_188503_(64) == 0) {
                worldIn.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_12540_, SoundSource.BLOCKS, random.m_188501_() * 0.25f + 0.75f, random.m_188501_() + 0.5f, false);
            }
        } else if (random.m_188503_(10) == 0) {
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123768_, (double)pos.m_123341_() + (double)random.m_188501_(), (double)pos.m_123342_() + (double)random.m_188501_(), (double)pos.m_123343_() + (double)random.m_188501_(), 0.0, 0.0, 0.0);
        }
    }

    public ParticleOptions m_7792_() {
        return ParticleTypes.f_123803_;
    }

    protected boolean m_6685_() {
        return true;
    }

    @Override
    public int m_6718_(LevelReader world) {
        return 5;
    }

    @Override
    protected float m_6752_() {
        return 100.0f;
    }

    @Override
    protected void m_7456_(LevelAccessor world, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = state.m_155947_() ? world.m_7702_(pos) : null;
        Block.m_49892_((BlockState)state, (LevelAccessor)world, (BlockPos)pos, (BlockEntity)blockEntity);
    }

    @Override
    public int m_6719_(LevelReader world) {
        return 4;
    }

    @Override
    public int m_6713_(LevelReader world) {
        return 1;
    }

    @Override
    public boolean m_6212_(Fluid fluid) {
        return fluid.m_205067_(BzTags.VISUAL_WATER_FLUID);
    }

    @Override
    public boolean m_5486_(FluidState state, BlockGetter world, BlockPos pos, Fluid fluid, Direction direction) {
        return direction == Direction.DOWN && !fluid.m_205067_(FluidTags.f_13131_);
    }

    @Override
    public BlockState m_5804_(FluidState state) {
        return (BlockState)BzFluids.SUGAR_WATER_BLOCK.get().m_49966_().m_61124_((Property)BlockStateProperties.f_61422_, (Comparable)Integer.valueOf(SugarWaterFluid.m_76092_((FluidState)state)));
    }

    public final boolean m_75972_(BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, Fluid fluid) {
        Block block = blockState.m_60734_();
        if (block instanceof LiquidBlockContainer) {
            LiquidBlockContainer liquidBlockContainer = (LiquidBlockContainer)block;
            return liquidBlockContainer.m_6044_(blockGetter, blockPos, blockState, fluid) || ((LiquidBlockContainer)block).m_6044_(blockGetter, blockPos, blockState, (Fluid)(fluid == BzFluids.SUGAR_WATER_FLUID.get() ? Fluids.f_76193_ : Fluids.f_76192_));
        }
        if (block instanceof DoorBlock || blockState.m_204336_(BlockTags.f_13068_) || blockState.m_60713_(Blocks.f_50155_) || blockState.m_60713_(Blocks.f_50130_) || blockState.m_60713_(Blocks.f_50628_)) {
            return false;
        }
        if (blockState.m_204336_(BlockTags.f_13075_) || blockState.m_60713_(Blocks.f_50454_) || blockState.m_204336_(BlockTags.f_13050_) || blockState.m_60713_(Blocks.f_50575_) || blockState.m_60713_(Blocks.f_50576_)) {
            return false;
        }
        return !blockState.m_280555_();
    }

    protected void m_6364_(LevelAccessor levelAccessor, BlockPos blockPos, BlockState blockState, Direction direction, FluidState fluidState) {
        Block block = blockState.m_60734_();
        if (block instanceof LiquidBlockContainer) {
            LiquidBlockContainer liquidBlockContainer;
            boolean canPlaceLiquid = (liquidBlockContainer = (LiquidBlockContainer)block).m_6044_((BlockGetter)levelAccessor, blockPos, blockState, fluidState.m_76152_());
            liquidBlockContainer.m_7361_(levelAccessor, blockPos, blockState, canPlaceLiquid ? fluidState : Fluids.f_76193_.m_76145_());
        } else {
            if (!blockState.m_60795_()) {
                this.m_7456_(levelAccessor, blockPos, blockState);
            }
            levelAccessor.m_7731_(blockPos, fluidState.m_76188_(), 3);
        }
    }

    public static class Source
    extends SugarWaterFluid {
        public Source(FluidInfo properties) {
            super(properties, true);
        }

        public int m_7430_(FluidState state) {
            return 8;
        }

        public boolean m_7444_(FluidState state) {
            return true;
        }

        @Override
        protected boolean m_6760_(Level level) {
            return level.m_46469_().m_46207_(GameRules.f_254725_);
        }
    }

    public static class Flowing
    extends SugarWaterFluid {
        public Flowing(FluidInfo properties) {
            super(properties, false);
            this.m_76142_((FluidState)((FluidState)this.m_76144_().m_61090_()).m_61124_((Property)f_75948_, (Comparable)Integer.valueOf(7)));
        }

        protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.m_7180_(builder);
            builder.m_61104_(new Property[]{BlockStateProperties.f_61420_});
        }

        public int m_7430_(FluidState state) {
            return (Integer)state.m_61143_((Property)BlockStateProperties.f_61420_);
        }

        public boolean m_7444_(FluidState state) {
            return false;
        }

        @Override
        protected boolean m_6760_(Level level) {
            return level.m_46469_().m_46207_(GameRules.f_254725_);
        }
    }
}

