/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.essence;

import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.items.essence.AbilityEssenceItem;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class LifeEssence
extends AbilityEssenceItem {
    private static final Supplier<Integer> cooldownLengthInTicks = () -> BzGeneralConfigs.lifeEssenceCooldown;
    private static final Supplier<Integer> abilityUseAmount = () -> BzGeneralConfigs.lifeEssenceAbilityUse;

    public LifeEssence(Item.Properties properties) {
        super(properties, cooldownLengthInTicks, abilityUseAmount);
    }

    @Override
    public int getColor() {
        return 5104939;
    }

    @Override
    void addDescriptionComponents(List<Component> components) {
        components.add((Component)Component.m_237115_((String)"item.the_bumblezone.essence_life_description_1").m_130940_(ChatFormatting.GREEN).m_130940_(ChatFormatting.ITALIC));
        components.add((Component)Component.m_237115_((String)"item.the_bumblezone.essence_life_description_2").m_130940_(ChatFormatting.GREEN).m_130940_(ChatFormatting.ITALIC));
    }

    @Override
    public void applyAbilityEffects(ItemStack stack, Level level, ServerPlayer serverPlayer) {
        if (((long)serverPlayer.f_19797_ + serverPlayer.m_20148_().getLeastSignificantBits()) % 10L == 0L && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (LifeEssence.getIsActive(stack)) {
                int radius = 16;
                this.healFriendlyNearby(stack, (Level)serverLevel, serverPlayer, radius);
                this.growNearbyPlants(stack, serverLevel, serverPlayer, radius);
                this.cureEntityOfEffects(stack, serverPlayer, (LivingEntity)serverPlayer);
            }
        }
    }

    private void healFriendlyNearby(ItemStack stack, Level level, ServerPlayer serverPlayer, int radius) {
        List entities = level.m_45933_((Entity)serverPlayer, new AABB(serverPlayer.m_20185_() - (double)radius, serverPlayer.m_20186_() - (double)radius, serverPlayer.m_20189_() - (double)radius, serverPlayer.m_20185_() + (double)radius, serverPlayer.m_20186_() + (double)radius, serverPlayer.m_20189_() + (double)radius));
        for (Entity entity : entities) {
            this.healFriendlyEntity(stack, serverPlayer, entity);
            if (!LifeEssence.getForcedCooldown(stack)) continue;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void healFriendlyEntity(ItemStack stack, ServerPlayer serverPlayer, Entity entity) {
        TamableAnimal tamableAnimal;
        if (entity instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)entity).m_21830_((LivingEntity)serverPlayer)) {
            this.healHealth(stack, serverPlayer, (LivingEntity)tamableAnimal);
            this.cureEntityOfEffects(stack, serverPlayer, (LivingEntity)tamableAnimal);
            return;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer2 = (ServerPlayer)entity;
            if (!serverPlayer.m_284548_().m_7654_().m_129799_()) {
                this.healHealth(stack, serverPlayer, (LivingEntity)serverPlayer2);
                this.cureEntityOfEffects(stack, serverPlayer, (LivingEntity)serverPlayer2);
                return;
            }
        }
        if (!(entity instanceof LivingEntity)) return;
        LivingEntity livingEntity = (LivingEntity)entity;
        if (!entity.m_7307_((Entity)serverPlayer)) return;
        this.healHealth(stack, serverPlayer, livingEntity);
        this.cureEntityOfEffects(stack, serverPlayer, livingEntity);
    }

    private void cureEntityOfEffects(ItemStack stack, ServerPlayer serverPlayer, LivingEntity livingEntity) {
        for (MobEffectInstance effect : new ArrayList(livingEntity.m_21220_())) {
            if (!GeneralUtils.isInTag(BuiltInRegistries.f_256974_, BzTags.LIFE_CURE_EFFECTS, effect.m_19544_())) continue;
            livingEntity.m_21195_(effect.m_19544_());
            this.decrementAbilityUseRemaining(stack, serverPlayer, 1);
        }
    }

    private void healHealth(ItemStack stack, ServerPlayer serverPlayer, LivingEntity livingEntity) {
        if (livingEntity.m_21223_() < livingEntity.m_21233_() && !livingEntity.m_21224_()) {
            livingEntity.m_5634_(1.0f);
            LifeEssence.spawnParticles(serverPlayer.m_284548_(), serverPlayer.m_20182_(), serverPlayer.m_217043_());
            this.decrementAbilityUseRemaining(stack, serverPlayer, 1);
        }
    }

    private void growNearbyPlants(ItemStack stack, ServerLevel level, ServerPlayer serverPlayer, int radius) {
        if (LifeEssence.getForcedCooldown(stack)) {
            return;
        }
        BlockPos playerPos = serverPlayer.m_20183_();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        ChunkPos currentCachedChunkPos = new ChunkPos(playerPos);
        LevelChunk cachedChunk = null;
        int minX = playerPos.m_123341_() - radius;
        int maxX = playerPos.m_123341_() + radius;
        int minY = Math.max(level.m_141937_(), playerPos.m_123342_() - radius);
        int maxY = Math.min(level.m_151558_() - 1, playerPos.m_123342_() + radius);
        int minZ = playerPos.m_123343_() - radius;
        int maxZ = playerPos.m_123343_() + radius;
        for (int x = minX; x <= maxX; ++x) {
            boolean foundValidXChunkSection = false;
            for (int z = minZ; z <= maxZ; ++z) {
                if (cachedChunk == null || currentCachedChunkPos.f_45578_ != SectionPos.m_123171_((int)x) || currentCachedChunkPos.f_45579_ != SectionPos.m_123171_((int)z)) {
                    currentCachedChunkPos = new ChunkPos(SectionPos.m_123171_((int)x), SectionPos.m_123171_((int)z));
                    cachedChunk = level.m_6325_(currentCachedChunkPos.f_45578_, currentCachedChunkPos.f_45579_);
                }
                boolean foundValidZChunkSection = false;
                for (int y = maxY; y >= minY; --y) {
                    if (cachedChunk.m_183278_(cachedChunk.m_151564_(y)).m_63002_(a -> a.m_204336_(BzTags.LIFE_GROW_PLANTS) && !a.m_204336_(BzTags.LIFE_FORCE_DISALLOWED_GROW_PLANT))) {
                        foundValidZChunkSection = true;
                        foundValidXChunkSection = true;
                        mutableBlockPos.m_122178_(x, y, z);
                        BlockState state = cachedChunk.m_8055_((BlockPos)mutableBlockPos);
                        this.growPlantBlock(stack, level, serverPlayer, (BlockPos)mutableBlockPos, state);
                        if (!LifeEssence.getForcedCooldown(stack)) continue;
                        return;
                    }
                    if (y == minY) continue;
                    y = Math.max(minY, SectionPos.m_123223_((int)SectionPos.m_123171_((int)y)));
                }
                if (foundValidZChunkSection || z == maxZ) continue;
                z = Math.min(maxZ, SectionPos.m_123223_((int)(SectionPos.m_123171_((int)z) + 1)));
            }
            if (foundValidXChunkSection || x == maxX) continue;
            x = Math.min(maxX, SectionPos.m_123223_((int)(SectionPos.m_123171_((int)x) + 1)));
        }
    }

    private void growPlantBlock(ItemStack stack, ServerLevel level, ServerPlayer serverPlayer, BlockPos blockPos, BlockState state) {
        if (state.m_204336_(BzTags.LIFE_GROW_PLANTS) && !state.m_204336_(BzTags.LIFE_FORCE_DISALLOWED_GROW_PLANT)) {
            BonemealableBlock bonemealableBlock;
            Block block = state.m_60734_();
            boolean grewBlock = false;
            if (!GeneralUtils.isPermissionAllowedAtSpot((Level)level, (Entity)serverPlayer, blockPos, true)) {
                return;
            }
            if (state.m_204336_(BzTags.LIFE_IS_DEAD_BUSH)) {
                List saplings = GeneralUtils.convertHoldersetToList(BuiltInRegistries.f_256975_.m_203431_(BzTags.LIFE_DEAD_BUSH_REVIVES_TO));
                saplings.removeIf(sapling -> GeneralUtils.isInTag(BuiltInRegistries.f_256975_, BzTags.LIFE_FORCE_DISALLOWED_DEAD_BUSH_REVIVES_TO, sapling));
                if (saplings.size() > 0) {
                    Block chosenSapling = (Block)saplings.get(level.f_46441_.m_188503_(saplings.size()));
                    level.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 2);
                    if (chosenSapling.m_49966_().m_60710_((LevelReader)level, blockPos)) {
                        level.m_7731_(blockPos, chosenSapling.m_49966_(), 3);
                        grewBlock = true;
                    } else {
                        level.m_7731_(blockPos, state, 2);
                    }
                }
            } else if (block instanceof CropBlock) {
                CropBlock cropBlock = (CropBlock)block;
                if (!cropBlock.m_52307_(state)) {
                    BlockState newState = cropBlock.m_52289_(cropBlock.m_52305_(state) + 1);
                    newState = LifeEssence.copyNonAgeProperties(state, newState);
                    level.m_7731_(blockPos, newState, 3);
                    grewBlock = true;
                }
            } else if (block instanceof StemBlock) {
                StemBlock stemBlock = (StemBlock)block;
                int age = (Integer)state.m_61143_((Property)StemBlock.f_57013_);
                if (age < 7) {
                    BlockState newState = (BlockState)state.m_61124_((Property)StemBlock.f_57013_, (Comparable)Integer.valueOf(age + 1));
                    newState = LifeEssence.copyNonAgeProperties(state, newState);
                    level.m_7731_(blockPos, newState, 3);
                    grewBlock = true;
                } else if (age == 7 && this.doesNotHaveFruitNearby(level, stemBlock, blockPos)) {
                    block.m_213898_(state, level, blockPos, level.m_213780_());
                    grewBlock = true;
                }
            } else if (block instanceof NetherWartBlock) {
                int age = (Integer)state.m_61143_((Property)NetherWartBlock.f_54967_);
                if (age < 3) {
                    BlockState newState = (BlockState)state.m_61124_((Property)NetherWartBlock.f_54967_, (Comparable)Integer.valueOf(age + 1));
                    newState = LifeEssence.copyNonAgeProperties(state, newState);
                    level.m_7731_(blockPos, newState, 3);
                    grewBlock = true;
                }
            } else if (state.m_60713_(Blocks.f_50685_)) {
                int age = (Integer)state.m_61143_((Property)SweetBerryBushBlock.f_57244_);
                if (age < 3) {
                    BlockState newState = (BlockState)state.m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(age + 1));
                    newState = LifeEssence.copyNonAgeProperties(state, newState);
                    level.m_7731_(blockPos, newState, 3);
                    grewBlock = true;
                }
            } else if (block instanceof BonemealableBlock && (bonemealableBlock = (BonemealableBlock)block).m_7370_((LevelReader)level, blockPos, state, false)) {
                bonemealableBlock.m_214148_(level, level.m_213780_(), blockPos, state);
                grewBlock = true;
            } else if (!state.m_204336_(BzTags.LIFE_THREE_HIGH_PILLAR_PLANT) || !level.m_8055_(blockPos.m_7494_()).m_60713_(state.m_60734_())) {
                Optional<Property<Integer>> blockCurrentAge = GeneralUtils.getBlockCurrentAge(state);
                if (blockCurrentAge.isPresent()) {
                    Optional<Integer> agePropertyMaxAge = GeneralUtils.getAgePropertyMaxAge(blockCurrentAge.get());
                    if (agePropertyMaxAge.isPresent() && !agePropertyMaxAge.get().equals(state.m_61143_(blockCurrentAge.get()))) {
                        BlockState newState = (BlockState)state.m_61124_(blockCurrentAge.get(), (Comparable)Integer.valueOf((Integer)state.m_61143_(blockCurrentAge.get()) + 1));
                        newState = GeneralUtils.copyNonAgeProperties(state, newState);
                        level.m_7731_(blockPos, newState, 3);
                        grewBlock = true;
                    } else if (state.m_204336_(BzTags.LIFE_THREE_HIGH_PILLAR_PLANT)) {
                        grewBlock = LifeEssence.growUpOneToThreeHighLimit(level, blockPos, state);
                    }
                } else if (state.m_204336_(BzTags.LIFE_THREE_HIGH_PILLAR_PLANT)) {
                    grewBlock = LifeEssence.growUpOneToThreeHighLimit(level, blockPos, state);
                }
            }
            if (grewBlock) {
                LifeEssence.spawnParticles(serverPlayer.m_284548_(), serverPlayer.m_20182_(), serverPlayer.m_217043_());
                if (level.m_213780_().m_188501_() < 0.4f) {
                    this.decrementAbilityUseRemaining(stack, serverPlayer, 1);
                }
            }
        }
    }

    @NotNull
    private static BlockState copyNonAgeProperties(BlockState oldState, BlockState newState) {
        for (Property property : newState.m_61147_()) {
            if (property.m_61708_().equalsIgnoreCase("age")) continue;
            newState = LifeEssence.copyProperty(oldState, newState, property);
        }
        return newState;
    }

    @NotNull
    private static <T extends Comparable<T>> BlockState copyProperty(BlockState state, BlockState newState, Property<T> propertyToCopy) {
        if (newState.m_61138_(propertyToCopy) && state.m_61138_(propertyToCopy)) {
            newState = (BlockState)newState.m_61124_(propertyToCopy, state.m_61143_(propertyToCopy));
        }
        return newState;
    }

    private static boolean growUpOneToThreeHighLimit(ServerLevel level, BlockPos blockPos, BlockState state) {
        int aboveOffset;
        int currentHeight = 1;
        for (aboveOffset = 1; level.m_8055_(blockPos.m_6630_(aboveOffset)).m_60713_(state.m_60734_()) && aboveOffset <= 3 && currentHeight <= 3; ++aboveOffset, ++currentHeight) {
        }
        for (int belowOffset = 1; level.m_8055_(blockPos.m_6625_(belowOffset)).m_60713_(state.m_60734_()) && belowOffset <= 3 && currentHeight <= 3; ++belowOffset, ++currentHeight) {
        }
        if (currentHeight < 3 && level.m_8055_(blockPos.m_6630_(aboveOffset)).m_60795_()) {
            level.m_7731_(blockPos.m_6630_(aboveOffset), state.m_60734_().m_49966_(), 3);
            return true;
        }
        return false;
    }

    private boolean doesNotHaveFruitNearby(ServerLevel level, StemBlock stemblock, BlockPos blockPos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState neighborState = level.m_8055_(blockPos.m_121945_(direction));
            if (!neighborState.m_60713_((Block)stemblock.m_57056_())) continue;
            return false;
        }
        return true;
    }

    public static void spawnParticles(ServerLevel world, Vec3 location, RandomSource random) {
        world.m_8767_((ParticleOptions)ParticleTypes.f_123748_, location.m_7096_(), location.m_7098_() + 1.0, location.m_7094_(), 2, random.m_188583_() * 0.2, random.m_188583_() * 0.25 + 0.1, random.m_188583_() * 0.2, (double)random.m_188501_() * 0.2 + (double)0.1f);
    }
}

