/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat.forge;

import com.telepathicgrunt.the_bumblezone.entities.BeeAggression;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import java.util.EnumSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;

public class JonnTrophiesCompat
implements ModCompat {
    private static final ResourceLocation TROPHY_RL = new ResourceLocation("trophymanager", "trophy");

    public JonnTrophiesCompat() {
        ModChecker.jonnTrophiesPresent = true;
    }

    @Override
    public EnumSet<ModCompat.Type> compatTypes() {
        return EnumSet.of(ModCompat.Type.BEE_WEARABLES_BOOSTING);
    }

    @Override
    public boolean isItemExplicitlyDisallowedFromBeeWearablesBoosting(ItemStack itemStack) {
        if (JonnTrophiesCompat.isTrophy(itemStack)) {
            return !JonnTrophiesCompat.isTrophyBeeThemed(itemStack);
        }
        return false;
    }

    public static boolean isTrophy(ItemStack itemStack) {
        return BuiltInRegistries.f_257033_.m_7981_((Object)itemStack.m_41720_()).equals((Object)TROPHY_RL);
    }

    public static boolean isTrophyBeeThemed(ItemStack itemStack) {
        if (!itemStack.m_41782_()) {
            return false;
        }
        CompoundTag trophyEntityCompound = itemStack.m_41784_().m_128469_("TrophyEntity");
        String entityType = trophyEntityCompound.m_128461_("entityType");
        if (entityType.isEmpty() || !ResourceLocation.m_135830_((String)entityType)) {
            return false;
        }
        ResourceLocation entityRL = new ResourceLocation(entityType);
        return BeeAggression.isBeelikeEntityType((EntityType)BuiltInRegistries.f_256780_.m_7745_(entityRL));
    }
}

