/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat.forge;

import com.telepathicgrunt.the_bumblezone.entities.teleportation.EntityTeleportationHookup;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import java.util.EnumSet;
import mekanism.api.MekanismAPI;
import mekanism.api.event.MekanismTeleportEvent;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.gear.ModuleData;
import mekanism.api.providers.IModuleDataProvider;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.RegistryObject;

public class MekanismCompat
implements ModCompat {
    final RegistryObject<ModuleData<?>> JETPACK_UNIT = RegistryObject.create((ResourceLocation)new ResourceLocation("mekanism", "jetpack_unit"), (ResourceKey)MekanismAPI.MODULE_REGISTRY_NAME, (String)"the_bumblezone");
    final RegistryObject<ModuleData<?>> GRAV_UNIT = RegistryObject.create((ResourceLocation)new ResourceLocation("mekanism", "gravitational_modulating_unit"), (ResourceKey)MekanismAPI.MODULE_REGISTRY_NAME, (String)"the_bumblezone");
    public static Item JETPACK;
    public static Item JETPACK_ARMORED;

    public MekanismCompat() {
        JETPACK = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation("mekanism", "jetpack"));
        JETPACK_ARMORED = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation("mekanism", "jetpack_armored"));
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(MekanismCompat::isMekaToolTeleporting);
        ModChecker.mekanismPresent = true;
    }

    @Override
    public EnumSet<ModCompat.Type> compatTypes() {
        return EnumSet.of(ModCompat.Type.HEAVY_AIR_RESTRICTED);
    }

    @Override
    public void restrictFlight(Entity entity, double extraGravity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack chestplate = player.m_6844_(EquipmentSlot.CHEST);
            if (JETPACK_ARMORED != null && chestplate.m_150930_(JETPACK_ARMORED) || JETPACK != null && chestplate.m_150930_(JETPACK)) {
                if (!player.m_36335_().m_41519_(chestplate.m_41720_()) && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.m_5661_((Component)Component.m_237115_((String)"system.the_bumblezone.denied_jetpack").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.RED), true);
                }
                player.m_36335_().m_41524_(chestplate.m_41720_(), 40);
            }
            if (player instanceof ServerPlayer) {
                IModule gravUnit;
                IModule jetpackUnit = IModuleHelper.INSTANCE.load(chestplate, (IModuleDataProvider)this.JETPACK_UNIT.get());
                if (jetpackUnit != null && jetpackUnit.isEnabled()) {
                    jetpackUnit.toggleEnabled(player, (Component)Component.m_237115_((String)"system.the_bumblezone.denied_mek_jetpack_module").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.RED));
                }
                if ((gravUnit = IModuleHelper.INSTANCE.load(chestplate, (IModuleDataProvider)this.GRAV_UNIT.get())) != null && gravUnit.isEnabled()) {
                    gravUnit.toggleEnabled(player, (Component)Component.m_237115_((String)"system.the_bumblezone.denied_mek_grav_module").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.RED));
                }
            }
        }
    }

    private static void isMekaToolTeleporting(MekanismTeleportEvent.MekaTool event) {
        Player player = event.getEntity();
        BlockHitResult blockHitResult = event.getTargetBlock();
        if (blockHitResult != null && EntityTeleportationHookup.runGenericTeleport(player, blockHitResult.m_82425_())) {
            event.setCanceled(true);
        }
    }
}

