/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.platform.BlockExtension;
import com.telepathicgrunt.the_bumblezone.utils.OptionalBoolean;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RoyalJellyBlock
extends HalfTransparentBlock
implements BlockExtension {
    protected static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    public static final MapCodec<RoyalJellyBlock> CODEC = Block.simpleCodec(RoyalJellyBlock::new);

    public RoyalJellyBlock() {
        this(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).speedFactor(0.4f).jumpFactor(0.5f).noOcclusion().sound(SoundType.HONEY_BLOCK));
    }

    public RoyalJellyBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public MapCodec<? extends RoyalJellyBlock> codec() {
        return CODEC;
    }

    @Override
    public boolean bz$isStickyBlock(BlockState state) {
        return state.getBlock() == BzBlocks.ROYAL_JELLY_BLOCK.get();
    }

    @Override
    public OptionalBoolean bz$canStickTo(BlockState state, BlockState other) {
        if (state.getBlock() == BzBlocks.ROYAL_JELLY_BLOCK.get()) {
            if (other.getBlock() == Blocks.HONEY_BLOCK || other.getBlock() == Blocks.SLIME_BLOCK) {
                return OptionalBoolean.FALSE;
            }
            return OptionalBoolean.TRUE;
        }
        return OptionalBoolean.EMPTY;
    }

    public static boolean isValidMoveDirection(Direction pushDirection, Direction pistonDirection) {
        return pushDirection == null || pushDirection != pistonDirection;
    }

    private static boolean doesEntityDoHoneyBlockSlideEffects(Entity entity) {
        return entity instanceof LivingEntity || entity instanceof AbstractMinecart || entity instanceof PrimedTnt || entity instanceof Boat;
    }

    public VoxelShape getCollisionShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }

    public void fallOn(Level level, BlockState blockState, BlockPos blockPos, Entity entity, float fallDistance) {
        entity.playSound((SoundEvent)BzSounds.ROYAL_JELLY_BLOCK_SLIDE.get(), 1.0f, 1.0f);
        if (!level.isClientSide) {
            RoyalJellyBlock.showJumpParticles((ServerLevel)level, entity);
        }
        if (entity.causeFallDamage(fallDistance, 0.2f, level.damageSources().fall())) {
            entity.playSound(this.soundType.getFallSound(), this.soundType.getVolume() * 0.5f, this.soundType.getPitch() * 0.75f);
        }
    }

    public void entityInside(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        if (this.isSlidingDown(blockPos, entity)) {
            this.maybeDoSlideAchievement(entity, blockPos);
            this.doSlideMovement(entity);
            this.maybeDoSlideEffects(level, entity);
        }
        super.entityInside(blockState, level, blockPos, entity);
    }

    private boolean isSlidingDown(BlockPos blockPos, Entity entity) {
        if (entity.onGround()) {
            return false;
        }
        if (entity.getY() > (double)blockPos.getY() + 0.9375 - 1.0E-7) {
            return false;
        }
        if (entity.getDeltaMovement().y >= -0.08) {
            return false;
        }
        double d0 = Math.abs((double)blockPos.getX() + 0.5 - entity.getX());
        double d1 = Math.abs((double)blockPos.getZ() + 0.5 - entity.getZ());
        double d2 = 0.4375 + (double)(entity.getBbWidth() / 2.0f);
        return d0 + 1.0E-7 > d2 || d1 + 1.0E-7 > d2;
    }

    private void maybeDoSlideAchievement(Entity entity, BlockPos blockPos) {
        ServerPlayer serverPlayer;
        if (entity instanceof ServerPlayer && (serverPlayer = (ServerPlayer)entity).level().getGameTime() % 20L == 17L) {
            CriteriaTriggers.HONEY_BLOCK_SLIDE.trigger(serverPlayer, serverPlayer.level().getBlockState(blockPos));
        }
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState blockState, LivingEntity entity, ItemStack itemStack) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            boolean nextToStickyPiston = false;
            for (Direction direction : Direction.values()) {
                if (!level.getBlockState(pos.relative(direction)).is(Blocks.STICKY_PISTON)) continue;
                nextToStickyPiston = true;
                break;
            }
            if (nextToStickyPiston) {
                ((GenericTrigger)((Object)BzCriterias.ROYAL_JELLY_BLOCK_PISTON_TRIGGER.get())).trigger(serverPlayer);
            }
        }
    }

    private void doSlideMovement(Entity entity) {
        Vec3 vec3 = entity.getDeltaMovement();
        if (vec3.y < -0.13) {
            double d0 = -0.05 / vec3.y;
            entity.setDeltaMovement(new Vec3(vec3.x * d0, -0.05, vec3.z * d0));
        } else {
            entity.setDeltaMovement(new Vec3(vec3.x, -0.05, vec3.z));
        }
        entity.resetFallDistance();
    }

    private void maybeDoSlideEffects(Level level, Entity entity) {
        if (RoyalJellyBlock.doesEntityDoHoneyBlockSlideEffects(entity)) {
            if (level.getRandom().nextInt(5) == 0) {
                entity.playSound((SoundEvent)BzSounds.ROYAL_JELLY_BLOCK_SLIDE.get(), 1.0f, 1.0f);
            }
            if (!level.isClientSide && level.getRandom().nextInt(5) == 0) {
                RoyalJellyBlock.showSlideParticles((ServerLevel)level, entity);
            }
        }
    }

    public static void showSlideParticles(ServerLevel serverLevel, Entity entity) {
        RoyalJellyBlock.showParticles(serverLevel, entity, 5);
    }

    public static void showJumpParticles(ServerLevel serverLevel, Entity entity) {
        RoyalJellyBlock.showParticles(serverLevel, entity, 10);
    }

    private static void showParticles(ServerLevel serverLevel, Entity entity, int particleNumber) {
        BlockState blockstate = ((Block)BzBlocks.ROYAL_JELLY_BLOCK.get()).defaultBlockState();
        for (int i = 0; i < particleNumber; ++i) {
            serverLevel.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, blockstate), entity.getX(), entity.getY(), entity.getZ(), 0.0, 0.0, 0.0);
        }
    }
}

