/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks.blockentities;

import com.telepathicgrunt.the_bumblezone.modinit.BzBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class InfinityBarrierBlockEntity
extends BlockEntity {
    public static final int DEFAULT_COLOR_1 = 0xFFFFFF;
    public static final int DEFAULT_COLOR_2 = 16770000;
    public static final String PRIMARY_COLOR_TAG = "primaryColor";
    public static final String SECONDARY_COLOR_TAG = "secondaryColor";
    private int primaryColor = 0;
    private int secondaryColor = 0;

    protected InfinityBarrierBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public InfinityBarrierBlockEntity(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)BzBlockEntities.INFINITY_BARRIER.get(), blockPos, blockState);
    }

    public int getPrimaryColor() {
        return this.primaryColor;
    }

    public void setPrimaryColor(int primaryColor) {
        this.primaryColor = primaryColor;
    }

    public int getSecondaryColor() {
        return this.secondaryColor;
    }

    public void setSecondaryColor(int secondaryColor) {
        this.secondaryColor = secondaryColor;
    }

    public void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        if (this.level != null && this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 8);
        }
        this.primaryColor = compoundTag.contains(PRIMARY_COLOR_TAG) ? compoundTag.getInt(PRIMARY_COLOR_TAG) : 0xFFFFFF;
        this.secondaryColor = compoundTag.contains(SECONDARY_COLOR_TAG) ? compoundTag.getInt(SECONDARY_COLOR_TAG) : 16770000;
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        this.saveFieldsToTag(compoundTag, provider);
    }

    private void saveFieldsToTag(CompoundTag compoundTag, HolderLookup.Provider provider) {
        compoundTag.putInt(PRIMARY_COLOR_TAG, this.primaryColor);
        compoundTag.putInt(SECONDARY_COLOR_TAG, this.secondaryColor);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.saveFieldsToTag(tag, provider);
        return tag;
    }

    public static int getBlockColor(BlockAndTintGetter world, BlockPos pos, int tintIndex) {
        BlockEntity blockEntity;
        if (world != null && (blockEntity = world.getBlockEntity(pos)) instanceof InfinityBarrierBlockEntity) {
            InfinityBarrierBlockEntity infinityBarrierBlockEntity = (InfinityBarrierBlockEntity)blockEntity;
            if (tintIndex == 0) {
                return infinityBarrierBlockEntity.getPrimaryColor();
            }
            if (tintIndex == 1) {
                return infinityBarrierBlockEntity.getSecondaryColor();
            }
        }
        return tintIndex;
    }
}

