/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.dimension;

import com.mojang.blaze3d.shaders.FogShape;
import com.telepathicgrunt.the_bumblezone.configs.BzDimensionConfigs;
import com.telepathicgrunt.the_bumblezone.effects.WrathOfTheHiveEffect;
import com.telepathicgrunt.the_bumblezone.modinit.BzDimension;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.function.Consumer;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;

public class BzDimensionSpecialEffects
extends DimensionSpecialEffects {
    public static float REDDISH_FOG_TINT = 0.0f;

    public BzDimensionSpecialEffects() {
        super(-1000000.0f, true, DimensionSpecialEffects.SkyType.NONE, false, false);
    }

    public Vec3 getBrightnessDependentFogColor(Vec3 color, float sunHeight) {
        return this.getFogColor().scale(0.003921568627451);
    }

    public boolean isFoggyAt(int camX, int camY) {
        return BzDimensionConfigs.enableDimensionFog;
    }

    public Vec3 getFogColor() {
        float colorFactor = 0.75f;
        colorFactor = BzDimensionConfigs.fogBrightnessPercentage <= 50.0 ? (float)((double)colorFactor * (BzDimensionConfigs.fogBrightnessPercentage / 50.0)) : (float)((double)colorFactor * (BzDimensionConfigs.fogBrightnessPercentage / 100.0));
        if (WrathOfTheHiveEffect.ACTIVE_WRATH && REDDISH_FOG_TINT < 0.38f) {
            REDDISH_FOG_TINT += 1.0E-5f;
        } else if (REDDISH_FOG_TINT > 0.0f) {
            REDDISH_FOG_TINT -= 1.0E-5f;
        }
        return new Vec3((double)((int)Math.min(Math.min(0.54f * colorFactor, 0.65f + REDDISH_FOG_TINT) * 255.0f, 255.0f)), (double)((int)Math.min(Math.max(Math.min(0.3f * colorFactor, 0.87f) - REDDISH_FOG_TINT * 0.6f, 0.0f) * 255.0f, 255.0f)), (double)((int)Math.min(Math.max(Math.min(0.001f * colorFactor * (colorFactor * colorFactor), 0.9f) - REDDISH_FOG_TINT * 1.9f, 0.0f) * 255.0f, 255.0f)));
    }

    public static boolean fogThicknessAdjustments(Player player, float renderDistance, boolean thickFog, FogRenderer.FogMode fogMode, FogType fogType, Consumer<Float> setFogStart, Consumer<Float> setFogEnd, Consumer<FogShape> setFogShape) {
        if (fogMode == FogRenderer.FogMode.FOG_TERRAIN && fogType == FogType.NONE && thickFog && player != null && player.level().dimension().equals(BzDimension.BZ_WORLD_KEY)) {
            for (Holder mobEffectHolder : BuiltInRegistries.MOB_EFFECT.getTagOrEmpty(BzTags.FOG_ADJUSTING_EFFECTS)) {
                if (!player.hasEffect(mobEffectHolder)) continue;
                return false;
            }
            float distanceRationAdjuster = 1.0f;
            if (renderDistance > 352.0f) {
                distanceRationAdjuster = Math.min(renderDistance / 352.0f, 1.25f);
            } else if (renderDistance < 126.0f) {
                distanceRationAdjuster = Math.max(renderDistance / 126.0f, 0.75f);
            }
            float fogStart = (float)((double)renderDistance / (BzDimensionConfigs.fogThickness * (double)distanceRationAdjuster * (double)0.3f + 1.0E-5));
            setFogStart.accept(Float.valueOf(Math.min(renderDistance, fogStart)));
            setFogEnd.accept(Float.valueOf(Math.max(renderDistance, fogStart)));
            setFogShape.accept(FogShape.CYLINDER);
            return true;
        }
        return false;
    }
}

